/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;
import org.obeonetwork.dsl.uml2.design.internal.services.OperationServices;
import org.obeonetwork.dsl.uml2.design.internal.services.SequenceServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagramServices
extends AbstractDiagramServices {
    private final SequenceServices internalService = new SequenceServices();

    public String computeLifelineCommentLabel(Lifeline lifeline) {
        ConnectableElement represent = lifeline.getRepresents();
        EList dependencies = lifeline.getClientDependencies();
        if (represent != null) {
            EObject supplier;
            EList suppliers;
            EObject container = represent.eContainer();
            if (dependencies.size() == 0) {
                if (container != null && container instanceof NamedElement) {
                    return "current container : " + ((NamedElement)container).getName();
                }
            } else if (container != null && container instanceof NamedElement && (suppliers = ((Dependency)dependencies.get(0)).getSuppliers()) != null && suppliers.size() > 0 && (supplier = (EObject)suppliers.get(0)) != null && supplier instanceof NamedElement) {
                return "current container : " + ((NamedElement)container).getName() + " context dependency: " + ((NamedElement)supplier).getName();
            }
        } else if (dependencies != null) {
            EObject container;
            EObject supplier;
            EList suppliers = ((Dependency)dependencies.get(0)).getSuppliers();
            if (dependencies.size() > 1) {
                EObject supplier2;
                if (suppliers != null && suppliers.size() > 0 && (supplier2 = (EObject)suppliers.get(0)) != null && supplier2 instanceof NamedElement) {
                    return "context dependency: " + ((NamedElement)supplier2).getName();
                }
            } else if (dependencies.size() == 1 && suppliers != null && suppliers.size() > 0 && (supplier = (EObject)suppliers.get(0)) != null && (container = supplier.eContainer()) != null && container instanceof NamedElement) {
                return "current container : " + ((NamedElement)container).getName();
            }
        }
        return null;
    }

    public void createAsynchronousMessageWithExecution(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Operation operation) {
        Element startingEndPredecessorSemanticEnd = null;
        Element finishingEndPredecessorSemanticEnd = null;
        if (startingEndPredecessor != null) {
            startingEndPredecessorSemanticEnd = (Element)startingEndPredecessor.getSemanticEnd();
        }
        if (finishingEndPredecessor != null) {
            finishingEndPredecessorSemanticEnd = (Element)finishingEndPredecessor.getSemanticEnd();
        }
        this.internalService.createAsynchronousMessage(interaction, sourceFragment, targetFragment, true, startingEndPredecessorSemanticEnd, finishingEndPredecessorSemanticEnd, operation);
    }

    private void createLifeline(Interaction interaction, Actor type) {
        Lifeline lifeline = UMLFactory.eINSTANCE.createLifeline();
        lifeline.setName(type.getName());
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName(type.getName());
        property.setType((Type)type);
        interaction.getOwnedAttributes().add((Object)property);
        lifeline.setRepresents((ConnectableElement)property);
        interaction.getLifelines().add((Object)lifeline);
    }

    public void createLifeline(Interaction interaction, NamedElement element) {
        if (!(element instanceof Class) && !(element instanceof Property)) {
            LogServices.INSTANCE.warning("An instance specification or a property must be selected to import a lifeline but you have selected " + element.getName() + " which is a " + element.getClass().getSimpleName(), null);
        }
        if (element instanceof Class) {
            this.createLifeline(interaction, (Class)element);
        } else if (element instanceof Property) {
            this.createLifeline(interaction, (Property)element);
        } else if (element instanceof Actor) {
            this.createLifeline(interaction, (Actor)element);
        }
    }

    private void createLifeline(Interaction interaction, Class type) {
        Lifeline lifeline = UMLFactory.eINSTANCE.createLifeline();
        lifeline.setName(type.getName());
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName(type.getName());
        property.setType((Type)type);
        interaction.getOwnedAttributes().add((Object)property);
        lifeline.setRepresents((ConnectableElement)property);
        interaction.getLifelines().add((Object)lifeline);
    }

    private void createLifeline(Interaction interaction, Property property) {
        Lifeline lifeline = UMLFactory.eINSTANCE.createLifeline();
        lifeline.setName(property.getName());
        lifeline.setRepresents((ConnectableElement)property);
        interaction.getLifelines().add((Object)lifeline);
    }

    public void createOperation(ExecutionSpecification execution, NamedElement startingEndPredecessor) {
        Type type = this.getType((Lifeline)execution.getCovereds().get(0));
        Operation operation = OperationServices.INSTANCE.createOperation(type);
        this.internalService.createExecution(execution.getEnclosingInteraction(), (NamedElement)execution, operation, startingEndPredecessor);
    }

    public void createOperation(Lifeline lifeline, NamedElement startingEndPredecessor) {
        Type type = this.getType(lifeline);
        Operation operation = OperationServices.INSTANCE.createOperation(type);
        this.internalService.createExecution(lifeline.getInteraction(), (NamedElement)lifeline, operation, startingEndPredecessor);
    }

    public void createOperationAndAsynchMessage(NamedElement target, NamedElement source, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        Interaction interaction;
        Type type;
        Element startingEndPredecessorSemanticEnd = null;
        if (startingEndPredecessor != null) {
            startingEndPredecessorSemanticEnd = (Element)startingEndPredecessor.getSemanticEnd();
        }
        Element finishingEndPredecessorSemanticEnd = null;
        if (finishingEndPredecessor != null) {
            finishingEndPredecessorSemanticEnd = (Element)finishingEndPredecessor.getSemanticEnd();
        }
        if (target instanceof Lifeline) {
            type = this.getType((Lifeline)target);
            interaction = ((Lifeline)target).getInteraction();
        } else {
            type = this.getType((Lifeline)((ExecutionSpecification)target).getCovereds().get(0));
            interaction = ((ExecutionSpecification)target).getEnclosingInteraction();
        }
        Operation operation = OperationServices.INSTANCE.createOperation(type);
        this.internalService.createAsynchronousMessage(interaction, source, target, true, startingEndPredecessorSemanticEnd, finishingEndPredecessorSemanticEnd, operation);
    }

    public void createOperationAndSynchMessage(NamedElement target, NamedElement source, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        Interaction interaction;
        Type type;
        Element startingEndPredecessorSemanticEnd = null;
        if (startingEndPredecessor != null) {
            startingEndPredecessorSemanticEnd = (Element)startingEndPredecessor.getSemanticEnd();
        }
        Element finishingEndPredecessorSemanticEnd = null;
        if (finishingEndPredecessor != null) {
            finishingEndPredecessorSemanticEnd = (Element)finishingEndPredecessor.getSemanticEnd();
        }
        if (target instanceof Lifeline) {
            type = this.getType((Lifeline)target);
            interaction = ((Lifeline)target).getInteraction();
        } else {
            type = this.getType((Lifeline)((ExecutionSpecification)target).getCovereds().get(0));
            interaction = ((ExecutionSpecification)target).getEnclosingInteraction();
        }
        Operation operation = OperationServices.INSTANCE.createOperation(type);
        this.internalService.createSynchronousMessage(interaction, source, target, true, startingEndPredecessorSemanticEnd, finishingEndPredecessorSemanticEnd, operation);
    }

    public void createSynchronousMessageWithExecution(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Operation operation) {
        Element startingEndPredecessorSemanticEnd = null;
        Element finishingEndPredecessorSemanticEnd = null;
        if (startingEndPredecessor != null) {
            startingEndPredecessorSemanticEnd = (Element)startingEndPredecessor.getSemanticEnd();
        }
        if (finishingEndPredecessor != null) {
            finishingEndPredecessorSemanticEnd = (Element)finishingEndPredecessor.getSemanticEnd();
        }
        this.internalService.createSynchronousMessage(interaction, sourceFragment, targetFragment, true, startingEndPredecessorSemanticEnd, finishingEndPredecessorSemanticEnd, operation);
    }

    public void delete(BehaviorExecutionSpecification execution) {
        OccurrenceSpecification finish;
        if (execution == null) {
            return;
        }
        Interaction interaction = (Interaction)execution.eContainer();
        Behavior behavior = execution.getBehavior();
        if (behavior != null) {
            interaction.getOwnedBehaviors().remove((Object)behavior);
        }
        EList fragments = interaction.getFragments();
        OccurrenceSpecification start = execution.getStart();
        if (start instanceof ExecutionOccurrenceSpecification) {
            fragments.remove(start);
        }
        if ((finish = execution.getFinish()) instanceof ExecutionOccurrenceSpecification) {
            fragments.remove(finish);
        }
        fragments.remove(execution);
    }

    public void delete(Lifeline lifeline) {
        if (lifeline == null) {
            return;
        }
        this.deleteContext(lifeline);
        for (ExecutionSpecification execution : this.executionSemanticCandidates(lifeline)) {
            if (!(execution instanceof BehaviorExecutionSpecification)) continue;
            this.delete((BehaviorExecutionSpecification)execution);
        }
        for (Message message : this.getAllMessages(lifeline)) {
            this.delete(message);
        }
        lifeline.destroy();
    }

    public void delete(Message message) {
        MessageOccurrenceSpecification sendMessage;
        if (message == null) {
            return;
        }
        Interaction interaction = (Interaction)message.eContainer();
        EList fragments = interaction.getFragments();
        MessageOccurrenceSpecification receiveMessage = (MessageOccurrenceSpecification)message.getReceiveEvent();
        if (receiveMessage != null) {
            BehaviorExecutionSpecification execution;
            Message reply;
            if (MessageSort.SYNCH_CALL_LITERAL.equals((Object)message.getMessageSort()) && (reply = this.internalService.getReplyMessage(message)) != null) {
                this.delete(reply);
            }
            if ((execution = this.internalService.getExecution((InteractionFragment)receiveMessage)) != null) {
                this.delete(execution);
            }
            fragments.remove(receiveMessage);
        }
        if ((sendMessage = (MessageOccurrenceSpecification)message.getSendEvent()) != null) {
            BehaviorExecutionSpecification execution = this.internalService.getExecution((InteractionFragment)sendMessage);
            if (execution != null) {
                this.delete(execution);
            }
            ArrayList packagedElements = new ArrayList();
            packagedElements.addAll(message.getNearestPackage().getPackagedElements());
            for (PackageableElement packageableElement : packagedElements) {
                Signal signal;
                if (!(packageableElement instanceof Signal) || !(signal = (Signal)packageableElement).getName().startsWith(message.getName())) continue;
                signal.destroy();
            }
            fragments.remove(message.getSendEvent());
        }
        interaction.getMessages().remove((Object)message);
    }

    private void deleteContext(Lifeline lifeline) {
        Object[] dependencies = lifeline.getClientDependencies().toArray();
        int i = 0;
        while (i < dependencies.length) {
            EcoreUtil.delete((EObject)((Dependency)dependencies[i]));
            ++i;
        }
    }

    public List<OccurrenceSpecification> executionSemanticCandidateOccurences(ExecutionSpecification execution) {
        List<ExecutionSpecification> executions = this.executionSemanticCandidates(execution);
        ArrayList<OccurrenceSpecification> occurrences = new ArrayList<OccurrenceSpecification>();
        occurrences.add(execution.getStart());
        occurrences.add(execution.getFinish());
        for (ExecutionSpecification subExecution : executions) {
            occurrences.add(subExecution.getStart());
            occurrences.add(subExecution.getFinish());
        }
        return occurrences;
    }

    public List<OccurrenceSpecification> executionSemanticCandidateOccurences(Lifeline lifeline) {
        List<ExecutionSpecification> executions = this.executionSemanticCandidates(lifeline);
        ArrayList<OccurrenceSpecification> occurrences = new ArrayList<OccurrenceSpecification>();
        for (ExecutionSpecification subExecution : executions) {
            occurrences.add(subExecution.getStart());
            occurrences.add(subExecution.getFinish());
        }
        return occurrences;
    }

    public List<ExecutionSpecification> executionSemanticCandidates(ExecutionSpecification execution) {
        EList fragments = execution.getEnclosingInteraction().getFragments();
        int startIndex = fragments.indexOf(execution.getStart());
        int finishIndex = fragments.indexOf(execution.getFinish());
        ArrayList<InteractionFragment> candidateFragments = new ArrayList<InteractionFragment>(fragments.subList(startIndex + 2, finishIndex));
        return this.getFirstLevelExecutions((Lifeline)execution.getCovereds().get(0), candidateFragments);
    }

    public List<ExecutionSpecification> executionSemanticCandidates(Lifeline lifeline) {
        return this.getFirstLevelExecutions(lifeline, (List<InteractionFragment>)lifeline.getInteraction().getFragments());
    }

    public NamedElement findOccurrenceSpecificationContextForReceiveEvent(Message message) {
        return this.internalService.findOccurrenceSpecificationContext((OccurrenceSpecification)message.getReceiveEvent());
    }

    public NamedElement findOccurrenceSpecificationContextForSendEvent(Message message) {
        return this.internalService.findOccurrenceSpecificationContext((OccurrenceSpecification)message.getSendEvent());
    }

    public Set<Element> getAllActorsAndContainers(EObject element) {
        Element rootContainer = (Element)EcoreUtil.getRootContainer((EObject)element);
        TreeIterator eObjects = rootContainer.eAllContents();
        HashSet<Element> result = new HashSet<Element>();
        result.add(rootContainer);
        while (eObjects.hasNext()) {
            Property property;
            Element eObject = (Element)eObjects.next();
            if (eObject instanceof Actor) {
                result.add(eObject);
                Set<Element> containers = this.getAllContainers(eObject);
                result.addAll(containers);
            }
            if (!(eObject instanceof Property) || !((property = (Property)eObject).getType() instanceof Actor)) continue;
            result.add((Element)property);
            Set<Element> containers = this.getAllContainers((Element)property);
            result.addAll(containers);
        }
        return result;
    }

    public Set<Element> getAllClassesAndContainers(Element element) {
        Element rootContainer = (Element)EcoreUtil.getRootContainer((EObject)element);
        TreeIterator eObjects = rootContainer.eAllContents();
        HashSet<Element> result = new HashSet<Element>();
        result.add(rootContainer);
        while (eObjects.hasNext()) {
            Property property;
            Element eObject = (Element)eObjects.next();
            if (eObject instanceof Class && !(eObject instanceof OpaqueBehavior)) {
                result.add(eObject);
                Set<Element> containers = this.getAllContainers(eObject);
                result.addAll(containers);
            }
            if (!(eObject instanceof Property) || !((property = (Property)eObject).getType() instanceof Class)) continue;
            result.add((Element)property);
            Set<Element> containers = this.getAllContainers((Element)property);
            result.addAll(containers);
        }
        return result;
    }

    private Set<Element> getAllContainers(Element eObject) {
        Element container = (Element)eObject.eContainer();
        HashSet<Element> result = new HashSet<Element>();
        while (container.eContainer() != null) {
            result.add(container);
            container = (Element)container.eContainer();
        }
        return result;
    }

    private List<Message> getAllMessages(Lifeline lifeline) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (lifeline != null && lifeline.getInteraction() != null) {
            for (Message message : lifeline.getInteraction().getMessages()) {
                for (Lifeline coveredLifeline : ((MessageOccurrenceSpecification)message.getSendEvent()).getCovereds()) {
                    if (!lifeline.equals(coveredLifeline)) continue;
                    messages.add(message);
                }
            }
        }
        return messages;
    }

    public List<EObject> getEndsOrdering(Interaction interaction) {
        BasicEList result = new BasicEList();
        TreeIterator eObjects = interaction.eAllContents();
        while (eObjects.hasNext()) {
            EObject eObject = (EObject)eObjects.next();
            if (eObject instanceof InteractionFragment) {
                result.add(eObject);
            }
            if (eObject instanceof CombinedFragment) {
                result.add(eObject);
            }
            if (eObject instanceof Comment) {
                result.add(eObject);
            }
            if (!(eObject instanceof InteractionOperand)) continue;
            InteractionOperand interactionOperand = (InteractionOperand)eObject;
            List<EObject> tempList = this.getOrderedInteractionOperandElements(interactionOperand);
            int i = 0;
            while (i < tempList.size()) {
                eObjects.next();
                ++i;
            }
            result.addAll(tempList);
        }
        return result;
    }

    public Set<EObject> getEndsOrdering(Interaction interaction, List<EObject> eventEnds) {
        ImmutableSet endsOrderingSet = ImmutableSet.copyOf(this.getEndsOrdering(interaction));
        ImmutableSet eventEndsSet = ImmutableSet.copyOf(eventEnds);
        Sets.SetView intersection = Sets.intersection((Set)endsOrderingSet, (Set)eventEndsSet);
        return intersection;
    }

    private List<ExecutionSpecification> getFirstLevelExecutions(Lifeline lifeline, List<InteractionFragment> candidateFragments) {
        ArrayList<ExecutionSpecification> executions = new ArrayList<ExecutionSpecification>();
        ExecutionSpecification subExec = null;
        for (InteractionFragment fragment : candidateFragments) {
            if (fragment instanceof ExecutionSpecification && fragment.getCovereds().contains((Object)lifeline)) {
                if (subExec != null) continue;
                subExec = (ExecutionSpecification)fragment;
                continue;
            }
            if (!(fragment instanceof OccurrenceSpecification) || subExec == null || !fragment.equals(subExec.getFinish())) continue;
            executions.add(subExec);
            subExec = null;
        }
        return executions;
    }

    private List<EObject> getOrderedInteractionOperandElements(InteractionOperand interactionOperand) {
        BasicEList result = new BasicEList();
        TreeIterator eObjects = interactionOperand.eAllContents();
        Comment lastElement = null;
        while (eObjects.hasNext()) {
            EObject eObject = (EObject)eObjects.next();
            if (eObject instanceof Comment) {
                lastElement = (Comment)eObject;
                continue;
            }
            result.add(eObject);
        }
        if (lastElement != null) {
            result.add(lastElement);
        }
        return result;
    }

    public String getSequenceDiagramName(Interaction interaction) {
        return LabelServices.INSTANCE.getSequenceDiagramName(interaction);
    }

    private Type getType(Lifeline target) {
        if (target.getRepresents() != null) {
            return target.getRepresents().getType();
        }
        if (target.getClientDependencies() != null && !target.getClientDependencies().isEmpty()) {
            return (Type)((InstanceSpecification)((Dependency)target.getClientDependencies().get(0)).getSuppliers().get(0)).getClassifiers().get(0);
        }
        return null;
    }

    public boolean isNotReply(Message message) {
        return !this.isReply(message);
    }

    public boolean isReply(Message message) {
        if (message == null) {
            return false;
        }
        return MessageSort.REPLY_LITERAL.equals((Object)message.getMessageSort());
    }

    public boolean isRepresentingProperty(Lifeline element) {
        return element.getRepresents() != null;
    }

    public boolean isSynchCall(Message message) {
        if (message == null) {
            return false;
        }
        return MessageSort.ASYNCH_CALL_LITERAL.equals((Object)message.getMessageSort());
    }

    public boolean isValidMessageEnd(Element element) {
        return element instanceof Lifeline && ((Lifeline)element).getRepresents() != null || element instanceof ExecutionSpecification && this.internalService.isCoveredTypeSet((ExecutionSpecification)element) || element instanceof Lifeline && ((Lifeline)element).getRepresents() != null;
    }

    public boolean isValidMessageEnd(EObject preTarget) {
        if (preTarget == null) {
            return false;
        }
        if (preTarget instanceof Lifeline) {
            return this.isValidMessageEndForLifeline(preTarget);
        }
        if (preTarget instanceof ExecutionSpecification) {
            for (Lifeline lifeline : ((ExecutionSpecification)preTarget).getCovereds()) {
                boolean result = this.isValidMessageEndForLifeline((EObject)lifeline);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidMessageEndForLifeline(EObject preTarget) {
        ConnectableElement element = ((Lifeline)preTarget).getRepresents();
        if (element != null && element.getType() != null) {
            return true;
        }
        EList dependencies = ((Lifeline)preTarget).getClientDependencies();
        for (Dependency dependency : dependencies) {
            for (NamedElement supplier : dependency.getSuppliers()) {
                if (supplier.getClass() == null) continue;
                return true;
            }
        }
        return false;
    }

    public void reorderFragment(Element fragment, EventEnd startingEndPredecessorAfter, EventEnd finishingEndPredecessorAfter) {
        InteractionFragment startingEndPredecessorAfterSemanticEnd = (InteractionFragment)startingEndPredecessorAfter.getSemanticEnd();
        InteractionFragment finishingEndPredecessorAfterSemanticEnd = (InteractionFragment)finishingEndPredecessorAfter.getSemanticEnd();
        if (fragment instanceof CombinedFragment) {
            this.internalService.reorder((CombinedFragment)fragment, startingEndPredecessorAfterSemanticEnd, finishingEndPredecessorAfterSemanticEnd);
        } else if (fragment instanceof ExecutionSpecification) {
            this.internalService.reorder((ExecutionSpecification)fragment, startingEndPredecessorAfterSemanticEnd, finishingEndPredecessorAfterSemanticEnd);
        } else if (fragment instanceof Message) {
            this.internalService.reorder((Message)fragment, startingEndPredecessorAfterSemanticEnd, finishingEndPredecessorAfterSemanticEnd);
        }
    }

    public void reorderLifeline(Lifeline movedLifeline, Lifeline predecessorBefore, Lifeline predecessorAfter) {
        Interaction ownedInteraction = movedLifeline.getInteraction();
        EList lifelines = ownedInteraction.getLifelines();
        int movedLifelineIndex = lifelines.indexOf((Object)movedLifeline);
        if (predecessorAfter != null) {
            int predecessorAfterIndex = lifelines.indexOf((Object)predecessorAfter);
            if (movedLifelineIndex > predecessorAfterIndex) {
                lifelines.move(predecessorAfterIndex + 1, (Object)movedLifeline);
                return;
            }
            if (movedLifelineIndex < predecessorAfterIndex) {
                lifelines.move(predecessorAfterIndex, (Object)movedLifeline);
                return;
            }
        } else {
            lifelines.move(0, (Object)movedLifeline);
        }
    }
}

