/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineDiagramServices
extends AbstractDiagramServices {
    public String computeDoLabel(Element element) {
        return "do " + LabelServices.INSTANCE.computeUmlLabel(element);
    }

    public String computeEntryLabel(Element element) {
        return "entry " + LabelServices.INSTANCE.computeUmlLabel(element);
    }

    public String computeExitLabel(Element element) {
        return "exit " + LabelServices.INSTANCE.computeUmlLabel(element);
    }

    public List<Transition> getInternalTransitions(State state) {
        ArrayList result = Lists.newArrayList();
        ArrayList incomings = Lists.newArrayList((Iterable)state.getIncomings());
        if (incomings == null) {
            return result;
        }
        ArrayList outgoings = Lists.newArrayList((Iterable)state.getOutgoings());
        if (outgoings == null) {
            return result;
        }
        incomings.retainAll(outgoings);
        for (Transition transition : incomings) {
            if (!TransitionKind.INTERNAL_LITERAL.equals((Object)transition.getKind())) continue;
            result.add(transition);
        }
        return result;
    }

    public boolean hasDo(State state) {
        return state.getDoActivity() != null;
    }

    public boolean hasEntry(State state) {
        return state.getEntry() != null;
    }

    public boolean hasExit(State state) {
        return state.getExit() != null;
    }

    public boolean hasNoDo(State state) {
        return !this.hasDo(state);
    }

    public boolean hasNoEntry(State state) {
        return !this.hasEntry(state);
    }

    public boolean hasNoExit(State state) {
        return !this.hasExit(state);
    }

    public boolean isChoiceState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.CHOICE_LITERAL);
    }

    public boolean isDeepHistoryState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.DEEP_HISTORY_LITERAL);
    }

    public boolean isExitPoint(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
    }

    public boolean isExternalTransition(Transition transition) {
        return !TransitionKind.INTERNAL_LITERAL.equals((Object)transition.getKind());
    }

    public boolean isForkState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.FORK_LITERAL);
    }

    public boolean isInitialState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.INITIAL_LITERAL);
    }

    public boolean isJoinState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.JOIN_LITERAL);
    }

    public boolean isJunctionState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.JUNCTION_LITERAL);
    }

    public boolean isShallowHistoryState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
    }

    public boolean isTerminateState(Pseudostate state) {
        return state.getKind().equals((Object)PseudostateKind.TERMINATE_LITERAL);
    }
}

