/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class UmlViewpoints {
    private final ViewpointRegistry registry;

    public static void enable(final Session session) {
        if (session != null) {
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointSelectionCallback selection = new ViewpointSelectionCallback();
                    for (Viewpoint previouslySelected : session.getSelectedViewpoints(false)) {
                        selection.deselectViewpoint(previouslySelected, session, (IProgressMonitor)new NullProgressMonitor());
                    }
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().reused(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().capture(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().design(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().review(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().dashboard(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().extend(), session, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
    }

    public static void enableReused(final Session session) {
        if (session != null) {
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointSelectionCallback selection = new ViewpointSelectionCallback();
                    Viewpoint reused = UmlViewpoints.fromViewpointRegistry().reused();
                    for (Viewpoint previouslySelected : session.getSelectedViewpoints(false)) {
                        if (!previouslySelected.getName().equals(reused.getName())) continue;
                        return;
                    }
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().reused(), session, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
    }

    public static UmlViewpoints fromViewpointRegistry() {
        return new UmlViewpoints(ViewpointRegistry.getInstance());
    }

    public UmlViewpoints(ViewpointRegistry registry) {
        this.registry = registry;
    }

    public Viewpoint capture() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Capture"));
    }

    public Viewpoint dashboard() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Dashboard"));
    }

    public Viewpoint design() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Design"));
    }

    public Viewpoint extend() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Extend"));
    }

    public Viewpoint reused() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Reused"));
    }

    public Viewpoint review() {
        return this.registry.getViewpoint(URI.createURI((String)"viewpoint:/org.obeonetwork.dsl.uml2.design/Review"));
    }
}

