/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.wizards;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Device;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionEnvironment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.obeonetwork.dsl.uml2.design.api.wizards.ModelElementsSelectionDialogPatternMatcher;
import org.obeonetwork.dsl.uml2.design.api.wizards.ModelFilteredTreeContentProvider;
import org.obeonetwork.dsl.uml2.design.internal.listeners.UmlDesignerSessionManagerListener;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UIServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementsSelectionDialog {
    final Map<EObject, Boolean> isOrHasDescendantCache = UmlDesignerSessionManagerListener.getDescendantCache();
    private static final Function<Object, Void> DO_NOTHING = new Function<Object, Void>(){

        public Void apply(Object from) {
            return null;
        }
    };
    protected CustomTreeSelectionDialog dialog;
    protected EObject eObject;
    protected FilteringMode mode = FilteringMode.SHOW_ONLY_DIRECT_CHILDREN;
    private final String title;
    private final String message;
    private Predicate<Object> isGrayed = Predicates.alwaysFalse();
    private Function<Object, Void> selectedAction = DO_NOTHING;
    private ModelFilteredTreeContentProvider contentProvider;
    private DDiagram diagram;

    public ModelElementsSelectionDialog(String title, String message) {
        this.title = title;
        this.message = message;
    }

    protected void applyRequestedChanges(Set<Object> selectedBefore, Set<Object> selectedAfter) {
        for (Object dde : Sets.difference(selectedAfter, selectedBefore)) {
            this.selectedAction.apply(dde);
        }
    }

    protected Option<Set<Object>> askUserForNewSelection(Shell parent, Set<Object> initialSelection) {
        this.setupDialog(parent, initialSelection);
        int result = this.dialog.open();
        if (result == 0) {
            Set<Object> selectedAfter = this.getElementsSelectedAfter();
            return Options.newSome(selectedAfter);
        }
        return Options.newNone();
    }

    private AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    private Set<Object> getAllChildren(Object parent) {
        Object[] children;
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = children = this.contentProvider.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            result.add(element);
            result.addAll(this.getAllChildren(element));
            ++n2;
        }
        return result;
    }

    protected Set<Object> getAllSelectedElements() {
        Set<Object> treeElements = this.getAllChildren(this.eObject);
        return Sets.newHashSet((Iterator)Iterators.filter(treeElements.iterator(), (Predicate)Predicates.not(this.isGrayed)));
    }

    private Predicate<Object> getDisplayablePredicate() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                if (input instanceof Element) {
                    return ModelElementsSelectionDialog.this.isOrHasDescendant((Element)input, (Predicate<Object>)ModelElementsSelectionDialog.this.isValidForDiagram());
                }
                return false;
            }
        };
    }

    protected Set<Object> getElementsSelectedAfter() {
        HashSet selectedElements = Sets.newHashSet();
        for (Object obj : this.dialog.checkedElements) {
            selectedElements.add(obj);
        }
        return selectedElements;
    }

    private Predicate<Object> getValidsForClassDiagram() {
        Predicate<Object> validForClassDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package || input instanceof Interface || input instanceof DataType || "Class".equals(((EObject)input).eClass().getName()) || "Component".equals(((EObject)input).eClass().getName());
            }
        };
        return validForClassDiagram;
    }

    private Predicate<Object> getValidsForComponentDiagram() {
        Predicate<Object> validForComponentDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package || input instanceof Interface || "Class".equals(((EObject)input).eClass().getName()) || "Component".equals(((EObject)input).eClass().getName());
            }
        };
        return validForComponentDiagram;
    }

    private Predicate<Object> getValidsForCompositeDiagram() {
        Predicate<Object> validForCompositeDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                if (input instanceof StructuredClassifier) {
                    return !(input instanceof Interaction) && !(input instanceof StateMachine) && !(input instanceof Activity);
                }
                return input instanceof Package || input instanceof Interface || "Port".equals(((EObject)input).eClass().getName()) || "Property".equals(((EObject)input).eClass().getName());
            }
        };
        return validForCompositeDiagram;
    }

    private Predicate<Object> getValidsForCompositeStructureDiagram(final EObject container) {
        Predicate<Object> validForCompositeDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return "Property".equals(((EObject)input).eClass().getName()) && container.equals(((EObject)input).eContainer());
            }
        };
        return validForCompositeDiagram;
    }

    private Predicate<Object> getValidsForDeploymentDiagram() {
        Predicate<Object> validForDeploymentDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package && !(input instanceof Profile) || input instanceof ExecutionEnvironment || input instanceof Node || input instanceof Artifact || input instanceof Device || input instanceof Component;
            }
        };
        return validForDeploymentDiagram;
    }

    private Predicate<Object> getValidsForPackageDiagram() {
        Predicate<Object> validForPackageDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package;
            }
        };
        return validForPackageDiagram;
    }

    private Predicate<Object> getValidsForUseCaseDiagram() {
        Predicate<Object> validForUseCaseDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package || input instanceof Class || input instanceof Component || input instanceof Artifact || input instanceof DataType || input instanceof Interface || input instanceof Collaboration || input instanceof UseCase;
            }
        };
        return validForUseCaseDiagram;
    }

    protected void initContentProvider() {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        this.contentProvider = new ModelFilteredTreeContentProvider(adapterFactory, this.getDisplayablePredicate());
    }

    private boolean isOrHasDescendant(Element element, Predicate<Object> predicate) {
        if (this.isOrHasDescendantCache.containsKey(element)) {
            return this.isOrHasDescendantCache.get(element);
        }
        if (predicate.apply((Object)element)) {
            this.isOrHasDescendantCache.put((EObject)element, true);
            return true;
        }
        EList elements = element.getOwnedElements();
        for (Element ownedElement : elements) {
            if (predicate.apply((Object)ownedElement)) {
                this.isOrHasDescendantCache.put((EObject)element, true);
                return true;
            }
            this.isOrHasDescendantCache.put((EObject)element, false);
        }
        return false;
    }

    private Predicate<Object> isValidForDiagram() {
        Predicate<Object> results = Predicates.alwaysTrue();
        if (this.diagram instanceof DSemanticDiagram) {
            DiagramDescription description = ((DSemanticDiagram)this.diagram).getDescription();
            if ("Class Diagram".equals(description.getName()) || "Profile Diagram".equals(description.getName())) {
                results = this.getValidsForClassDiagram();
            } else if ("Component Diagram".equals(description.getName())) {
                results = this.getValidsForComponentDiagram();
            } else if ("Composite Diagram".equals(description.getName())) {
                results = this.getValidsForCompositeDiagram();
            } else if ("Composite Structure Diagram".equals(description.getName())) {
                results = this.getValidsForCompositeStructureDiagram(((DSemanticDiagram)this.diagram).getTarget());
            } else if ("Deployment Diagram".equals(description.getName())) {
                results = this.getValidsForDeploymentDiagram();
            } else if ("Package Hierarchy".equals(description.getName())) {
                results = this.getValidsForPackageDiagram();
            } else if ("Use Case Diagram".equals(description.getName())) {
                results = this.getValidsForUseCaseDiagram();
            }
        }
        return results;
    }

    public List<Object> open(Shell parent, EObject selectedContainer, DDiagram ddiagram, boolean includeNodeLabel) {
        ArrayList result = Lists.newArrayList();
        this.eObject = selectedContainer;
        this.diagram = ddiagram;
        this.initContentProvider();
        Set<Object> allSelectedElements = Collections.unmodifiableSet(this.getAllSelectedElements());
        Option<Set<Object>> response = this.askUserForNewSelection(parent, allSelectedElements);
        if (response.some()) {
            Set selectedAfter = (Set)response.get();
            result.addAll(selectedAfter);
        }
        this.eObject = null;
        this.dialog = null;
        this.contentProvider = null;
        return result;
    }

    public void setGrayedPredicate(Predicate<EObject> isGrayedPredicate) {
        this.isGrayed = Predicates.and((Predicate)(isGrayedPredicate != null ? isGrayedPredicate : Predicates.alwaysFalse()), this.isValidForDiagram());
    }

    public void setSelectedAction(Function<Object, Void> selectedAction) {
        this.selectedAction = selectedAction;
    }

    protected void setupDialog(Shell parent, Set<Object> initialSelection) {
        this.dialog = new CustomTreeSelectionDialog(parent, (ILabelProvider)new SelectionDialogLabelProvider(), (ITreeContentProvider)this.contentProvider);
        this.dialog.setTitle(this.title);
        String msg = this.message;
        if (!Predicates.alwaysFalse().equals(this.isGrayed)) {
            StringBuilder sb = new StringBuilder(this.message);
            sb.append("\n");
            sb.append("The wizard will have no effect on grayed elements.");
            msg = sb.toString();
        }
        this.dialog.setMessage(msg);
        Collection<Element> roots = ElementServices.INSTANCE.getAllRootsInSession(this.eObject);
        this.dialog.setInput(roots);
        this.dialog.addFilter(new ModeFilter());
        this.dialog.setInitialElementSelections(Lists.newArrayList(initialSelection));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class CustomTreeSelectionDialog
    extends CheckedTreeSelectionDialog {
        public static final String REGEXP_TOOL_TIP = "Expression that will be used to filer elements by name (for example 'abc', 'a?c', '*c'...)";
        private static final String REGEXP_TITLE = "Filter elements by name";
        private static final String REGEXP_EXPLANATIONS = "? = any character, * = any String";
        protected ModelElementsSelectionDialogPatternMatcher patternMatcher;
        private final Set<Object> checkedElements;

        private CustomTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.checkedElements = Sets.newHashSet();
            this.patternMatcher = new ModelElementsSelectionDialogPatternMatcher("");
        }

        private Button addButton(Composite parent, String toolTipText, Image image, SelectionListener action) {
            Button button = new Button(parent, 8);
            button.setToolTipText(toolTipText);
            button.setImage(image);
            button.addSelectionListener(action);
            return button;
        }

        private void checkAll() {
            Collection roots = (Collection)this.getTreeViewer().getInput();
            this.setRecursiveState(roots, true);
        }

        private void collapseAll() {
            this.getTreeViewer().collapseAll();
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getTreeViewer().setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return CustomTreeSelectionDialog.this.checkedElements.contains(element);
                }

                public boolean isGrayed(Object element) {
                    return ModelElementsSelectionDialog.this.isGrayed.apply(element);
                }
            });
            this.getTreeViewer().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (!ModelElementsSelectionDialog.this.isGrayed.apply(event.getElement())) {
                        if (event.getChecked()) {
                            CustomTreeSelectionDialog.this.checkedElements.add(event.getElement());
                        } else {
                            CustomTreeSelectionDialog.this.checkedElements.remove(event.getElement());
                        }
                    }
                }
            });
            this.getTreeViewer().expandToLevel(2);
            return result;
        }

        protected Label createMessageArea(Composite composite) {
            Label createMessageArea = super.createMessageArea(composite);
            this.createSelectionButtonsAfterMessageArea(composite);
            this.createRegexpTypeZone(composite);
            return createMessageArea;
        }

        private void createRegexpTypeZone(Composite composite) {
            Group expregGroup = new Group(composite, 0);
            expregGroup.setText(REGEXP_TITLE);
            GridLayout expregLayout = new GridLayout();
            expregGroup.setLayout((Layout)expregLayout);
            expregGroup.setFont(composite.getFont());
            expregGroup.setLayoutData((Object)new GridData(768));
            Label explanationsLabel = new Label((Composite)expregGroup, 0);
            explanationsLabel.setText(REGEXP_EXPLANATIONS);
            Text regularExpressionText = new Text((Composite)expregGroup, 2048);
            regularExpressionText.setToolTipText(REGEXP_TOOL_TIP);
            regularExpressionText.setLayoutData((Object)new GridData(768));
            regularExpressionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String typedRegex = ((Text)e.getSource()).getText();
                    CustomTreeSelectionDialog.this.setPatternMatcher(new ModelElementsSelectionDialogPatternMatcher(typedRegex));
                    CustomTreeSelectionDialog.this.updateFilteringMode(((CustomTreeSelectionDialog)CustomTreeSelectionDialog.this).ModelElementsSelectionDialog.this.mode);
                }
            });
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072){

                public Point computeSize(int wHint, int hHint, boolean b) {
                    return super.computeSize(0, 0, b);
                }
            };
            buttonComposite.setVisible(false);
            return buttonComposite;
        }

        protected Composite createSelectionButtonsAfterMessageArea(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072);
            GridLayout layout = new GridLayout();
            layout.numColumns = 7;
            layout.makeColumnsEqualWidth = false;
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setFont(composite.getFont());
            GridData data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            composite.setData((Object)data);
            new Label(buttonComposite, 16384).setText("Show");
            final Combo choices = new Combo(buttonComposite, 8);
            choices.add(FilteringMode.SHOW_ONLY_DIRECT_CHILDREN.getName());
            choices.add(FilteringMode.SHOW_ONLY_UNDISPLAYED_ELEMENTS.getName());
            choices.add(FilteringMode.SHOW_ALL.getName());
            choices.select(0);
            choices.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    switch (choices.getSelectionIndex()) {
                        case 0: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_DIRECT_CHILDREN);
                            break;
                        }
                        case 1: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_UNDISPLAYED_ELEMENTS);
                            break;
                        }
                        case 2: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ALL);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
            });
            data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            choices.setLayoutData((Object)data);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            this.addButton(buttonComposite, "Check All", DiagramUIPlugin.getPlugin().getBundledImage("icons/enabled_co.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.checkAll();
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, "Uncheck All", DiagramUIPlugin.getPlugin().getBundledImage("icons/disabled_co.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.uncheckAll();
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, "Expand All", DiagramUIPlugin.getPlugin().getBundledImage("icons/expandall.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.expandAll();
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, "Collapse All", DiagramUIPlugin.getPlugin().getBundledImage("icons/collapseall.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.collapseAll();
                }
            }).setLayoutData((Object)data);
            return buttonComposite;
        }

        private void expandAll() {
            this.getTreeViewer().expandAll();
        }

        public Set<Object> getCheckedElements() {
            return this.checkedElements;
        }

        public Predicate<Object> getRegexpMatchPredicate() {
            return this.patternMatcher.getMatchPredicate();
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsAllMode(Object element) {
            return this.isOrHasDescendant(element, this.getRegexpMatchPredicate());
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsCheckedMode(Object element) {
            Predicate isCheckedElementPredicate = Predicates.in(this.checkedElements);
            Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
            return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isCheckedElementPredicate, isMatchinExpregPredicate));
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsSubMode(Object element) {
            if (element instanceof EObject) {
                ArrayList subElements = Lists.newArrayList();
                Iterators.addAll((Collection)subElements, (Iterator)Iterators.filter((Iterator)ModelElementsSelectionDialog.this.eObject.eAllContents(), (Predicate)Predicates.instanceOf(Element.class)));
                Predicate isSubElementPredicate = Predicates.in((Collection)subElements);
                Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
                return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isSubElementPredicate, isMatchinExpregPredicate));
            }
            return false;
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsUncheckedMode(Object element) {
            Predicate isUncheckedElementPredicate = Predicates.not((Predicate)Predicates.in(this.checkedElements));
            Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
            return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isUncheckedElementPredicate, isMatchinExpregPredicate));
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsUnrepresentedMode(Object element) {
            if (element instanceof EObject) {
                Collection<EObject> existingElementsOnDiagram = UIServices.INSTANCE.getDisplayedNodes(ModelElementsSelectionDialog.this.diagram);
                Predicate isSubElementPredicate = Predicates.not((Predicate)Predicates.in(existingElementsOnDiagram));
                Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
                return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isSubElementPredicate, isMatchinExpregPredicate));
            }
            return false;
        }

        private boolean isOrHasDescendant(Object element, final Predicate<Object> pred) {
            boolean matches = pred.apply(element);
            if (matches) {
                return true;
            }
            return Iterables.any(Arrays.asList(ModelElementsSelectionDialog.this.contentProvider.getChildren(element)), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return CustomTreeSelectionDialog.this.isOrHasDescendant(input, (Predicate<Object>)pred);
                }
            });
        }

        public void refresh() {
            this.getTreeViewer().refresh();
        }

        public void setInitialElementSelections(List selectedElements) {
            ArrayList filteredSeletection = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selectedElements, (Predicate)Predicates.not((Predicate)ModelElementsSelectionDialog.this.isGrayed)));
            this.checkedElements.addAll(filteredSeletection);
            super.setInitialElementSelections((List)filteredSeletection);
        }

        public void setInitialSelections(Object[] selectedElements) {
            this.setInitialElementSelections(Lists.newArrayList((Object[])selectedElements));
        }

        public void setPatternMatcher(ModelElementsSelectionDialogPatternMatcher patternMatcher) {
            this.patternMatcher = patternMatcher;
        }

        private void setRecursiveState(Collection<Object> elements, boolean state) {
            for (Object element : elements) {
                this.setRecursiveState(element, state);
            }
        }

        private void setRecursiveState(Object element, boolean state) {
            this.getTreeViewer().setChecked(element, state);
            if (!ModelElementsSelectionDialog.this.isGrayed.apply(element)) {
                if (state) {
                    this.checkedElements.add(element);
                } else {
                    this.checkedElements.remove(element);
                }
            }
            Object[] objectArray = ModelElementsSelectionDialog.this.contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setRecursiveState(child, state);
                ++n2;
            }
        }

        private void uncheckAll() {
            Collection roots = (Collection)this.getTreeViewer().getInput();
            this.setRecursiveState(roots, false);
        }

        public void updateFilteringMode(FilteringMode filteringMode) {
            ModelElementsSelectionDialog.this.mode = filteringMode;
            this.refresh();
            this.getTreeViewer().expandToLevel(2);
            this.getTreeViewer().setAllChecked(false);
            for (Object element : this.checkedElements) {
                this.getTreeViewer().setChecked(element, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilteringMode {
        SHOW_ALL("all elements"),
        SHOW_ONLY_DIRECT_CHILDREN("only direct children"),
        SHOW_ONLY_UNDISPLAYED_ELEMENTS("only undisplayed elements");

        private final String name;

        private FilteringMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class ModeFilter
    extends ViewerFilter {
        private ModeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean show = true;
            switch (ModelElementsSelectionDialog.this.mode) {
                case SHOW_ALL: {
                    show = ModelElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsAllMode(element);
                    break;
                }
                case SHOW_ONLY_DIRECT_CHILDREN: {
                    show = ModelElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsSubMode(element);
                    break;
                }
                case SHOW_ONLY_UNDISPLAYED_ELEMENTS: {
                    show = ModelElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsUnrepresentedMode(element);
                    break;
                }
                default: {
                    show = true;
                }
            }
            return show;
        }
    }

    private class SelectionDialogLabelProvider
    extends SiriusCommonLabelProvider {
        private SelectionDialogLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Color foreground = null;
            if (ModelElementsSelectionDialog.this.isGrayed.apply(element)) {
                foreground = VisualBindingManager.getDefault().getColorFromName("light_gray");
            }
            return foreground;
        }
    }
}

