/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateRepresentationWizard;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateSessionResourceWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class UmlInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;
    private IStructuredSelection selection;

    private Session createSession() {
        final CreateSessionResourceWizard wizard = new CreateSessionResourceWizard(this.selection);
        wizard.init(PlatformUI.getWorkbench(), this.selection);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("Create Representation File");
        if (dialog.open() == 0) {
            wizard.getCreatedSession().getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(wizard.getCreatedSession().getTransactionalEditingDomain()){

                protected void doExecute() {
                    wizard.getCreatedSession().addSemanticResource(UmlInitDiagramFileAction.this.domainModelURI, (IProgressMonitor)new NullProgressMonitor());
                }
            });
            return wizard.getCreatedSession();
        }
        return null;
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    protected void openCreateRepresentationWizard(Session existingSession) {
        CreateRepresentationWizard wizard = new CreateRepresentationWizard(existingSession);
        wizard.init();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("Create Representation Wizard");
        dialog.open();
    }

    public void run(IAction action) {
        Session existingSession = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            ResourceSet set = session.getTransactionalEditingDomain().getResourceSet();
            for (Resource res : set.getResources()) {
                if (res.getURI() == null || !set.getURIConverter().normalize(res.getURI()).equals(set.getURIConverter().normalize(this.domainModelURI))) continue;
                existingSession = session;
            }
        }
        if (existingSession == null) {
            existingSession = this.createSession();
        }
        if (existingSession != null) {
            this.openCreateRepresentationWizard(existingSession);
        }
    }

    public void selectionChanged(IAction action, ISelection selectionChanged) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selectionChanged instanceof IStructuredSelection) || selectionChanged.isEmpty()) {
            return;
        }
        this.selection = (IStructuredSelection)selectionChanged;
        IFile file = (IFile)((IStructuredSelection)selectionChanged).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        action.setEnabled(true);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

