/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.obeonetwork.dsl.uml2.design.internal.services.CreateElementLabelFromModelExplorerSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateDiagram<T extends PackageableElement>
extends AbstractHandler {
    private Session collectSessionAndFillSelection(ISelection selection, List<Package> selected) {
        Session session = null;
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Package) {
                    selected.add((Package)obj);
                    if (session == null) {
                        session = SessionManager.INSTANCE.getSession((EObject)obj);
                    }
                }
                ++n2;
            }
        }
        return session;
    }

    protected abstract T createSemanticObject();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<Package> packages;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Session session = this.collectSessionAndFillSelection(selection, packages = new ArrayList<Package>());
        if (session != null) {
            RecordingCommand cmd = new RecordingCommand(session.getTransactionalEditingDomain(), "Create Diagram"){

                protected void doExecute() {
                    for (Package pkg : packages) {
                        Object semanticElement = AbstractCreateDiagram.this.createSemanticObject();
                        pkg.getPackagedElements().add(semanticElement);
                        semanticElement.setName(new CreateElementLabelFromModelExplorerSwitch().getNewLabel((EObject)semanticElement));
                        RepresentationDescription diagDescription = AbstractCreateDiagram.this.getDiagramDescription(session, semanticElement);
                        String representationName = AbstractCreateDiagram.this.getRepresentationName(diagDescription, AbstractCreateDiagram.this.getDiagramLabel(semanticElement));
                        if (representationName == null) continue;
                        DRepresentation representation = DialectManager.INSTANCE.createRepresentation(representationName, semanticElement, diagDescription, session, (IProgressMonitor)new NullProgressMonitor());
                        DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
        }
        return null;
    }

    protected abstract RepresentationDescription getDiagramDescription(Session var1, T var2);

    protected abstract String getDiagramLabel(T var1);

    protected String getRepresentationName(RepresentationDescription description, String defaultName) {
        String descriptionLabel = null;
        if (description.getEndUserDocumentation() != null && description.getEndUserDocumentation().trim().length() > 0) {
            descriptionLabel = String.valueOf(Messages.createRepresentationInputDialog_RepresentationDescriptionLabel) + description.getEndUserDocumentation();
        }
        descriptionLabel = descriptionLabel == null ? "" : String.valueOf(descriptionLabel) + "\n\n";
        descriptionLabel = String.valueOf(descriptionLabel) + Messages.createRepresentationInputDialog_NewRepresentationNameLabel;
        InputDialog askViewPointName = new InputDialog(Display.getDefault().getActiveShell(), Messages.createRepresentationInputDialog_Title, descriptionLabel, defaultName, new IInputValidator(){

            public String isValid(String newText) {
                return null;
            }
        });
        if (askViewPointName.open() == 0) {
            return askViewPointName.getValue();
        }
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }
}

