/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.obeonetwork.dsl.uml2.design.internal.commands.UmlElementConverter;
import org.obeonetwork.dsl.uml2.design.internal.services.DashboardServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

public class DashboardContributionItems
extends CompoundContributionItem {
    public static final String OPEN_DASHBOARD_CMD_ID = "org.obeonetwork.dsl.uml2.actions.openDashboard";
    public static final String OPEN_DASHBOARD_CMD_PARAM_MODEL_KEY = "org.obeonetwork.dsl.uml2.actions.openDashboard.param.model";

    public DashboardContributionItems() {
    }

    public DashboardContributionItems(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList menuItems = Lists.newArrayList();
        List<EObject> umlModelRoots = DashboardServices.INSTANCE.getUmlModelsWithDashboard();
        for (EObject eObject : umlModelRoots) {
            IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(eObject.eResource().getURI().toPlatformString(true)));
            String projectName = resourceFile.getProject().getName();
            HashMap parameters = Maps.newHashMap();
            UmlElementConverter converter = new UmlElementConverter();
            try {
                parameters.put(OPEN_DASHBOARD_CMD_PARAM_MODEL_KEY, converter.convertToString(eObject));
            }
            catch (ParameterValueConversionException e) {
                LogServices.INSTANCE.error("Opening dashboard for project " + projectName + " failed", e);
            }
            CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, OPEN_DASHBOARD_CMD_ID, (Map)parameters, null, null, null, projectName, null, "Open the dashboard of the project : " + projectName, 8, null, true);
            contributionParameter.visibleEnabled = true;
            CommandContributionItem commandContributionItem = new CommandContributionItem(contributionParameter);
            menuItems.add(commandContributionItem);
        }
        return menuItems.toArray(new IContributionItem[menuItems.size()]);
    }
}

