/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ConfirmDeletionTreeContentProvider;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ConfirmDeletionTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmDeletionDialog
extends MessageDialog {
    private ModeFilter filter;
    private TreeViewer treeViewer;
    private final ConfirmDeletionTreeLabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private final int width = 60;
    private final int height = 18;
    protected FilteringMode mode = FilteringMode.SHOW_ONLY_DELETED_ELEMENTS;

    public ConfirmDeletionDialog(final Map<EObject, Object> allDetachedObjects) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Deletion", null, "The following red elements will be updated/deleted. Confirm deletion ?", 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        this.initContentProvider(allDetachedObjects.values());
        this.labelProvider = new ConfirmDeletionTreeLabelProvider();
        Predicate<Object> isDeletedPredicate = new Predicate<Object>(){

            public boolean apply(Object input) {
                return allDetachedObjects.keySet().contains(input);
            }
        };
        this.labelProvider.setDeletedPredicate(isDeletedPredicate);
        this.filter = new ModeFilter(isDeletedPredicate);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.treeViewer = this.createTreeViewer(composite);
        this.treeViewer.expandAll();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        Tree treeWidget = this.treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.createSelectionButtonsAfterMessageArea(composite);
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected Composite createSelectionButtonsAfterMessageArea(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        new Label(buttonComposite, 16384).setText("Show");
        final Combo choices = new Combo(buttonComposite, 8);
        choices.add(FilteringMode.SHOW_ONLY_DELETED_ELEMENTS.getName());
        choices.add(FilteringMode.SHOW_ALL.getName());
        choices.select(0);
        choices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (choices.getSelectionIndex()) {
                    case 0: {
                        ConfirmDeletionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_DELETED_ELEMENTS);
                        break;
                    }
                    case 1: {
                        ConfirmDeletionDialog.this.updateFilteringMode(FilteringMode.SHOW_ALL);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        });
        data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        choices.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        return buttonComposite;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Collection<EObject> roots = this.getAllRootsInSessions();
        HashSet inputs = Sets.newHashSet();
        inputs.addAll(roots);
        this.treeViewer.addFilter((ViewerFilter)this.filter);
        this.treeViewer.setInput((Object)inputs);
        return this.treeViewer;
    }

    private AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    private Collection<EObject> getAllRootsInSessions() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            for (Resource childRes : session.getSemanticResources()) {
                for (EObject eObject : childRes.getContents()) {
                    if (!(eObject instanceof Element)) continue;
                    roots.add(eObject);
                }
            }
        }
        return roots;
    }

    protected void initContentProvider(Collection<Object> notifications) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        this.contentProvider = new ConfirmDeletionTreeContentProvider(adapterFactory, notifications);
    }

    private boolean isOrHasDescendant(Object element, final Predicate<Object> pred) {
        boolean matches = pred.apply(element);
        if (matches) {
            return true;
        }
        return Iterables.any(Arrays.asList(this.contentProvider.getChildren(element)), (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return ConfirmDeletionDialog.this.isOrHasDescendant(input, (Predicate<Object>)pred);
            }
        });
    }

    public boolean openConfirm() {
        int[] result = new int[]{super.open()};
        return result[0] == 0;
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void updateFilteringMode(FilteringMode filteringMode) {
        this.mode = filteringMode;
        this.refresh();
        this.treeViewer.expandAll();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilteringMode {
        SHOW_ALL("all elements"),
        SHOW_ONLY_DELETED_ELEMENTS("only deleted elements");

        private final String name;

        private FilteringMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModeFilter
    extends ViewerFilter {
        Predicate<Object> isDeletedPredicate;

        public ModeFilter(Predicate<Object> isDeletedPredicate) {
            this.isDeletedPredicate = isDeletedPredicate;
        }

        private boolean isMatchingOrHasMatchingDescendantsOnlyDeletedElementsMode(Object element) {
            if (element instanceof EObject) {
                return ConfirmDeletionDialog.this.isOrHasDescendant(element, (Predicate<Object>)this.isDeletedPredicate);
            }
            return false;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean show = true;
            switch (ConfirmDeletionDialog.this.mode) {
                case SHOW_ONLY_DELETED_ELEMENTS: {
                    show = this.isMatchingOrHasMatchingDescendantsOnlyDeletedElementsMode(element);
                    break;
                }
                default: {
                    show = true;
                }
            }
            return show;
        }
    }
}

