/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ImportMetaclassDialog;
import org.obeonetwork.dsl.uml2.design.internal.services.ProfileServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraAssociationSelectionDialog
extends ImportMetaclassDialog {
    private final Element source;
    private final Element target;
    private String associationName = "associationName";
    private final ArrayList<EObject> possibleMetaClassRelationShip;

    public ExtraAssociationSelectionDialog(Shell shell, Profile profile, Element source, Element target) {
        this(shell, profile, source, target, true);
    }

    public ExtraAssociationSelectionDialog(Shell shell, Profile profile, Element source, Element target, boolean multi) {
        super(shell, profile, multi);
        this.source = source;
        this.target = target;
        this.setTitle("Extend existing RelationShip");
        this.refresh();
        this.possibleMetaClassRelationShip = (ArrayList)this.getAllPossibleMetaclassRelationShip((Type)((Class)source), (Type)((Class)target));
    }

    protected String basicAssociationName(Element sourceStereotype, Element targetStereotype) {
        if (sourceStereotype instanceof NamedElement && targetStereotype instanceof NamedElement) {
            this.associationName = String.valueOf(((NamedElement)sourceStereotype).getName()) + "To" + ((NamedElement)targetStereotype).getName();
        }
        return this.associationName;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setHeaderMessageText("Give a name to the stereotype and select the relationship metaclass that will be extended by this stereotype.");
        Composite dialogArea1 = (Composite)super.createDialogArea(parent);
        Composite compositeHeaderMessage = this.getCompositeHeaderMessage();
        GridLayout layout = (GridLayout)compositeHeaderMessage.getLayout();
        layout.numColumns = 2;
        compositeHeaderMessage.setLayout((Layout)layout);
        Label headerLabelAssociationName = new Label(compositeHeaderMessage, 0);
        headerLabelAssociationName.setText("Stereotype name:");
        Text associationNameMessage = new Text(compositeHeaderMessage, 128);
        associationNameMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object src;
                if (e != null && (src = e.getSource()) instanceof Text) {
                    Text txt = (Text)src;
                    String myText = txt.getText();
                    ExtraAssociationSelectionDialog.this.associationName = myText;
                    Button okButton = ExtraAssociationSelectionDialog.this.getOkButton();
                    if (okButton != null) {
                        okButton.setEnabled(ExtraAssociationSelectionDialog.this.associationName.length() != 0);
                    }
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        associationNameMessage.setLayoutData((Object)gridData);
        compositeHeaderMessage.setLayoutData((Object)gridData);
        associationNameMessage.setText(this.basicAssociationName(this.source, this.target));
        parent.getParent().getShell().setMinimumSize(710, 700);
        this.applyFilter();
        return dialogArea1;
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return super.createExtendedContentArea(parent);
    }

    @Override
    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.possibleMetaClassRelationShip != null) {
            progressMonitor.beginTask("Searching", this.possibleMetaClassRelationShip.size());
            Iterator<EObject> iter = this.possibleMetaClassRelationShip.iterator();
            while (iter.hasNext()) {
                contentProvider.add((Object)iter.next(), itemsFilter);
                progressMonitor.worked(1);
            }
        }
        progressMonitor.done();
    }

    protected List<Class> getAllExtendedMetaClasses(Class stereotypeClass) {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (stereotypeClass instanceof Stereotype) {
            Stereotype stereotype = (Stereotype)stereotypeClass;
            for (Property property : stereotype.getOwnedAttributes()) {
                if (property.getAssociation() == null || !(property.getAssociation() instanceof Extension) || !property.getName().equals("base_" + property.getType().getName())) continue;
                Class metaClass = (Class)property.getType();
                classes.add(metaClass);
                for (Class superClass : ProfileServices.INSTANCE.getAllSuperClasses(metaClass)) {
                    if (ProfileServices.INSTANCE.isIn(superClass, classes)) continue;
                    classes.add(superClass);
                }
            }
        } else {
            classes.add(stereotypeClass);
            return classes;
        }
        return classes;
    }

    protected List<EObject> getAllPossibleMetaclassRelationShip(Type stereotypeSource, Type stereotypeTarget) {
        ArrayList<EObject> eligibleRelationShips = new ArrayList<EObject>();
        List<Class> relationShipSubClasses = this.getAllSubClasses((Class)super.getUmlMetamodel().getMember("Relationship"));
        relationShipSubClasses.add((Class)super.getUmlMetamodel().getMember("Relationship"));
        List<Class> mataclassesSource = this.getAllExtendedMetaClasses((Class)stereotypeSource);
        List<Class> mataclassesTarget = this.getAllExtendedMetaClasses((Class)stereotypeTarget);
        for (Class relationShipSubClasse : relationShipSubClasses) {
            ArrayList<Property> properties = ProfileServices.INSTANCE.getRelationShipSourceTargetPeroperties(relationShipSubClasse);
            Type candidateTypeSource = properties.get(0).getType();
            Type candidateTypeTarget = properties.get(1).getType();
            if (!ProfileServices.INSTANCE.isIn((Class)candidateTypeSource, mataclassesSource) || !ProfileServices.INSTANCE.isIn((Class)candidateTypeTarget, mataclassesTarget)) continue;
            eligibleRelationShips.add((EObject)relationShipSubClasse);
        }
        return eligibleRelationShips;
    }

    protected List<Class> getAllSubClasses(Class superClass) {
        ArrayList<Class> subClasses = new ArrayList<Class>();
        for (Class metaClass : super.getUmlMetaclasses()) {
            if (!this.isSubClass(metaClass, superClass)) continue;
            subClasses.add(metaClass);
        }
        return subClasses;
    }

    public final String getAssociationName() {
        return this.associationName;
    }

    private boolean isSubClass(Class subClass, Class superClass) {
        for (Class superClassOfItem : subClass.getSuperClasses()) {
            if (!superClassOfItem.equals(superClass) && (superClassOfItem.getName().equalsIgnoreCase("Element") || !this.isSubClass(superClassOfItem, superClass))) continue;
            return true;
        }
        return false;
    }

    protected boolean testSuperClassAttributes(List<Class> relationShips, String propName) {
        for (Class relationShip : relationShips) {
            for (Property propertyToTest : relationShip.getAttributes()) {
                if (!ProfileServices.INSTANCE.isInSubSet(propertyToTest, propName)) continue;
                return true;
            }
        }
        return false;
    }
}

