/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMetaclassDialog
extends FilteredItemsSelectionDialog {
    private static String umlIconPath = "";
    private final Profile profile;
    private boolean concrete;
    private boolean subClass;
    private Button concreteButton;
    private Button subClassButton;
    private Combo combo;
    private String superClassName = "";
    private Composite compositeHeaderMessage;
    private String headerMessageText = "Message.";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private final Resource resource = this.resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
    private final Model umlMetamodel = (Model)this.resource.getContents().get(0);
    private final ArrayList<Class> umlMetaclasses = ImportMetaclassDialog.getUMLMetaClasses(this.umlMetamodel);
    private final String DIALOG_SETTINGS = "FilteredMetaclassesSelectionDialog";
    private final Action showOnlyConcreteMetaclassAction = new ShowOnlyConcreteMetaclassAction();
    private final ILabelProviderForMetaclass labelProviderForMetaclass = new ILabelProviderForMetaclass();

    static {
        try {
            umlIconPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.uml2.uml.edit").getResource("icons/full/obj16")).getPath();
        }
        catch (IOException e) {
            LogServices.INSTANCE.error("FileLocator.toFileURL in ImportMetaclassDialog() not handled", e);
        }
    }

    public static ArrayList<Class> getUMLMetaClasses(Model metaModel) {
        ArrayList<Class> metaClasses = new ArrayList<Class>();
        for (Element element : metaModel.getOwnedElements()) {
            if (!(element instanceof Class)) continue;
            metaClasses.add((Class)element);
        }
        return metaClasses;
    }

    public ImportMetaclassDialog(Shell shell, Profile profile) {
        this(shell, profile, false);
    }

    public ImportMetaclassDialog(Shell shell, Profile profile, boolean multi) {
        super(shell, multi);
        this.profile = profile;
        this.concrete = false;
        this.subClass = false;
        this.setTitle("Import UML Metaclasses");
        this.setInitialPattern("?");
        this.setListLabelProvider(this.labelProviderForMetaclass);
    }

    protected void applyFilter() {
        super.applyFilter();
        this.concreteButton.setSelection(this.concrete);
        this.showOnlyConcreteMetaclassAction.setChecked(this.concrete);
    }

    protected Control createDialogArea(Composite parent) {
        this.compositeHeaderMessage = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.compositeHeaderMessage.setLayout((Layout)layout);
        Label headerMessage = new Label(this.compositeHeaderMessage, 0);
        headerMessage.setText(this.headerMessageText);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        headerMessage.setLayoutData((Object)gridData);
        Control dialogArea1 = super.createDialogArea(parent);
        dialogArea1.setEnabled(true);
        parent.getParent().getShell().setMinimumSize(600, 700);
        this.applyFilter();
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text = new String();
                if (element instanceof Class) {
                    Class myClass = (Class)element;
                    for (Comment comment : myClass.getOwnedComments()) {
                        text = text.isEmpty() ? String.valueOf(text) + comment.getBody() : String.valueOf(text) + " " + comment.getBody();
                    }
                }
                return text;
            }
        });
        return dialogArea1;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite subClassButtonComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        subClassButtonComposite.setLayoutData((Object)gridData);
        subClassButtonComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.concreteButton = new Button(subClassButtonComposite, 32);
        this.concreteButton.setText("Only concrete Metaclass");
        this.concreteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImportMetaclassDialog.this.concrete != ((Button)e.widget).getSelection()) {
                    ImportMetaclassDialog.this.concrete = ((Button)e.widget).getSelection();
                    ImportMetaclassDialog.this.applyFilter();
                }
            }
        });
        this.concreteButton.setLayoutData((Object)gd);
        this.subClassButton = new Button(subClassButtonComposite, 32);
        this.subClassButton.setText("Only sub classes of:");
        this.subClassButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImportMetaclassDialog.this.subClass != ((Button)e.widget).getSelection()) {
                    ImportMetaclassDialog.this.subClass = ((Button)e.widget).getSelection();
                    ImportMetaclassDialog.this.combo.setEnabled(ImportMetaclassDialog.this.subClass);
                    ImportMetaclassDialog.this.applyFilter();
                }
            }
        });
        this.combo = new Combo(subClassButtonComposite, 4);
        this.combo.setEnabled(this.subClass);
        this.combo.setItems(this.getMetaclassesNames());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object src;
                if (e != null && (src = e.getSource()) instanceof Combo) {
                    Combo comboEvent = (Combo)src;
                    ImportMetaclassDialog.this.superClassName = comboEvent.getText();
                }
                ImportMetaclassDialog.this.applyFilter();
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e != null) {
                    Object src = e.getSource();
                    if (src instanceof Combo) {
                        Combo myCombo = (Combo)src;
                        String myText = myCombo.getText();
                        int i = 0;
                        while (i < myCombo.getItemCount()) {
                            String item = myCombo.getItem(i);
                            if (myText != null && !myText.isEmpty() && item.equalsIgnoreCase(myText)) {
                                ImportMetaclassDialog.this.superClassName = myText;
                                break;
                            }
                            if (myText == null || myText.isEmpty()) {
                                ImportMetaclassDialog.this.superClassName = "";
                            }
                            ++i;
                        }
                    } else {
                        ImportMetaclassDialog.this.superClassName = "";
                    }
                }
                ImportMetaclassDialog.this.applyFilter();
            }
        });
        new AutoCompleteField((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), this.combo.getItems());
        this.combo.setLayoutData((Object)gridData);
        return parent;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new MetaclassFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Searching", this.umlMetaclasses.size());
        Iterator<Class> iter = this.umlMetaclasses.iterator();
        while (iter.hasNext()) {
            contentProvider.add((Object)iter.next(), itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IAction)this.showOnlyConcreteMetaclassAction);
    }

    public Composite getCompositeHeaderMessage() {
        return this.compositeHeaderMessage;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = UMLDesignerPlugin.getDefault().getDialogSettings().getSection("FilteredMetaclassesSelectionDialog");
        if (settings == null) {
            settings = UMLDesignerPlugin.getDefault().getDialogSettings().addNewSection("FilteredMetaclassesSelectionDialog");
        }
        return settings;
    }

    public String getElementName(Object item) {
        return ((NamedElement)item).getName();
    }

    public String getHeaderMessageText() {
        return this.headerMessageText;
    }

    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                return ((NamedElement)arg0).getName().compareTo(((NamedElement)arg1).getName());
            }
        };
    }

    private String[] getMetaclassesNames() {
        ArrayList<String> metaclassesNames = new ArrayList<String>();
        for (Class metaclass : this.umlMetaclasses) {
            metaclassesNames.add(metaclass.getName());
        }
        String[] metaclassesNamesArray = new String[metaclassesNames.size()];
        metaclassesNames.toArray(metaclassesNamesArray);
        return metaclassesNamesArray;
    }

    public ArrayList<Class> getUmlMetaclasses() {
        return this.umlMetaclasses;
    }

    public Model getUmlMetamodel() {
        return this.umlMetamodel;
    }

    public boolean isMetaclass(String nameToTest) {
        return this.umlMetamodel.getMember(nameToTest, true, null) != null && this.umlMetamodel.getMember(nameToTest, true, null) instanceof Class;
    }

    protected boolean isSubClassOfSuperClassName(Class item) {
        if (item.getName().equalsIgnoreCase(this.superClassName)) {
            return true;
        }
        if (this.isMetaclass(this.superClassName)) {
            Class superClass = (Class)this.umlMetamodel.getMember(this.superClassName, true, null);
            for (Class superClassOfItem : item.getSuperClasses()) {
                if (superClassOfItem.equals(superClass)) {
                    return true;
                }
                if (superClassOfItem.getName().equalsIgnoreCase("Element") || !this.isSubClassOfSuperClassName(superClassOfItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void setHeaderMessageText(String headerMessage) {
        this.headerMessageText = headerMessage;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public class ILabelProviderForMetaclass
    implements ILabelProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            if (element != null) {
                if (element instanceof Classifier) {
                    Classifier classifier = (Classifier)element;
                    if (!classifier.isAbstract()) {
                        Image image = new Image((Device)Display.getCurrent(), String.valueOf(umlIconPath) + ((Classifier)element).getName() + ".gif");
                        return image;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof Class) {
                Class metaclass = (Class)element;
                if (metaclass.isAbstract()) {
                    styledString.append(metaclass.getName(), StyledString.DECORATIONS_STYLER);
                } else if (ImportMetaclassDialog.this.profile.getImportedMember(metaclass.getName()) != null) {
                    styledString.append(metaclass.getName(), StyledString.QUALIFIER_STYLER);
                } else {
                    styledString.append(metaclass.getName());
                }
            }
            return styledString;
        }

        public String getText(Object element) {
            if (element != null) {
                if (element instanceof NamedElement) {
                    NamedElement namedElement = (NamedElement)element;
                    if (ImportMetaclassDialog.this.profile.getImportedMember(namedElement.getName()) != null) {
                        return String.valueOf(namedElement.getName()) + ", already imported.";
                    }
                    return namedElement.getName();
                }
                return element.toString();
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class MetaclassFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private final boolean concreteMetaclassFilter;
        private final boolean subClassMetaclassFilter;
        private final String superClassTextMetaclassFilter;

        private MetaclassFilter() {
            super((FilteredItemsSelectionDialog)ImportMetaclassDialog.this);
            this.concreteMetaclassFilter = ImportMetaclassDialog.this.concrete;
            this.subClassMetaclassFilter = ImportMetaclassDialog.this.subClass;
            this.superClassTextMetaclassFilter = ImportMetaclassDialog.this.superClassName;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            MetaclassFilter resourceFilter = (MetaclassFilter)filter;
            if (this.concreteMetaclassFilter != resourceFilter.concreteMetaclassFilter || this.subClassMetaclassFilter != resourceFilter.subClassMetaclassFilter || !this.superClassTextMetaclassFilter.equals(resourceFilter.superClassTextMetaclassFilter)) {
                return false;
            }
            return super.equalsFilter(filter);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            MetaclassFilter resourceFilter = (MetaclassFilter)filter;
            if (this.concreteMetaclassFilter != resourceFilter.concreteMetaclassFilter || this.subClassMetaclassFilter != resourceFilter.subClassMetaclassFilter || !this.superClassTextMetaclassFilter.equals(resourceFilter.superClassTextMetaclassFilter)) {
                return false;
            }
            return super.isSubFilter(filter);
        }

        public boolean matchItem(Object item) {
            if (item instanceof Classifier) {
                Classifier namedItem = (Classifier)item;
                if (ImportMetaclassDialog.this.concrete && ImportMetaclassDialog.this.subClass) {
                    return !namedItem.isAbstract() && ImportMetaclassDialog.this.isSubClassOfSuperClassName((Class)item) && this.matches(namedItem.getName());
                }
                if (ImportMetaclassDialog.this.subClass) {
                    return ImportMetaclassDialog.this.isSubClassOfSuperClassName((Class)item) && this.matches(namedItem.getName());
                }
                if (ImportMetaclassDialog.this.concrete) {
                    return !namedItem.isAbstract() && this.matches(namedItem.getName());
                }
                return this.matches(namedItem.getName());
            }
            return this.matches(item.toString());
        }
    }

    private class ShowOnlyConcreteMetaclassAction
    extends Action {
        public ShowOnlyConcreteMetaclassAction() {
            super("Only concerete Metaclass", 2);
        }

        public void run() {
            if (ImportMetaclassDialog.this.concrete != this.isChecked()) {
                ImportMetaclassDialog.this.concrete = this.isChecked();
                ImportMetaclassDialog.this.applyFilter();
            }
        }
    }
}

