/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InitProfilePluginDialog
extends TitleAreaDialog {
    private final String PROFILE_EXPORT = "Profile Export";
    private Text profileNameField;
    private Text rootProfileURIField;
    private Text profilePluginNameField;
    private boolean profileNameFieldState;
    private boolean rootProfileURIFieldState;
    private boolean profilePluginNameFieldState;
    private String profileName;
    private String rootProfileURI;
    private String profilePluginName;

    public InitProfilePluginDialog(String profileName, String rootProfileURI, String profilePluginName) {
        super(Display.getCurrent().getActiveShell());
        this.profileName = profileName;
        this.rootProfileURI = rootProfileURI;
        this.profilePluginName = profilePluginName;
        this.profileNameFieldState = false;
        this.rootProfileURIFieldState = false;
        this.profilePluginNameFieldState = false;
        this.setTitle("Export a profile ...");
    }

    private void applyButtonFilter() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.profileNameFieldState && this.rootProfileURIFieldState && this.profilePluginNameFieldState);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText("Profile Export");
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.setTitle("Information about profile versioning");
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parentComposite.getFont());
        Composite commentArea = this.createExportArea(composite);
        GridData gd = new GridData(4, 0x1000000, true, true);
        commentArea.setLayoutData((Object)gd);
        InitProfilePluginDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private Composite createExportArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Export");
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        Label header1 = new Label((Composite)group, 0);
        header1.setText("Enter the data required to generate the plug-in.");
        Label header2 = new Label((Composite)group, 0);
        header2.setText("All text zones must be specified.");
        Label profileNameLabel = new Label((Composite)group, 128);
        profileNameLabel.setText("profile name, editable in the profile (model/diagrams):");
        this.profileNameField = new Text((Composite)group, 2052);
        this.profileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    InitProfilePluginDialog.this.profileName = ((Text)e.getSource()).getText();
                }
                InitProfilePluginDialog.this.profileNameFieldState = InitProfilePluginDialog.this.isEmpty(e);
                InitProfilePluginDialog.this.applyButtonFilter();
            }
        });
        GridData data = new GridData(768);
        this.profileNameField.setLayoutData((Object)data);
        this.profileNameField.setText(this.profileName);
        this.profileNameField.setEnabled(false);
        Label rootProfileURILabel = new Label((Composite)group, 128);
        rootProfileURILabel.setText("Root profile URI: ");
        this.rootProfileURIField = new Text((Composite)group, 2052);
        this.rootProfileURIField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    InitProfilePluginDialog.this.rootProfileURI = ((Text)e.getSource()).getText();
                }
                InitProfilePluginDialog.this.rootProfileURIFieldState = InitProfilePluginDialog.this.isEmpty(e);
                InitProfilePluginDialog.this.applyButtonFilter();
            }
        });
        data = new GridData(768);
        this.rootProfileURIField.setLayoutData((Object)data);
        this.rootProfileURIField.setText(this.rootProfileURI);
        Label profilePluginNameLabel = new Label((Composite)group, 131072);
        profilePluginNameLabel.setText("Profile plug-in name: ");
        this.profilePluginNameField = new Text((Composite)group, 2052);
        this.profilePluginNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    InitProfilePluginDialog.this.profilePluginName = ((Text)e.getSource()).getText();
                }
                InitProfilePluginDialog.this.profilePluginNameFieldState = InitProfilePluginDialog.this.isEmpty(e);
                InitProfilePluginDialog.this.applyButtonFilter();
            }
        });
        data = new GridData(768);
        this.profilePluginNameField.setText(this.profilePluginName);
        this.profilePluginNameField.setLayoutData((Object)data);
        return group;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProfilePluginName() {
        return this.profilePluginName;
    }

    public String getRootProfileURI() {
        return this.rootProfileURI;
    }

    private boolean isEmpty(ModifyEvent e) {
        Object src = e.getSource();
        if (src instanceof Text) {
            Text txt = (Text)src;
            return txt.getText().length() != 0 && txt.getText().length() != 0;
        }
        return true;
    }
}

