/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.obeonetwork.dsl.uml2.design.api.wizards.ModelElementsSelectionDialogPatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementSelectionDialog
extends SelectionDialog {
    public static final String REGEXP_TOOL_TIP = "Expression that will be used to filer elements by name (for example 'abc', 'a?c', '*c'...)";
    private static final String REGEXP_TITLE = "Filter elements by name";
    private static final String REGEXP_EXPLANATIONS = "? = any character, * = any String";
    private final SelectionDialogTreeLabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private TreeViewer treeViewer;
    private final int width = 60;
    private final int height = 18;
    private Predicate<Object> isSelectable;
    protected ModelElementsSelectionDialogPatternMatcher patternMatcher;

    private static AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    public ModelElementSelectionDialog() {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.initContentProvider();
        this.labelProvider = new SelectionDialogTreeLabelProvider();
        this.labelProvider.setSelectablePredicate(this.isSelectable);
        this.patternMatcher = new ModelElementsSelectionDialogPatternMatcher("");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.treeViewer = this.createTreeViewer(composite);
        this.treeViewer.expandAll();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        Tree treeWidget = this.treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        Label createMessageArea = super.createMessageArea(composite);
        this.createRegexpTypeZone(composite);
        return createMessageArea;
    }

    private void createRegexpTypeZone(Composite composite) {
        Group expregGroup = new Group(composite, 0);
        expregGroup.setText(REGEXP_TITLE);
        GridLayout expregLayout = new GridLayout();
        expregGroup.setLayout((Layout)expregLayout);
        expregGroup.setFont(composite.getFont());
        expregGroup.setLayoutData((Object)new GridData(768));
        Label explanationsLabel = new Label((Composite)expregGroup, 0);
        explanationsLabel.setText(REGEXP_EXPLANATIONS);
        Text regularExpressionText = new Text((Composite)expregGroup, 2048);
        regularExpressionText.setToolTipText(REGEXP_TOOL_TIP);
        regularExpressionText.setLayoutData((Object)new GridData(768));
        regularExpressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String typedRegex = ((Text)e.getSource()).getText();
                ModelElementSelectionDialog.this.setPatternMatcher(new ModelElementsSelectionDialogPatternMatcher(typedRegex));
                ModelElementSelectionDialog.this.refresh();
            }
        });
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            private void doSelectionChanged(Object[] array) {
                ModelElementSelectionDialog.this.setResult(Arrays.asList(array));
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        Collection<EObject> roots = this.getAllRootsInSessions();
        HashSet inputs = Sets.newHashSet();
        inputs.addAll(roots);
        this.treeViewer.setInput((Object)inputs);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Predicate<Object> isMatchinExpregPredicate = ModelElementSelectionDialog.this.getRegexpMatchPredicate();
                return ModelElementSelectionDialog.this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)ModelElementSelectionDialog.this.isSelectable, isMatchinExpregPredicate));
            }
        });
        return this.treeViewer;
    }

    private Collection<EObject> getAllRootsInSessions() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            for (Resource childRes : session.getSemanticResources()) {
                for (EObject eObject : childRes.getContents()) {
                    if (!(eObject instanceof Element)) continue;
                    roots.add(eObject);
                }
            }
        }
        return roots;
    }

    public Predicate<Object> getRegexpMatchPredicate() {
        return this.patternMatcher.getMatchPredicate();
    }

    protected void initContentProvider() {
        AdapterFactory adapterFactory = ModelElementSelectionDialog.getAdapterFactory();
        this.contentProvider = new SelectionDialogTreeContentProvider(adapterFactory);
    }

    private boolean isOrHasDescendant(Object element, final Predicate<Object> pred) {
        boolean matches = pred.apply(element);
        if (matches) {
            return true;
        }
        return Iterables.any(Arrays.asList(this.contentProvider.getChildren(element)), (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return ModelElementSelectionDialog.this.isOrHasDescendant(input, (Predicate<Object>)pred);
            }
        });
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void setPatternMatcher(ModelElementsSelectionDialogPatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public void setSelectablePredicate(Predicate isSelectablePredicate) {
        this.isSelectable = isSelectablePredicate;
    }

    private class SelectionDialogTreeContentProvider
    extends AdapterFactoryContentProvider {
        public SelectionDialogTreeContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object parentElement) {
            return super.getChildren(parentElement);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            return super.getElements(object);
        }

        public boolean hasChildren(Object element) {
            return super.hasChildren(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionDialogTreeLabelProvider
    extends SiriusCommonLabelProvider {
        private SelectionDialogTreeLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Color foreground = null;
            if (!ModelElementSelectionDialog.this.isSelectable.apply(element)) {
                foreground = VisualBindingManager.getDefault().getColorFromName("light_gray");
            }
            return foreground;
        }

        public Predicate<Object> setSelectablePredicate(Predicate<Object> isSelectablePredicate) {
            Predicate predicate = isSelectablePredicate != null ? isSelectablePredicate : Predicates.alwaysFalse();
            ModelElementSelectionDialog.this.isSelectable = predicate;
            return predicate;
        }
    }
}

