/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Profile;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UMLDesignerProfileVersion;
import org.obeonetwork.dsl.uml2.design.internal.services.Version;

public class ProfileVersionDialog
extends TitleAreaDialog {
    private final String PROFILE_VERSIONING = "Profile Versioning";
    private Button revisionVersionButton;
    private Button minorVersionButton;
    private Button majorVersionButton;
    private Button customVersionButton;
    private Text customVersionText;
    private final Profile targetProfile;
    private Version revisionVersionValue;
    private Version minorVersionValue;
    private Version majorVersionValue;
    private Version oldVersionValue;
    private Version customVersionValue;
    private Version newVersionValue;
    private UMLDesignerProfileVersion umlDesignerProfileVersion;
    private UMLDesignerProfileVersion oldUMLDesignerProfileVersion;
    private Text commentText;
    private Text copyrightText;
    private Text authorText;
    private Text dateText;

    public ProfileVersionDialog(Shell parentShell, Profile targetProfile) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.targetProfile = targetProfile;
    }

    private void computeVersionValues() {
        UMLDesignerProfileVersion profileVersion = new UMLDesignerProfileVersion();
        this.oldUMLDesignerProfileVersion = profileVersion.getProfileVersion(this.targetProfile);
        this.oldVersionValue = this.oldUMLDesignerProfileVersion.getVersion();
        this.revisionVersionValue = new Version(this.oldVersionValue.getMajor(), this.oldVersionValue.getMinor(), this.oldVersionValue.getMicro() + 1);
        this.minorVersionValue = new Version(this.oldVersionValue.getMajor(), this.oldVersionValue.getMinor() + 1, 0);
        this.majorVersionValue = new Version(this.oldVersionValue.getMajor() + 1, 0, 0);
        this.customVersionValue = this.revisionVersionValue;
        this.newVersionValue = this.revisionVersionValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText("Profile Versioning");
    }

    private Composite createCommentArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Comment");
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.commentText = new Text((Composite)group, 2626);
        this.commentText.setText(this.oldUMLDesignerProfileVersion.getComment());
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.heightHint = 60;
        this.commentText.setLayoutData((Object)gd);
        return group;
    }

    private Composite createCopyrightArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Copyright");
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.copyrightText = new Text((Composite)group, 2626);
        this.copyrightText.setText(this.oldUMLDesignerProfileVersion.getCopyright());
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.heightHint = 60;
        this.copyrightText.setLayoutData((Object)gd);
        return group;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.setTitle("Information about profile versioning");
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parentComposite.getFont());
        this.computeVersionValues();
        Composite versionArea = this.createVersionArea(composite);
        GridData gd = new GridData(4, 0x1000000, true, false);
        versionArea.setLayoutData((Object)gd);
        Composite infoArea = this.createInfoArea(composite);
        gd = new GridData(4, 4, true, true);
        infoArea.setLayoutData((Object)gd);
        Composite commentArea = this.createCommentArea(composite);
        gd = new GridData(4, 0x1000000, true, true, 2, 1);
        commentArea.setLayoutData((Object)gd);
        Composite copyrightArea = this.createCopyrightArea(composite);
        gd = new GridData(4, 0x1000000, true, true, 2, 1);
        copyrightArea.setLayoutData((Object)gd);
        ProfileVersionDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private Composite createInfoArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Info");
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        Label dateLabel = new Label((Composite)group, 16384);
        dateLabel.setText("Date");
        GridData gd = new GridData(4, 0x1000000, true, false);
        dateLabel.setLayoutData((Object)gd);
        this.dateText = new Text((Composite)group, 2052);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone local = TimeZone.getDefault();
        simpleDateFormat.setTimeZone(local);
        String dateString = simpleDateFormat.format(new Date());
        this.dateText.setText(dateString);
        gd = new GridData(4, 0x1000000, true, false);
        this.dateText.setLayoutData((Object)gd);
        Label authorLabel = new Label((Composite)group, 16384);
        authorLabel.setText("Author");
        gd = new GridData(4, 0x1000000, true, false);
        authorLabel.setLayoutData((Object)gd);
        this.authorText = new Text((Composite)group, 2052);
        this.authorText.setText(this.oldUMLDesignerProfileVersion.getAuthor());
        gd = new GridData(4, 0x1000000, true, false);
        this.authorText.setLayoutData((Object)gd);
        return group;
    }

    private Composite createVersionArea(Composite composite) {
        Group versionGroup = new Group(composite, 0x1000000);
        versionGroup.setText("Version");
        GridLayout layout = new GridLayout(2, false);
        versionGroup.setLayout((Layout)layout);
        Label oldVersionLabel = new Label((Composite)versionGroup, 16384);
        oldVersionLabel.setText("Previous Version");
        GridData gd = new GridData(4, 0x1000000, true, false);
        oldVersionLabel.setLayoutData((Object)gd);
        Text oldVersionText = new Text((Composite)versionGroup, 2060);
        oldVersionText.setText(this.oldVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        oldVersionText.setLayoutData((Object)gd);
        this.revisionVersionButton = new Button((Composite)versionGroup, 32);
        this.revisionVersionButton.setText("Revision Version");
        gd = new GridData(4, 0x1000000, true, false);
        this.revisionVersionButton.setLayoutData((Object)gd);
        this.revisionVersionButton.setSelection(true);
        this.revisionVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProfileVersionDialog.this.revisionVersionButtonPressed();
            }
        });
        Text devVersionText = new Text((Composite)versionGroup, 2060);
        devVersionText.setText(this.revisionVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        devVersionText.setLayoutData((Object)gd);
        this.minorVersionButton = new Button((Composite)versionGroup, 32);
        this.minorVersionButton.setText("Minor Version");
        gd = new GridData(4, 0x1000000, true, false);
        this.minorVersionButton.setLayoutData((Object)gd);
        this.minorVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProfileVersionDialog.this.minorVersionButtonPressed();
            }
        });
        Text releaseVersionText = new Text((Composite)versionGroup, 2060);
        releaseVersionText.setText(this.minorVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        releaseVersionText.setLayoutData((Object)gd);
        this.majorVersionButton = new Button((Composite)versionGroup, 32);
        this.majorVersionButton.setText("Major Version");
        gd = new GridData(4, 0x1000000, true, false);
        this.majorVersionButton.setLayoutData((Object)gd);
        this.majorVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProfileVersionDialog.this.majorVersionButtonPressed();
            }
        });
        Text majorReleaseVersionText = new Text((Composite)versionGroup, 2060);
        majorReleaseVersionText.setText(this.majorVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        majorReleaseVersionText.setLayoutData((Object)gd);
        this.customVersionButton = new Button((Composite)versionGroup, 32);
        this.customVersionButton.setText("Custom");
        gd = new GridData(4, 0x1000000, true, false);
        this.customVersionButton.setLayoutData((Object)gd);
        this.customVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProfileVersionDialog.this.customVersionButtonPressed();
            }
        });
        this.customVersionText = new Text((Composite)versionGroup, 2052);
        this.customVersionText.setEditable(false);
        this.customVersionText.setText(this.customVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        this.customVersionText.setLayoutData((Object)gd);
        this.customVersionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ProfileVersionDialog.this.customVersionText.setText(ProfileVersionDialog.this.customVersionValue.toString());
            }

            public void focusLost(FocusEvent e) {
                try {
                    ProfileVersionDialog.this.customVersionValue = Version.parseVersion(ProfileVersionDialog.this.customVersionText.getText());
                    ProfileVersionDialog.this.newVersionValue = ProfileVersionDialog.this.customVersionValue;
                    ProfileVersionDialog.this.setErrorMessage(null);
                }
                catch (IllegalArgumentException iae) {
                    LogServices.INSTANCE.warning("Custom version number format should be X.Y.Z, not " + ProfileVersionDialog.this.customVersionText.getText(), iae);
                    ProfileVersionDialog.this.customVersionValue = ProfileVersionDialog.this.revisionVersionValue;
                    ProfileVersionDialog.this.revisionVersionButtonPressed();
                }
            }
        });
        return versionGroup;
    }

    private void customVersionButtonPressed() {
        this.revisionVersionButton.setSelection(false);
        this.minorVersionButton.setSelection(false);
        this.majorVersionButton.setSelection(false);
        this.customVersionButton.setSelection(true);
        this.newVersionValue = this.customVersionValue;
        this.customVersionText.setEditable(true);
    }

    public UMLDesignerProfileVersion getUMLDesignerProfileVersion() {
        return this.umlDesignerProfileVersion;
    }

    private void majorVersionButtonPressed() {
        this.revisionVersionButton.setSelection(false);
        this.minorVersionButton.setSelection(false);
        this.majorVersionButton.setSelection(true);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.majorVersionValue;
        this.customVersionText.setEditable(false);
    }

    private void minorVersionButtonPressed() {
        this.revisionVersionButton.setSelection(false);
        this.minorVersionButton.setSelection(true);
        this.majorVersionButton.setSelection(false);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.minorVersionValue;
        this.customVersionText.setEditable(false);
    }

    protected void okPressed() {
        this.umlDesignerProfileVersion = new UMLDesignerProfileVersion(this.newVersionValue, this.dateText.getText(), this.authorText.getText(), this.copyrightText.getText(), this.commentText.getText());
        super.okPressed();
    }

    private void revisionVersionButtonPressed() {
        this.revisionVersionButton.setSelection(true);
        this.minorVersionButton.setSelection(false);
        this.majorVersionButton.setSelection(false);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.revisionVersionValue;
        this.customVersionText.setEditable(false);
    }
}

