/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.listeners;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.listeners.Messages;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;

public class CreateNewChildListener
implements CommandStackListener {
    public void commandStackChanged(EventObject event) {
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand != null && mostRecentCommand instanceof CreateChildCommand) {
            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
            for (Object object : affectedObjects) {
                String defaultName;
                if (!(object instanceof NamedElement) || !Strings.isNullOrEmpty((String)((NamedElement)object).getName()) || Strings.isNullOrEmpty((String)(defaultName = LabelServices.INSTANCE.computeDefaultName((EObject)((NamedElement)object))))) continue;
                this.setName((NamedElement)object, defaultName);
            }
            IViewPart modelExplorerView = null;
            try {
                modelExplorerView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.sirius.ui.tools.views.model.explorer");
                if (modelExplorerView instanceof CommonNavigator) {
                    CommonNavigator modelExplorer = (CommonNavigator)modelExplorerView;
                    Object affectedObject = affectedObjects.iterator().next();
                    modelExplorer.getCommonViewer().refresh((Object)((Element)affectedObject).getOwner());
                    modelExplorer.selectReveal((ISelection)new StructuredSelection(affectedObject));
                }
            }
            catch (PartInitException e) {
                UMLDesignerPlugin.log(4, NLS.bind((String)Messages.UmlModelExplorer_UI_ErrorMsg_NotFound, (Object)modelExplorerView), e);
            }
        }
    }

    private void setName(NamedElement element, String newName) {
        TransactionalEditingDomain editingDomain = SessionManager.INSTANCE.getSession((EObject)element).getTransactionalEditingDomain();
        EAttribute eAttribute = UMLPackage.Literals.NAMED_ELEMENT__NAME;
        Command setNameCmd = SetCommand.create((EditingDomain)editingDomain, (Object)element, (Object)eAttribute, (Object)newName);
        editingDomain.getCommandStack().execute(setNameCmd);
    }
}

