/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.listeners;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.ProfileApplication;
import org.obeonetwork.dsl.uml2.design.internal.listeners.CallActionPinListener;
import org.obeonetwork.dsl.uml2.design.internal.listeners.CreateNewChildListener;
import org.obeonetwork.dsl.uml2.design.internal.listeners.DescendantCacheListener;
import org.obeonetwork.dsl.uml2.design.internal.listeners.OpenHelpContextListener;
import org.obeonetwork.dsl.uml2.design.internal.listeners.UmlDesignerSessionListener;
import org.obeonetwork.dsl.uml2.design.internal.triggers.AutosizeTrigger;
import org.obeonetwork.dsl.uml2.design.internal.triggers.ConfirmDeletionTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmlDesignerSessionManagerListener
implements SessionManagerListener {
    private final IPartService partService = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPartService();
    private final Map<Session, UmlDesignerSessionListener> sessionListeners = Maps.newHashMap();
    private final OpenHelpContextListener openedEditorListener = new OpenHelpContextListener();
    private final CallActionPinListener callActionPinListener = new CallActionPinListener();
    private final CreateNewChildListener createNewChildListener = new CreateNewChildListener();
    private final DescendantCacheListener descendantCacheListener = new DescendantCacheListener();
    private static final Map<EObject, Boolean> descendantCache = Maps.newHashMap();

    public static Map<EObject, Boolean> getDescendantCache() {
        return descendantCache;
    }

    public void notify(Session updated, int notification) {
        if (notification == 7) {
            LinkedHashSet profileEPackages = Sets.newLinkedHashSet();
            for (Resource semResources : updated.getSemanticResources()) {
                UnmodifiableIterator it = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)semResources, (boolean)true), ProfileApplication.class);
                while (it.hasNext()) {
                    ProfileApplication cur = (ProfileApplication)it.next();
                    EPackage found = cur.getAppliedDefinition();
                    if (found == null) continue;
                    profileEPackages.add(found);
                }
            }
            LinkedHashSet descriptorsForInterpreter = Sets.newLinkedHashSet();
            for (EPackage pak : profileEPackages) {
                descriptorsForInterpreter.add(new EcoreMetamodelDescriptor(pak));
            }
            updated.getInterpreter().activateMetamodels((Collection)descriptorsForInterpreter);
        }
    }

    public void notifyAddSession(Session newSession) {
        newSession.getEventBroker().addLocalTrigger(AutosizeTrigger.IS_GMF_NODE_ATTACHMENT, (ModelChangeTrigger)new AutosizeTrigger(newSession.getTransactionalEditingDomain()));
        newSession.getEventBroker().addLocalTrigger(ConfirmDeletionTrigger.IS_IMPACTING, (ModelChangeTrigger)new ConfirmDeletionTrigger(newSession.getTransactionalEditingDomain(), newSession.getModelAccessor(), newSession.getSemanticCrossReferencer()));
        this.partService.addPartListener((IPartListener2)this.openedEditorListener);
        newSession.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.callActionPinListener);
        newSession.getTransactionalEditingDomain().getCommandStack().addCommandStackListener((CommandStackListener)this.createNewChildListener);
        newSession.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.descendantCacheListener);
        UmlDesignerSessionListener sessionListener = new UmlDesignerSessionListener(newSession);
        this.sessionListeners.put(newSession, sessionListener);
        newSession.addListener((SessionListener)sessionListener);
    }

    public void notifyRemoveSession(Session removedSession) {
        this.partService.removePartListener((IPartListener2)this.openedEditorListener);
        removedSession.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.callActionPinListener);
        removedSession.getTransactionalEditingDomain().getCommandStack().removeCommandStackListener((CommandStackListener)this.createNewChildListener);
        removedSession.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.descendantCacheListener);
        removedSession.removeListener((SessionListener)this.sessionListeners.get(removedSession));
        this.sessionListeners.remove(removedSession);
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }
}

