/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorServices {
    public static final ConnectorServices INSTANCE = new ConnectorServices();

    private ConnectorServices() {
    }

    private void addConnectorEndsAndClientDependencies(Connector connector, Set<DEdge> edges) {
        for (DEdge dEdge : edges) {
            ConnectorEnd connectorEnd;
            EObject model;
            AbstractDNode targetNode;
            EObject target = dEdge.getTarget();
            if (target instanceof Dependency) {
                ConnectorEnd connectorEnd2;
                Port publicPort;
                ConnectorEnd connectorEnd3;
                Dependency dependency = (Dependency)target;
                if (dependency instanceof Usage) {
                    targetNode = (AbstractDNode)dEdge.getTargetNode();
                    model = targetNode.getTarget();
                    if (model instanceof ConnectableElement) {
                        connectorEnd3 = connector.createEnd();
                        connectorEnd3.setRole((ConnectableElement)model);
                    } else {
                        if (!(model instanceof EncapsulatedClassifier)) continue;
                        publicPort = this.getStructuredClassifierPublicPort((EncapsulatedClassifier)model);
                        connectorEnd2 = connector.createEnd();
                        connectorEnd2.setRole((ConnectableElement)publicPort);
                    }
                    dependency.getClients().add((Object)connector);
                    continue;
                }
                if (!(dependency instanceof InterfaceRealization)) continue;
                AbstractDNode sourceNode = (AbstractDNode)dEdge.getSourceNode();
                model = sourceNode.getTarget();
                if (model instanceof ConnectableElement) {
                    connectorEnd3 = connector.createEnd();
                    connectorEnd3.setRole((ConnectableElement)model);
                } else {
                    if (!(model instanceof EncapsulatedClassifier)) continue;
                    publicPort = this.getStructuredClassifierPublicPort((EncapsulatedClassifier)model);
                    connectorEnd2 = connector.createEnd();
                    connectorEnd2.setRole((ConnectableElement)publicPort);
                }
                dependency.getClients().add((Object)connector);
                continue;
            }
            if (target instanceof Port) {
                connectorEnd = connector.createEnd();
                connectorEnd.setRole((ConnectableElement)target);
                continue;
            }
            if (!(target instanceof Interface)) continue;
            connectorEnd = connector.createEnd();
            targetNode = (AbstractDNode)dEdge.getTargetNode();
            model = targetNode.getTarget();
            connectorEnd.setRole((ConnectableElement)model);
        }
    }

    protected Connector connectInterface2Interface(DNode sourceView, Interface iSource, DNode targetView, Interface iTarget) {
        StructuredClassifier structuredClassifier = this.getStructuredClassifierRelated2InterfaceView(sourceView);
        Connector connector = this.createConnector(structuredClassifier, (NamedElement)iSource, (NamedElement)iTarget);
        HashSet<DEdge> edges = new HashSet<DEdge>();
        edges.addAll((Collection<DEdge>)sourceView.getIncomingEdges());
        edges.addAll((Collection<DEdge>)targetView.getOutgoingEdges());
        this.addConnectorEndsAndClientDependencies(connector, edges);
        return connector;
    }

    protected Connector connectInterface2Port(DNode sourceView, Interface iSource, DNode targetView, Port pTarget) {
        StructuredClassifier structuredClassifier = this.getStructuredClassifierRelated2InterfaceView(sourceView);
        Connector connector = this.createConnector(structuredClassifier, (NamedElement)iSource, (NamedElement)pTarget);
        HashSet<DEdge> edges = new HashSet<DEdge>();
        edges.addAll((Collection<DEdge>)sourceView.getIncomingEdges());
        this.addConnectorEndsAndClientDependencies(connector, edges);
        ConnectorEnd iTargetConnectorEnd = connector.createEnd();
        iTargetConnectorEnd.setRole((ConnectableElement)pTarget);
        return connector;
    }

    protected Connector connectPort2Interface(DNode sourceView, Port pSource, DNode targetView, Interface iTarget) {
        StructuredClassifier structuredClassifier = this.getStructuredClassifierRelated2SubInterfaceView(targetView);
        Connector connector = this.createConnector(structuredClassifier, (NamedElement)pSource, (NamedElement)iTarget);
        HashSet<DEdge> edges = new HashSet<DEdge>();
        edges.addAll((Collection<DEdge>)targetView.getOutgoingEdges());
        this.addConnectorEndsAndClientDependencies(connector, edges);
        ConnectorEnd iTargetConnectorEnd = connector.createEnd();
        iTargetConnectorEnd.setRole((ConnectableElement)pSource);
        return connector;
    }

    protected Connector connectPortInterface2PortInterface(DNode sourceView, Interface iSource, DNode targetView, Interface iTarget) {
        StructuredClassifier structuredClassifier = this.getStructuredClassifierRelated2InterfaceView(targetView);
        Connector connector = this.createConnector(structuredClassifier, (NamedElement)iTarget, (NamedElement)iSource);
        HashSet<DEdge> edges = new HashSet<DEdge>();
        edges.addAll((Collection<DEdge>)sourceView.getIncomingEdges());
        edges.addAll((Collection<DEdge>)targetView.getIncomingEdges());
        edges.addAll((Collection<DEdge>)targetView.getOutgoingEdges());
        edges.addAll((Collection<DEdge>)sourceView.getOutgoingEdges());
        this.addConnectorEndsAndClientDependencies(connector, edges);
        return connector;
    }

    public Connector connectProperty2Property(DDiagramElement sourceView, Property source, DDiagramElement targetView, Property target) {
        StructuredClassifier sourceContainer = (StructuredClassifier)source.eContainer();
        Connector connector = this.createConnector(sourceContainer, (NamedElement)source, (NamedElement)target);
        ConnectorEnd sourceConnectorEnd = connector.createEnd();
        ConnectorEnd targetConnectorEnd = connector.createEnd();
        sourceConnectorEnd.setRole((ConnectableElement)source);
        targetConnectorEnd.setRole((ConnectableElement)target);
        EObject sourcePart = ((DNodeContainer)sourceView.eContainer()).getTarget();
        if (source instanceof Port && sourcePart instanceof Property) {
            sourceConnectorEnd.setPartWithPort((Property)sourcePart);
        }
        EObject targetPart = ((DNodeContainer)targetView.eContainer()).getTarget();
        if (target instanceof Port && targetPart instanceof Property) {
            targetConnectorEnd.setPartWithPort((Property)targetPart);
        }
        return connector;
    }

    public void createConnector(AbstractDNode sourceView, AbstractDNode targetView) {
        EObject source = sourceView.getTarget();
        EObject target = targetView.getTarget();
        if (source instanceof Interface) {
            if (target instanceof Interface) {
                ArrayList dEdges = new ArrayList(((DNode)sourceView).getIncomingEdges());
                dEdges.addAll(((DNode)sourceView).getOutgoingEdges());
                for (DEdge dEdge : dEdges) {
                    EObject edgeTarget = dEdge.getTarget();
                    if (edgeTarget instanceof Usage) {
                        this.connectInterface2Interface((DNode)targetView, (Interface)target, (DNode)sourceView, (Interface)source);
                    } else {
                        if (!(edgeTarget instanceof InterfaceRealization)) continue;
                        this.connectInterface2Interface((DNode)sourceView, (Interface)source, (DNode)targetView, (Interface)target);
                    }
                    break;
                }
            } else if (target instanceof Port) {
                ArrayList dEdges = new ArrayList(((DNode)sourceView).getIncomingEdges());
                dEdges.addAll(((DNode)sourceView).getOutgoingEdges());
                for (DEdge dEdge : dEdges) {
                    EObject edgeTarget = dEdge.getTarget();
                    if (edgeTarget instanceof Usage) {
                        this.connectPort2Interface((DNode)targetView, (Port)target, (DNode)sourceView, (Interface)source);
                    } else {
                        if (!(edgeTarget instanceof InterfaceRealization)) continue;
                        this.connectInterface2Port((DNode)sourceView, (Interface)source, (DNode)targetView, (Port)target);
                    }
                    break;
                }
            }
        } else if (source instanceof Port && target instanceof Interface) {
            ArrayList dEdges = new ArrayList(((DNode)targetView).getIncomingEdges());
            dEdges.addAll(((DNode)targetView).getOutgoingEdges());
            for (DEdge dEdge : dEdges) {
                EObject edgeTarget = dEdge.getTarget();
                if (edgeTarget instanceof Usage) {
                    this.connectPort2Interface((DNode)sourceView, (Port)source, (DNode)targetView, (Interface)target);
                } else {
                    if (!(edgeTarget instanceof InterfaceRealization)) continue;
                    this.connectInterface2Port((DNode)targetView, (Interface)target, (DNode)targetView, (Port)source);
                }
                break;
            }
        } else if (source instanceof Property && target instanceof Property) {
            new ConnectorServices().connectProperty2Property((DDiagramElement)sourceView, (Property)source, (DDiagramElement)targetView, (Property)target);
        } else {
            LogServices.INSTANCE.error("ConnectorServices.createConnector(" + source.getClass() + ", " + target.getClass() + ") not handled", null);
        }
    }

    public Connector createConnector(StructuredClassifier structuredClassifier, NamedElement elem1, NamedElement elem2) {
        Connector connector = structuredClassifier.createOwnedConnector(String.valueOf(elem1.getName()) + "_" + elem2.getName() + "_connector");
        return connector;
    }

    private Port getStructuredClassifierPublicPort(EncapsulatedClassifier encapsulatedClassifier) {
        EList ownedPorts = encapsulatedClassifier.getOwnedPorts();
        for (Port port : ownedPorts) {
            if (!encapsulatedClassifier.equals(port.getType())) continue;
            return port;
        }
        Port newPort = encapsulatedClassifier.createOwnedPort(String.valueOf(encapsulatedClassifier.getName()) + "Port", (Type)encapsulatedClassifier);
        return newPort;
    }

    protected StructuredClassifier getStructuredClassifierRelated2InterfaceView(DNode interfaceView) {
        StructuredClassifier res = null;
        ArrayList dEdges = new ArrayList(interfaceView.getIncomingEdges());
        dEdges.addAll(interfaceView.getOutgoingEdges());
        for (DEdge dEdge : dEdges) {
            EdgeTarget sourceNode = dEdge.getSourceNode();
            if (!(sourceNode instanceof AbstractDNode)) continue;
            EObject source = ((AbstractDNode)sourceNode).getTarget();
            if (source instanceof Property && source.eContainer() instanceof StructuredClassifier) {
                res = (StructuredClassifier)source.eContainer();
                continue;
            }
            if (!(source instanceof StructuredClassifier)) continue;
            res = (StructuredClassifier)source;
        }
        if (res == null) {
            LogServices.INSTANCE.error("ConnectorServices.getStructuredClassifierRelated2InterfaceView(" + interfaceView.getName() + ") not handled", null);
        }
        return res;
    }

    protected StructuredClassifier getStructuredClassifierRelated2SubInterfaceView(DNode interfaceView) {
        EList dEdges = interfaceView.getOutgoingEdges();
        StructuredClassifier result = null;
        for (DEdge dEdge : dEdges) {
            EdgeTarget targetNode = dEdge.getTargetNode();
            if (!(targetNode instanceof AbstractDNode)) continue;
            AbstractDNode dNode = (AbstractDNode)targetNode;
            EObject target = dNode.getTarget();
            if (target instanceof Property) {
                result = (StructuredClassifier)target.eContainer();
                break;
            }
            if (!(target instanceof StructuredClassifier)) continue;
            result = (StructuredClassifier)target;
            break;
        }
        return result;
    }

    protected Element getViewContainerTarget(DNode view) {
        if (view != null && view.eContainer() instanceof DSemanticDecorator) {
            return (Element)((DSemanticDecorator)view.eContainer()).getTarget();
        }
        return null;
    }

    public boolean isConnectable(Element source, DSemanticDecorator sourceView, Element target, DSemanticDecorator targetView) {
        boolean result;
        block4: {
            block6: {
                block5: {
                    result = false;
                    if (!(source instanceof Interface) || !(target instanceof Interface)) break block5;
                    result = this.isConnectable(source, target);
                    break block4;
                }
                if (!(source instanceof Interface) || !(sourceView instanceof DNode)) break block6;
                ArrayList dEdges = new ArrayList(((DNode)sourceView).getIncomingEdges());
                dEdges.addAll(((DNode)sourceView).getOutgoingEdges());
                for (DEdge dEdge : dEdges) {
                    EObject edgeTarget = dEdge.getTarget();
                    if (!(!(edgeTarget instanceof Usage) ? edgeTarget instanceof InterfaceRealization && (result = this.isConnectable(source, target)) : (result = this.isConnectable(target, source)))) {
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (!(target instanceof Interface) || !(targetView instanceof DNode)) break block4;
            ArrayList dEdges = new ArrayList(((DNode)sourceView).getIncomingEdges());
            dEdges.addAll(((DNode)sourceView).getOutgoingEdges());
            for (DEdge dEdge : dEdges) {
                EObject edgeTarget = dEdge.getTarget();
                if (!(!(edgeTarget instanceof Usage) ? edgeTarget instanceof InterfaceRealization && (result = this.isConnectable(target, source)) : (result = this.isConnectable(source, target)))) {
                    continue;
                }
                break;
            }
        }
        return result;
    }

    public boolean isConnectable(Element source, Element target) {
        boolean result = false;
        if (source instanceof Interface) {
            if (target instanceof Interface) {
                result = this.isConnectable((Interface)source, (Interface)target);
            } else if (target instanceof Port) {
                result = this.isConnectable((Interface)source, (Port)target);
            } else if (target instanceof Property) {
                result = this.isConnectable((Interface)source, (Property)target);
            }
        } else if (source instanceof Port) {
            if (target instanceof Interface) {
                result = this.isConnectable((Port)source, (Interface)target);
            } else if (target instanceof Port) {
                result = this.isConnectable((Port)source, (Port)target);
            } else if (target instanceof Property) {
                result = this.isConnectable((Port)source, (Property)target);
            }
        } else if (source instanceof Property) {
            if (target instanceof Interface) {
                result = this.isConnectable((Property)source, (Interface)target);
            } else if (target instanceof Port) {
                result = this.isConnectable((Property)source, (Port)target);
            } else if (target instanceof Property) {
                result = this.isConnectable((Property)source, (Property)target);
            }
        }
        return result;
    }

    protected boolean isConnectable(Interface source, Interface target) {
        boolean res = source.conformsTo((Type)target);
        if (!res) {
            EList generalizations = source.getGeneralizations();
            for (Generalization generalization : generalizations) {
                if (generalization.getGeneral() instanceof Interface && (res = this.isConnectable((Interface)generalization.getGeneral(), target))) break;
            }
        }
        return res;
    }

    protected boolean isConnectable(Interface source, Port target) {
        boolean res = false;
        ArrayList clientDependencies = Lists.newArrayList((Iterable)target.getClientDependencies());
        if (target.getType() instanceof EncapsulatedClassifier) {
            clientDependencies.addAll(target.getType().getClientDependencies());
        }
        for (Dependency dependency : clientDependencies) {
            if (!(dependency instanceof InterfaceRealization)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement interfaceSupplier : suppliers) {
                if (interfaceSupplier instanceof Interface && (res = this.isConnectable(source, (Interface)interfaceSupplier))) break;
            }
            if (res) break;
        }
        return res;
    }

    protected boolean isConnectable(Interface source, Property target) {
        return false;
    }

    protected boolean isConnectable(Port source, Interface target) {
        boolean res = false;
        ArrayList clientDependencies = Lists.newArrayList((Iterable)source.getClientDependencies());
        if (source.getType() instanceof EncapsulatedClassifier) {
            clientDependencies.addAll(source.getType().getClientDependencies());
        }
        for (Dependency dependency : clientDependencies) {
            if (!(dependency instanceof Usage)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement interfaceSupplier : suppliers) {
                if (interfaceSupplier instanceof Interface && (res = this.isConnectable((Interface)interfaceSupplier, target))) break;
            }
            if (res) break;
        }
        return res;
    }

    protected boolean isConnectable(Port source, Port target) {
        boolean res = true;
        if (source.getType() != null && target.getType() != null) {
            res = source.getType().isCompatibleWith((ParameterableElement)target.getType());
        }
        return res;
    }

    protected boolean isConnectable(Port source, Property target) {
        return false;
    }

    protected boolean isConnectable(Property source, Interface target) {
        return false;
    }

    protected boolean isConnectable(Property source, Port target) {
        return false;
    }

    protected boolean isConnectable(Property source, Property target) {
        boolean res = true;
        if (source.getType() != null && target.getType() != null) {
            res = source.getType() instanceof Interface && target.getType() instanceof Interface ? this.isConnectable((Interface)source.getType(), (Interface)target.getType()) : source.isCompatibleWith((ParameterableElement)target);
        }
        return res;
    }

    public boolean isValidConnector(Connector connector, DNodeContainer sourceView, DNodeContainer targetView) {
        return sourceView.getTarget() instanceof Property && targetView.getTarget() instanceof Property;
    }

    protected boolean isValidPart(ConnectorEnd end, Element viewSemanticTarget) {
        return end == null || end.getPartWithPort() == null || EcoreUtil.equals((EObject)viewSemanticTarget, (EObject)end.getPartWithPort());
    }
}

