/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardServices {
    public static final DashboardServices INSTANCE = new DashboardServices();

    private DashboardServices() {
    }

    public List<EObject> getUmlModelsWithDashboard() {
        ArrayList results = Lists.newArrayList();
        Collection sessions = SessionManager.INSTANCE.getSessions();
        for (Session session : sessions) {
            Collection selectedViewpoints = session.getSelectedViewpoints(false);
            boolean isDashboardViewpointActive = false;
            for (Viewpoint viewpoint : selectedViewpoints) {
                if (!"Dashboard".equals(viewpoint.getName())) continue;
                isDashboardViewpointActive = true;
            }
            if (!isDashboardViewpointActive) continue;
            Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
            Iterator iterator = representations.iterator();
            boolean findDashboard = false;
            while (iterator.hasNext() && !findDashboard) {
                DSemanticDiagram diagram;
                DRepresentation representation = (DRepresentation)iterator.next();
                if (!(representation instanceof DSemanticDiagram) || !"Dashboard".equals((diagram = (DSemanticDiagram)representation).getDescription().getName())) continue;
                EObject target = ((DSemanticDiagram)representation).getTarget();
                results.add(target);
                findDashboard = true;
            }
        }
        return results;
    }
}

