/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.services.ILabelConstants;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayLabelSwitch
extends UMLSwitch<String>
implements ILabelConstants {
    private static final String SPACED_COLUMN = " : ";
    private static final String SPACED_COMMA = ", ";
    private static final String CLOSING_BRACE = "]";
    private static final String OPENING_BRACE = "[";
    ICommonLabelProvider labelProvider = UMLDesignerPlugin.getDefault().getLabelProvider();

    public static String computeStereotypes(Element element) {
        Iterator it = element.getAppliedStereotypes().iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer stereotypeLabel = new StringBuffer();
        stereotypeLabel.append("\u00ab");
        while (true) {
            Stereotype appliedStereotype = (Stereotype)it.next();
            stereotypeLabel.append(appliedStereotype.getName());
            if (!it.hasNext()) break;
            stereotypeLabel.append(SPACED_COMMA);
        }
        stereotypeLabel.append("\u00bb");
        if (element instanceof Feature) {
            stereotypeLabel.append(" ");
        } else {
            stereotypeLabel.append(NL);
        }
        return stereotypeLabel.toString();
    }

    public String caseActivity(Activity object) {
        return object.getName();
    }

    public String caseActivityEdge(ActivityEdge object) {
        String expr;
        ValueSpecification value = object.getGuard();
        if (value instanceof OpaqueExpression && (expr = (String)((OpaqueExpression)value).getBodies().get(0)) != null && !"".equalsIgnoreCase(expr) && !"true".equalsIgnoreCase(expr) && !"1".equalsIgnoreCase(expr)) {
            return OPENING_BRACE + expr + CLOSING_BRACE;
        }
        return "";
    }

    public String caseActivityPartition(ActivityPartition object) {
        if (object.getRepresents() instanceof NamedElement) {
            return String.valueOf(this.caseNamedElement((NamedElement)object)) + SPACED_COLUMN + ((NamedElement)object.getRepresents()).getName();
        }
        return null;
    }

    public String caseAssociation(Association object) {
        String labelToDisplay = this.labelProvider.getText((Object)object);
        labelToDisplay = labelToDisplay.replace("<Association> ", "");
        return labelToDisplay;
    }

    public String caseBehavior(Behavior object) {
        return object.getName();
    }

    public String caseCallBehaviorAction(CallBehaviorAction object) {
        String actionName = object.getName();
        if (object.getBehavior() != null) {
            String behaviorName = object.getBehavior().getName();
            if (actionName != null && actionName.length() > 0 && !actionName.equals(behaviorName)) {
                return actionName;
            }
            return behaviorName;
        }
        return null;
    }

    public String caseCallOperationAction(CallOperationAction object) {
        if (object.getOperation() != null) {
            String callOperationName = this.caseNamedElement((NamedElement)object);
            String operationName = object.getOperation().getName();
            if (callOperationName != null && callOperationName.equals(operationName)) {
                return callOperationName;
            }
            return String.valueOf(this.caseNamedElement((NamedElement)object)) + SPACED_COLUMN + object.getOperation().getName();
        }
        return null;
    }

    public String caseClass(Class object) {
        String templateParameters = LabelServices.INSTANCE.getTemplatedParameters(object);
        if (templateParameters != null) {
            return String.valueOf(DisplayLabelSwitch.computeStereotypes((Element)object)) + object.getName() + templateParameters;
        }
        return String.valueOf(DisplayLabelSwitch.computeStereotypes((Element)object)) + object.getName();
    }

    public String caseComponentRealization(ComponentRealization object) {
        return "";
    }

    public String caseControlFlow(ControlFlow object) {
        String labelToDisplay = this.labelProvider.getText((Object)object);
        labelToDisplay = labelToDisplay.replace("<Control Flow>", "");
        return labelToDisplay;
    }

    public String caseDataStoreNode(DataStoreNode object) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u00ab");
        buffer.append("Datastore");
        buffer.append("\u00bb");
        buffer.append(NL);
        buffer.append(this.caseNamedElement((NamedElement)object));
        return buffer.toString();
    }

    public String caseDependency(Dependency object) {
        return "";
    }

    public String caseDeployment(Deployment object) {
        return "<<deploy>>";
    }

    public String caseDuration(Duration object) {
        return object.getName();
    }

    public String caseElementImport(ElementImport object) {
        return object.getName();
    }

    public String caseEnumerationLiteral(EnumerationLiteral object) {
        return object.getLabel();
    }

    public String caseExecutionSpecification(ExecutionSpecification execution) {
        if (execution instanceof BehaviorExecutionSpecification && ((BehaviorExecutionSpecification)execution).getBehavior() != null && ((BehaviorExecutionSpecification)execution).getBehavior().getSpecification() != null) {
            return this.caseOperation((Operation)((BehaviorExecutionSpecification)execution).getBehavior().getSpecification());
        }
        return execution.getLabel();
    }

    public String caseExpression(Expression object) {
        return object.getName();
    }

    public String caseExtend(Extend object) {
        String labelToDisplay = this.labelProvider.getText((Object)object);
        labelToDisplay = labelToDisplay.replace("<Extend> ", "");
        return labelToDisplay;
    }

    public String caseFunctionBehavior(FunctionBehavior object) {
        return object.getName();
    }

    public String caseInclude(Include object) {
        String labelToDisplay = this.labelProvider.getText((Object)object);
        labelToDisplay = labelToDisplay.replace("<Include> ", "");
        return labelToDisplay;
    }

    public String caseInstanceSpecification(InstanceSpecification object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        if (object.getClassifiers() != null && object.getClassifiers().size() > 0) {
            label.append(SPACED_COLUMN);
            Iterator it = object.getClassifiers().iterator();
            while (it.hasNext()) {
                Classifier classifier = (Classifier)it.next();
                label.append(((String)this.doSwitch((EObject)classifier)).replace("\n", " "));
                if (!it.hasNext()) continue;
                label.append(SPACED_COMMA);
            }
        }
        return label.toString();
    }

    public String caseInstanceValue(InstanceValue object) {
        return LabelServices.INSTANCE.computeUmlLabel((Element)object.getInstance());
    }

    public String caseInteraction(Interaction object) {
        return object.getName();
    }

    public String caseInterfaceRealization(InterfaceRealization object) {
        return "";
    }

    public String caseInterval(Interval object) {
        String minLabel = LabelServices.INSTANCE.computeUmlLabel((Element)object.getMin());
        String maxLabel = LabelServices.INSTANCE.computeUmlLabel((Element)object.getMax());
        if (minLabel != null && minLabel.length() > 0 && maxLabel != null && maxLabel.length() > 0) {
            return OPENING_BRACE + minLabel + " " + maxLabel + CLOSING_BRACE;
        }
        return "";
    }

    public String caseLifeline(Lifeline lifeline) {
        StringBuilder label = new StringBuilder();
        if (lifeline.getRepresents() != null && this.isDependencyDescribed(lifeline)) {
            for (NamedElement context : ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers()) {
                label.append(context.getLabel());
                label.append(SPACED_COLUMN.trim());
                label.append(SPACED_COLUMN.trim());
            }
            label.append((String)this.doSwitch((EObject)lifeline.getRepresents()));
        } else if (lifeline.getRepresents() == null && this.isDependencyDescribed(lifeline)) {
            for (NamedElement context : ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers()) {
                label.append((String)this.doSwitch((EObject)context));
            }
        } else if (lifeline.getRepresents() instanceof Property) {
            label.append(this.caseProperty((Property)lifeline.getRepresents()));
        } else {
            label.append(this.caseNamedElement((NamedElement)lifeline));
        }
        return label.toString();
    }

    public String caseLiteralBoolean(LiteralBoolean object) {
        return object.stringValue();
    }

    public String caseLiteralInteger(LiteralInteger object) {
        return object.stringValue();
    }

    public String caseLiteralNull(LiteralNull object) {
        return "null";
    }

    public String caseLiteralReal(LiteralReal object) {
        return object.stringValue();
    }

    public String caseLiteralString(LiteralString object) {
        return object.stringValue();
    }

    public String caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
        return object.stringValue();
    }

    public String caseManifestation(Manifestation object) {
        return "<<manifest>>";
    }

    public String caseMessage(Message message) {
        return message.getName();
    }

    public String caseMultiplicityElement(MultiplicityElement object) {
        return this.getMultiplicity(object.getLower(), object.getUpper());
    }

    public String caseNamedElement(NamedElement object) {
        return String.valueOf(DisplayLabelSwitch.computeStereotypes((Element)object)) + object.getName();
    }

    public String caseObjectFlow(ObjectFlow object) {
        String labelToDisplay = this.labelProvider.getText((Object)object);
        labelToDisplay = labelToDisplay.replace("<Object Flow>", "");
        return labelToDisplay;
    }

    public String caseOpaqueAction(OpaqueAction object) {
        Iterator it = object.getBodies().iterator();
        if (it.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.caseNamedElement((NamedElement)object));
            buffer.append(NL);
            while (it.hasNext()) {
                buffer.append(NL);
                buffer.append((String)it.next());
            }
            return buffer.toString();
        }
        return null;
    }

    public String caseOpaqueBehavior(OpaqueBehavior object) {
        return object.getName();
    }

    public String caseOpaqueExpression(OpaqueExpression object) {
        String expr = (String)object.getBodies().get(0);
        if (!(expr == null || "".equalsIgnoreCase(expr) || "true".equalsIgnoreCase(expr) || "1".equalsIgnoreCase(expr))) {
            return expr;
        }
        return "";
    }

    public String caseOperation(Operation object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        label.append("(");
        boolean first = true;
        for (Parameter parameter : object.getOwnedParameters()) {
            if (ParameterDirectionKind.RETURN_LITERAL.equals((Object)parameter.getDirection())) continue;
            if (!first) {
                label.append(SPACED_COMMA);
            } else {
                first = false;
            }
            label.append(this.caseTypedElement((TypedElement)parameter));
        }
        label.append(")");
        if (object.getType() != null) {
            label.append(SPACED_COLUMN + object.getType().getName());
            label.append(this.getMultiplicity(object.getLower(), object.getUpper()));
        }
        StringBuilder operProperties = new StringBuilder();
        if (object.getRedefinedElements() != null && object.getRedefinedElements().size() > 0 && object.getRedefinedElements().get(0) != null) {
            operProperties.append("redefines " + ((RedefinableElement)object.getRedefinedElements().get(0)).getName());
        }
        if (object.isQuery()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("query");
        }
        if (object.isOrdered()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("ordered");
        }
        if (!object.isUnique()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("nonunique");
        }
        if (operProperties.length() > 0) {
            label.append("{" + operProperties + "}");
        }
        return label.toString();
    }

    public String caseParameter(Parameter object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        return label.toString();
    }

    public String casePin(Pin object) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.caseTypedElement((TypedElement)object));
        buffer.append(this.caseMultiplicityElement((MultiplicityElement)object));
        return buffer.toString();
    }

    public String caseProperty(Property object) {
        StringBuilder label = new StringBuilder();
        if (object.isDerived()) {
            label.append("/");
        }
        label.append(this.caseStructuralFeature((StructuralFeature)object));
        if (object.getDefault() != null && !"".equals(object.getDefault().trim())) {
            if (object.getDefault().contains(NL)) {
                label.append(" = ...");
            } else {
                label.append(" = " + object.getDefault());
            }
        } else if (object.getDefaultValue() instanceof InstanceValue) {
            label.append(" = " + ((InstanceValue)object.getDefaultValue()).getName());
        }
        StringBuilder propertyModifier = new StringBuilder();
        if (object.getRedefinedElements() != null && object.getRedefinedElements().size() > 0 && object.getRedefinedElements().get(0) != null) {
            propertyModifier.append("redefines " + ((RedefinableElement)object.getRedefinedElements().get(0)).getName());
        }
        if (object.getRedefinedElements() != null && object.getSubsettedProperties().size() > 0 && object.getRedefinedElements().get(0) != null) {
            propertyModifier.append("subsets " + ((Property)object.getSubsettedProperties().get(0)).getName());
        }
        if (object.isID()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("id");
        }
        if (object.isReadOnly()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("readOnly");
        }
        if (object.getUpper() != 1 && object.isOrdered()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("ordered");
        }
        if (object.getUpper() != 1 && object.isUnique()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("unique");
        }
        if (!object.isUnique() && !object.isOrdered()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("seq");
        }
        if (propertyModifier.length() > 0) {
            label.append("{" + propertyModifier + "}");
        }
        return label.toString();
    }

    public String caseProtocolStateMachine(ProtocolStateMachine object) {
        return object.getName();
    }

    public String caseSlot(Slot object) {
        StringBuilder label = new StringBuilder(object.getDefiningFeature().getName());
        label.append(" = ");
        EList values = object.getValues();
        boolean first = true;
        for (ValueSpecification valueSpecification : values) {
            if (first) {
                first = false;
            } else {
                label.append(SPACED_COMMA);
            }
            if (valueSpecification instanceof InstanceValue) {
                InstanceValue anInstanceValue = (InstanceValue)valueSpecification;
                label.append(anInstanceValue.getInstance().getName());
                continue;
            }
            if (valueSpecification instanceof LiteralString) {
                LiteralString aLiteralString = (LiteralString)valueSpecification;
                label.append(aLiteralString.getValue());
                continue;
            }
            if (valueSpecification instanceof LiteralInteger) {
                LiteralInteger aLiteralInteger = (LiteralInteger)valueSpecification;
                label.append(aLiteralInteger.getValue());
                continue;
            }
            if (valueSpecification instanceof LiteralBoolean) {
                LiteralBoolean aLiteralBoolean = (LiteralBoolean)valueSpecification;
                label.append(aLiteralBoolean.booleanValue());
                continue;
            }
            label.append(valueSpecification.getName());
        }
        return label.toString();
    }

    public String caseStateMachine(StateMachine object) {
        return object.getName();
    }

    public String caseStructuralFeature(StructuralFeature object) {
        return String.valueOf(this.caseTypedElement((TypedElement)object)) + " " + this.caseMultiplicityElement((MultiplicityElement)object);
    }

    public String caseTemplateBinding(TemplateBinding object) {
        EList parameterSubstitutions = object.getParameterSubstitutions();
        StringBuffer binding = new StringBuffer();
        boolean first = true;
        for (TemplateParameterSubstitution parameterSubstitution : parameterSubstitutions) {
            if (first) {
                first = false;
            } else {
                binding.append(SPACED_COMMA);
            }
            ParameterableElement formal = parameterSubstitution.getFormal().getDefault();
            if (!(formal instanceof NamedElement)) continue;
            binding.append(String.valueOf(((NamedElement)formal).getName()) + "->");
            ParameterableElement actual = parameterSubstitution.getActual();
            if (actual != null && actual instanceof NamedElement) {
                binding.append(((NamedElement)actual).getName());
                continue;
            }
            binding.append("?");
        }
        return binding.toString();
    }

    public String caseTimeExpression(TimeExpression object) {
        return object.stringValue();
    }

    public String caseTransition(Transition object) {
        String behaviorLabel;
        String specificationLabel;
        ValueSpecification specification;
        String triggersLabel = null;
        if (object.getTriggers() != null && object.getTriggers().size() > 0) {
            for (Trigger trigger : object.getTriggers()) {
                if (triggersLabel != null) {
                    triggersLabel = String.valueOf(triggersLabel) + ",";
                }
                triggersLabel = LabelServices.INSTANCE.computeUmlLabel((Element)trigger);
            }
        }
        String guardLabel = null;
        Constraint constraint = object.getGuard();
        if (constraint != null && (specification = constraint.getSpecification()) != null && (specificationLabel = LabelServices.INSTANCE.computeUmlLabel((Element)specification)) != null && specificationLabel.length() > 0) {
            guardLabel = OPENING_BRACE + specificationLabel + CLOSING_BRACE;
        }
        String effectLabel = null;
        Behavior effect = object.getEffect();
        if (effect != null && (behaviorLabel = LabelServices.INSTANCE.computeUmlLabel((Element)effect)) != null) {
            effectLabel = "/" + behaviorLabel;
        }
        StringBuffer transitionLabel = new StringBuffer();
        if (triggersLabel != null && triggersLabel.length() > 0) {
            transitionLabel.append(triggersLabel);
        }
        if (guardLabel != null && guardLabel.length() > 0) {
            transitionLabel.append(guardLabel);
        }
        if (effectLabel != null && effectLabel.length() > 0) {
            transitionLabel.append(effectLabel);
        }
        return transitionLabel.toString();
    }

    public String caseTypedElement(TypedElement object) {
        if (object.getType() != null) {
            return String.valueOf(this.caseNamedElement((NamedElement)object)) + SPACED_COLUMN + object.getType().getName();
        }
        return String.valueOf(this.caseNamedElement((NamedElement)object)) + SPACED_COLUMN;
    }

    public String caseUsage(Usage object) {
        return "<<use>>";
    }

    public String getAssociationEndLabel(Property p) {
        StringBuilder sb = new StringBuilder("");
        if (p.isDerived()) {
            sb.append("/");
        }
        sb.append(p.getName());
        sb.append(this.caseMultiplicityElement((MultiplicityElement)p));
        return sb.toString();
    }

    private String getMultiplicity(int lower, int upper) {
        StringBuffer label = new StringBuffer();
        if (lower == upper) {
            label.append(OPENING_BRACE + lower + CLOSING_BRACE);
        } else if (lower == 0 && upper == -1) {
            label.append("[*]");
        } else {
            label.append(OPENING_BRACE + lower + "..");
            if (upper == -1) {
                label.append("*]");
            } else {
                label.append(String.valueOf(upper) + CLOSING_BRACE);
            }
        }
        return label.toString();
    }

    private boolean isDependencyDescribed(Lifeline lifeline) {
        return lifeline.getClientDependencies() != null && lifeline.getClientDependencies().size() > 0 && lifeline.getClientDependencies().get(0) != null && ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers().size() > 0;
    }
}

