/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementServices {
    public static final ElementServices INSTANCE = new ElementServices();
    private static final String SCENARIO_PREFIX = "Scenario_";
    private static final String OPERATION_PREFIX = "Operation_";

    private ElementServices() {
    }

    public Type findTypeByName(Collection<EObject> roots, String typeName) {
        for (EObject root : roots) {
            Type result = this.findTypeByNameFrom(root, typeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Type findTypeByName(EObject object, String typeName) {
        Type result = this.findTypeByName(this.getAllRootsInResourceSet(object), typeName);
        return result;
    }

    private Type findTypeByNameFrom(EObject root, String typeName) {
        if (root instanceof Type && this.nameMatches((NamedElement)((Type)root), typeName)) {
            return (Type)root;
        }
        TreeIterator i = root.eAllContents();
        while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof Type) || !this.nameMatches((NamedElement)((Type)obj), typeName)) continue;
            return (Type)obj;
        }
        return null;
    }

    private Collection<EObject> getAllRootsInResourceSet(EObject context) {
        Resource res = context.eResource();
        if (res != null && res.getResourceSet() != null) {
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (Resource childRes : res.getResourceSet().getResources()) {
                roots.addAll((Collection<EObject>)childRes.getContents());
            }
            return roots;
        }
        return Collections.emptySet();
    }

    public Collection<Element> getAllRootsInSession(EObject any) {
        Session session = SessionManager.INSTANCE.getSession(any);
        ArrayList roots = Lists.newArrayList();
        if (session != null) {
            for (Resource childRes : session.getSemanticResources()) {
                for (EObject root : childRes.getContents()) {
                    if (!(root instanceof Element)) continue;
                    roots.add((Element)root);
                }
            }
        }
        return roots;
    }

    public Namespace getNamespace(NamedElement element) {
        if (element instanceof Model || element instanceof Profile) {
            return (Namespace)element;
        }
        return element.getNamespace();
    }

    public String getNewInteractionName(EObject pkg) {
        StringBuffer name = new StringBuffer(SCENARIO_PREFIX);
        name.append(this.getNumberOfElements((List)((Package)pkg).getPackagedElements(), SCENARIO_PREFIX));
        return name.toString();
    }

    public String getNewOperationName(Type type) {
        String name = "";
        EList operations = null;
        if (type instanceof Class) {
            operations = ((Class)type).getOperations();
        } else if (type instanceof Interface) {
            operations = ((Interface)type).getOperations();
        } else if (type instanceof Component) {
            operations = ((Component)type).getOperations();
        } else if (type instanceof DataType) {
            operations = ((DataType)type).getOperations();
        }
        if (operations != null) {
            name = OPERATION_PREFIX + (operations.size() + 1);
        }
        return name;
    }

    private int getNumberOfElements(List elements, String prefix) {
        int lastUsedIndex = -1;
        for (Object element : elements) {
            int index;
            String name = ((NamedElement)element).getName();
            if (name == null || !name.startsWith(prefix) || (index = Integer.valueOf(name.substring(name.lastIndexOf("_") + 1)).intValue()) <= lastUsedIndex) continue;
            lastUsedIndex = index;
        }
        return lastUsedIndex + 1;
    }

    public void importEcorePrimitiveTypes(NamedElement element) {
        INSTANCE.importPrimitiveTypes(element, "pathmap://UML_LIBRARIES/EcorePrimitiveTypes.library.uml");
    }

    public void importJavaPrimitiveTypes(NamedElement element) {
        INSTANCE.importPrimitiveTypes(element, "pathmap://UML_LIBRARIES/JavaPrimitiveTypes.library.uml");
    }

    public void importPrimitiveTypes(NamedElement element, String libraryUri) {
        Namespace namespace = this.getNamespace(element);
        ResourceSet resourceSet = namespace.eResource().getResourceSet();
        Resource resource = resourceSet.getResource(URI.createURI((String)libraryUri), true);
        Session session = SessionManager.INSTANCE.getSession((EObject)namespace);
        if (session != null) {
            session.addSemanticResource(resource.getURI(), (IProgressMonitor)new NullProgressMonitor());
        }
        Package root = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        if (!namespace.getImportedPackages().contains((Object)root)) {
            namespace.createPackageImport(root);
        }
    }

    public void importUmlPrimitiveTypes(NamedElement element) {
        INSTANCE.importPrimitiveTypes(element, "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
    }

    public void importXmlPrimitiveTypes(NamedElement element) {
        INSTANCE.importPrimitiveTypes(element, "pathmap://UML_LIBRARIES/XMLPrimitiveTypes.library.uml");
    }

    public boolean isComponent(EObject element) {
        return element instanceof Component;
    }

    private boolean nameMatches(NamedElement namedElt, String name) {
        if (namedElt != null && namedElt.getName() != null && name != null) {
            return namedElt.getName().trim().equalsIgnoreCase(name.trim());
        }
        return false;
    }
}

