/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class ExtensionServices {
    public static final ExtensionServices INSTANCE = new ExtensionServices();
    private static final String BASE = "base_";

    private ExtensionServices() {
    }

    public boolean canCreateExtension(EObject source, EObject target) {
        if (source instanceof Stereotype) {
            Stereotype stereotypeTarget;
            Stereotype stereotypeSource = (Stereotype)source;
            if (target instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)target;
                PackageableElement metaClass = elementImport.getImportedElement();
                NamedElement baseProperty = stereotypeSource.getMember(BASE + metaClass.getName());
                if (baseProperty == null) {
                    return true;
                }
                if (baseProperty instanceof Property && ((Property)baseProperty).getType().equals(metaClass)) {
                    return true;
                }
            }
            if (target instanceof Stereotype && !source.equals(target) && stereotypeSource.getGeneralization((Classifier)(stereotypeTarget = (Stereotype)target)) == null && stereotypeTarget.getGeneralization((Classifier)stereotypeSource) == null) {
                return true;
            }
        }
        return false;
    }

    public boolean canReconnectExtension(EObject element, EObject target) {
        if (element instanceof Extension) {
            Extension extension = (Extension)element;
            if (target instanceof ElementImport) {
                Class newPointedMetaClass = (Class)((ElementImport)target).getImportedElement();
                NamedElement baseProperty = extension.getStereotype().getMember(BASE + newPointedMetaClass.getName());
                if (baseProperty == null) {
                    return true;
                }
                if (baseProperty instanceof Property && !((Property)baseProperty).getType().equals(newPointedMetaClass)) {
                    return true;
                }
            }
            if (target instanceof Stereotype) {
                NamedElement baseProperty = ((Stereotype)target).getMember(BASE + extension.getMetaclass().getName());
                if (baseProperty == null) {
                    return true;
                }
                if (baseProperty instanceof Property && !((Property)baseProperty).getType().equals(extension.getMetaclass())) {
                    return true;
                }
            }
        }
        return false;
    }

    public void createExtension(Stereotype stereotype, Element targetElement) {
        if (targetElement instanceof ElementImport) {
            this.createMetaclassExtension(stereotype, (ElementImport)targetElement);
        } else if (targetElement instanceof Stereotype) {
            this.createGeneralization(stereotype, (Stereotype)targetElement);
        }
    }

    public void createGeneralization(Stereotype stereotypeSource, Stereotype stereotypeTarget) {
        if (!this.isGeneraleFor(stereotypeTarget, stereotypeSource)) {
            Generalization generalization = UMLFactory.eINSTANCE.createGeneralization();
            generalization.setGeneral((Classifier)stereotypeTarget);
            generalization.setSpecific((Classifier)stereotypeSource);
            stereotypeSource.getGeneralizations().add((Object)generalization);
        }
    }

    public Extension createMetaclassExtension(Stereotype stereotype, ElementImport elementImport) {
        Extension extension = null;
        PackageableElement importedElement = elementImport.getImportedElement();
        if (importedElement != null && importedElement instanceof Type && !this.isExtendedBy((Type)importedElement, stereotype)) {
            Type metaclass = (Type)importedElement;
            Property baseMetaclass = UMLFactory.eINSTANCE.createProperty();
            baseMetaclass.setName(BASE + metaclass.getName());
            baseMetaclass.setType(metaclass);
            stereotype.getOwnedAttributes().add((Object)baseMetaclass);
            ExtensionEnd extensionEnd = UMLFactory.eINSTANCE.createExtensionEnd();
            extensionEnd.setName("extension_" + stereotype.getName());
            extensionEnd.setType((Type)stereotype);
            extension = UMLFactory.eINSTANCE.createExtension();
            extension.getOwnedEnds().add((Object)extensionEnd);
            extension.getMemberEnds().add((Object)baseMetaclass);
            stereotype.getProfile().getPackagedElements().add((Object)extension);
        }
        return extension;
    }

    public ElementImport getElementImport(Extension extension) {
        Profile profileOwner = this.getProfileOwner((Element)extension);
        if (profileOwner.getMetaclassReference((PackageableElement)extension.getMetaclass()) != null) {
            return profileOwner.getMetaclassReference((PackageableElement)extension.getMetaclass());
        }
        return null;
    }

    public Extension getExtension(Stereotype stereotype, Type metaclass) {
        for (Extension extention : stereotype.getProfile().getOwnedExtensions(false)) {
            if (extention.getName() == null || !extention.getName().equals(String.valueOf(stereotype.getName()) + "Extend" + metaclass.getName())) continue;
            return extention;
        }
        return null;
    }

    public Profile getProfileOwner(Element umlElement) {
        if (umlElement.getOwner() instanceof Profile) {
            return (Profile)umlElement.getOwner();
        }
        return this.getProfileOwner(umlElement.getOwner());
    }

    public boolean isExtendedBy(Type metaclassType, Stereotype stereotype) {
        return stereotype.getOwnedAttribute(BASE + metaclassType.getName(), metaclassType) != null;
    }

    private boolean isGeneraleFor(Stereotype stereotypeTarget, Stereotype stereotypeSource) {
        for (Generalization generalization : stereotypeSource.getGeneralizations()) {
            if (!generalization.getGeneral().equals(stereotypeTarget)) continue;
            return true;
        }
        return false;
    }
}

