/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

public class GenericUMLProfileTools {
    public static String getLabel(Object object, boolean shortLabel) {
        String label = "";
        if (object == null) {
            return "undefined";
        }
        if (object instanceof ValueSpecification) {
            label = GenericUMLProfileTools.getLabel((ValueSpecification)object);
        } else if (object instanceof Element) {
            Element cE = (Element)object;
            String cName = null;
            String suffix = "";
            String cComLabel = "";
            NamedElement cNE = null;
            if (object instanceof NamedElement) {
                cNE = (NamedElement)object;
            } else if (object instanceof PackageImport) {
                PackageImport cPI = (PackageImport)object;
                suffix = " (PackageImport)";
                cNE = cPI.getImportedPackage();
            } else if (object instanceof ElementImport) {
                ElementImport cEI = (ElementImport)object;
                suffix = " (ElementImport)";
                cNE = cEI.getImportedElement();
            } else if (object instanceof ProfileApplication) {
                ProfileApplication cPA = (ProfileApplication)object;
                suffix = " (ProfileApplication)";
                cNE = cPA.getAppliedProfile();
            } else if (object instanceof Comment) {
                Comment cCom = (Comment)object;
                suffix = " (Comment)";
                String cComBody = cCom.getBody();
                cComLabel = cComBody.length() >= 10 ? String.valueOf(cComBody.substring(0, 9)) + "..." : cComBody;
            }
            if (shortLabel) {
                if (object instanceof Comment) {
                    cName = cComLabel;
                } else if (cNE != null) {
                    cName = cNE.getName();
                }
            } else if (object instanceof Comment) {
                cName = String.valueOf(cComLabel) + suffix;
            } else if (cNE != null) {
                cName = String.valueOf(cNE.getQualifiedName()) + suffix;
            }
            label = cName != null ? cName : cE.toString();
        }
        return label;
    }

    public static String getLabel(ValueSpecification value) {
        String label = "";
        label = value instanceof LiteralBoolean ? "<LiteralBoolean> " : (value instanceof LiteralInteger ? "<LiteralInteger> " : (value instanceof LiteralString ? "<LiteralString> " : (value instanceof LiteralUnlimitedNatural ? "<LiteralUnlimitedNatural> " : "<ValueSpecification> ")));
        label = String.valueOf(label) + value.stringValue();
        return label;
    }

    public static boolean isMetaclass(Type type) {
        Stereotype firstStereotype;
        boolean isMetaclass = false;
        if (type instanceof Class && type.getAppliedStereotypes() != null && type.getAppliedStereotypes().size() > 0 && (firstStereotype = (Stereotype)type.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            isMetaclass = true;
        }
        return isMetaclass;
    }

    public static Package load(URI uri) {
        Package package_ = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            LogServices.INSTANCE.error("load(" + uri.getClass() + ") not handled", we);
            System.exit(1);
        }
        return package_;
    }

    public static EPackage load(URI uri, EClassifier type) {
        EPackage package_ = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (EPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)type);
        }
        catch (WrappedException we) {
            LogServices.INSTANCE.error("load(" + uri.getClass() + "," + type.getClass() + ") not handled", we);
            System.exit(1);
        }
        return package_;
    }

    public static IFile resourceToIFile(Resource resource) {
        URI uriEcoreProfile = resource.getURI();
        URI resolvedUriEcoreProfile = CommonPlugin.resolve((URI)uriEcoreProfile);
        IFile ecoreProfileIFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(resolvedUriEcoreProfile.toFileString()));
        return ecoreProfileIFile;
    }

    public static void save(Package package_) {
        Resource resource = null;
        if (package_.eResource() != null) {
            resource = package_.eResource();
            try {
                resource.save(null);
            }
            catch (IOException ioe) {
                LogServices.INSTANCE.error("save(" + package_.getClass() + ") not handled", ioe);
            }
        }
    }

    public static void save(Package package_, URI uri) {
        Resource resource = new ResourceSetImpl().createResource(uri);
        resource.getContents().add((Object)package_);
        try {
            resource.save(null);
        }
        catch (IOException ioe) {
            LogServices.INSTANCE.error("save(" + package_.getClass() + "," + uri.getClass() + ") not handled", ioe);
        }
    }
}

