/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInverseRefsServices {
    public static final NodeInverseRefsServices INSTANCE = new NodeInverseRefsServices();

    private NodeInverseRefsServices() {
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Association");
    }

    public Collection<EObject> getComponentRealizationInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "ComponentRealization");
    }

    public Collection<EObject> getConnectorInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Connector");
    }

    public Collection<EObject> getDependencyInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Dependency");
    }

    public Collection<EObject> getDependencyOnlyInverseRefs(DDiagram diagram) {
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject eObj) {
                String className = eObj.eClass().getName();
                return "Dependency".equals(className);
            }
        };
        return Collections2.filter(this.getDependencyInverseRefs(diagram), (Predicate)predicate);
    }

    public Collection<EObject> getDependencyOrManifestationInverseRefs(DDiagram diagram) {
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject eObj) {
                String className = eObj.eClass().getName();
                return "Dependency".equals(className) || "Manifestation".equals(className);
            }
        };
        return Collections2.filter(this.getDependencyInverseRefs(diagram), (Predicate)predicate);
    }

    public Collection<EObject> getDeploymentInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Deployment");
    }

    public Collection<EObject> getGeneralizationInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Generalization");
    }

    public Collection<EObject> getInterfaceRealizationInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "InterfaceRealization");
    }

    public Collection<EObject> getNodeInverseRefs(DDiagram diagram, String typeName) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (diagram instanceof DSemanticDecorator) {
            Session sess = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
            Iterator it = Iterators.transform((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), AbstractDNode.class), (Function)new Function<AbstractDNode, EObject>(){

                public EObject apply(AbstractDNode input) {
                    return input.getTarget();
                }
            });
            while (it.hasNext()) {
                EObject displayedAsANode = (EObject)it.next();
                if (displayedAsANode == null) continue;
                for (EStructuralFeature.Setting xRef : sess.getSemanticCrossReferencer().getInverseReferences(displayedAsANode)) {
                    EObject eObject = xRef.getEObject();
                    if (xRef instanceof DerivedUnionEObjectEList) {
                        for (EObject eObject2 : (List)xRef) {
                            if (!sess.getModelAccessor().eInstanceOf(eObject2, typeName)) continue;
                            result.add(eObject2);
                        }
                    }
                    if (sess.getModelAccessor().eInstanceOf(eObject, typeName)) {
                        result.add(eObject);
                    }
                    if (!(eObject instanceof Property) || ((Property)eObject).getAssociation() == null || !sess.getModelAccessor().eInstanceOf((EObject)((Property)eObject).getAssociation(), typeName)) continue;
                    result.add(((Property)eObject).getAssociation());
                }
            }
        }
        return result;
    }

    public Collection<EObject> getNodeInverseRefs(DDiagramElement containerView, String typeName) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        Session sess = SessionManager.INSTANCE.getSession(containerView.getTarget());
        Iterator it = Iterators.transform((Iterator)Iterators.filter((Iterator)containerView.eAllContents(), AbstractDNode.class), (Function)new Function<AbstractDNode, EObject>(){

            public EObject apply(AbstractDNode input) {
                return input.getTarget();
            }
        });
        while (it.hasNext()) {
            EObject displayedAsANode = (EObject)it.next();
            if (displayedAsANode == null) continue;
            for (EStructuralFeature.Setting xRef : sess.getSemanticCrossReferencer().getInverseReferences(displayedAsANode)) {
                EObject eObject = xRef.getEObject();
                if (sess.getModelAccessor().eInstanceOf(eObject, typeName)) {
                    result.add(eObject);
                }
                if (!(eObject instanceof Property) || ((Property)eObject).getAssociation() == null || !sess.getModelAccessor().eInstanceOf((EObject)((Property)eObject).getAssociation(), typeName)) continue;
                result.add(((Property)eObject).getAssociation());
            }
        }
        return result;
    }

    public Collection<EObject> getTemplateBindingInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "TemplateBinding");
    }

    public Collection<EObject> getUsageInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Usage");
    }
}

