/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NameAndType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationServices {
    public static final OperationServices INSTANCE = new OperationServices();

    private OperationServices() {
    }

    private Parameter createInputParameter(String name, Type type) {
        Parameter param = UMLFactory.eINSTANCE.createParameter();
        param.setDirection(ParameterDirectionKind.IN_LITERAL);
        param.setName(name);
        param.setType(type);
        return param;
    }

    public Operation createOperation(Type type) {
        String name = ElementServices.INSTANCE.getNewOperationName(type);
        Operation operation = null;
        if (type instanceof Class) {
            operation = ((Class)type).createOwnedOperation(name, null, null, null);
        } else if (type instanceof Interface) {
            operation = ((Interface)type).createOwnedOperation(name, null, null, null);
        } else if (type instanceof Component) {
            operation = ((Component)type).createOwnedOperation(name, null, null, null);
        } else if (type instanceof DataType) {
            operation = ((DataType)type).createOwnedOperation(name, null, null, null);
        }
        return operation;
    }

    private void handleMultiplicity(Operation operation, String lowerBound, String upperBound) {
        int lower = LabelServices.INSTANCE.convertBound(lowerBound);
        int upper = LabelServices.INSTANCE.convertBound(upperBound);
        if (lower != Integer.MAX_VALUE && upper != Integer.MAX_VALUE && (lower <= upper || upper == -1)) {
            if (lower == -1) {
                operation.setLower(0);
            } else {
                operation.setLower(lower);
            }
            operation.setUpper(upper);
        }
    }

    private void handleParameters(Operation operation, List<NameAndType> paramsToBeCreated) {
        NameAndType paramInfo;
        ArrayList existingParams = new ArrayList(operation.getOwnedParameters());
        ArrayList<Parameter> existingNonReturnParams = new ArrayList<Parameter>();
        for (Parameter parameter : existingParams) {
            if (ParameterDirectionKind.RETURN_LITERAL.equals((Object)parameter.getDirection())) continue;
            parameter.getOperation().getOwnedParameters().remove((Object)parameter);
            existingNonReturnParams.add(parameter);
        }
        Parameter[] tabParameters = new Parameter[paramsToBeCreated.size()];
        boolean[] tabMarkers = new boolean[paramsToBeCreated.size()];
        int i = 0;
        while (i < paramsToBeCreated.size()) {
            paramInfo = paramsToBeCreated.get(i);
            String newName = paramInfo.getName();
            int j = 0;
            while (j < existingNonReturnParams.size()) {
                Parameter existingParam = (Parameter)existingNonReturnParams.get(j);
                String oldName = existingParam.getName();
                if (newName == null && oldName == null || newName != null && newName.equalsIgnoreCase(oldName)) {
                    tabParameters[i] = (Parameter)existingNonReturnParams.remove(j);
                    this.updateType(tabParameters[i], paramInfo.getType());
                    tabMarkers[i] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < paramsToBeCreated.size()) {
            if (!tabMarkers[i]) {
                paramInfo = paramsToBeCreated.get(i);
                if (existingNonReturnParams.isEmpty()) {
                    tabParameters[i] = this.createInputParameter(paramInfo.getName(), paramInfo.getType());
                } else {
                    tabParameters[i] = (Parameter)existingNonReturnParams.remove(0);
                    tabParameters[i].setName(paramInfo.getName());
                    this.updateType(tabParameters[i], paramInfo.getType());
                }
            }
            ++i;
        }
        for (Parameter unusedParam : existingNonReturnParams) {
            EcoreUtil.delete((EObject)unusedParam);
        }
        Parameter[] parameterArray = tabParameters;
        int n = tabParameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter remainingParam = parameterArray[n2];
            operation.getOwnedParameters().add((Object)remainingParam);
            ++n2;
        }
    }

    private void handleParameters(Operation operation, String parametersInfo) {
        Pattern ptnParam = Pattern.compile("^([^:]*)\\s*:?\\s*(.*)$");
        ArrayList<NameAndType> paramsToBeCreated = new ArrayList<NameAndType>();
        if (parametersInfo != null && !"".equals(parametersInfo.trim())) {
            String[] paramInfos = parametersInfo.split("\\s*,\\s*");
            int i = 0;
            while (i < paramInfos.length) {
                String paramInfo = paramInfos[i];
                Matcher mtchParam = ptnParam.matcher(paramInfo);
                if (mtchParam.find()) {
                    String name = mtchParam.group(1).trim();
                    String typeName = mtchParam.group(2).trim();
                    Type foundType = null;
                    if (typeName != null && !"".equals(typeName)) {
                        foundType = ElementServices.INSTANCE.findTypeByName((EObject)operation, typeName);
                    }
                    paramsToBeCreated.add(new NameAndType(name, foundType));
                }
                ++i;
            }
        }
        this.handleParameters(operation, paramsToBeCreated);
    }

    private void handleReturnType(Operation operation, String returnTypeName) {
        if (returnTypeName != null && !"".equals(returnTypeName)) {
            Type foundType;
            if (!(operation.getType() != null && returnTypeName.equalsIgnoreCase(operation.getType().getName()) || (foundType = ElementServices.INSTANCE.findTypeByName((EObject)operation, returnTypeName)) == null)) {
                operation.setType(foundType);
            }
        } else {
            operation.setType(null);
        }
    }

    public void parseInputLabel(Operation operation, String inputLabel) {
        Pattern ptnWithType = Pattern.compile("^([^(]*)\\(?([^)]*)\\)?\\s*:([^)]*)$");
        Matcher mtchWithType = ptnWithType.matcher(inputLabel.trim());
        boolean matchFound = false;
        boolean typeWasSpecified = false;
        String name = null;
        String parametersInfo = null;
        String returnType = null;
        if (mtchWithType.find()) {
            matchFound = true;
            typeWasSpecified = true;
            name = mtchWithType.group(1).trim();
            parametersInfo = mtchWithType.group(2).trim();
            returnType = mtchWithType.group(3).trim();
            Pattern ptnTypeInfo = Pattern.compile("^(.*)\\[\\s*((\\S+)\\s*\\.\\.)?\\s*(\\S+)\\s*\\]$");
            Matcher mtchTypeInfo = ptnTypeInfo.matcher(returnType);
            if (mtchTypeInfo.find()) {
                String lowerBound = mtchTypeInfo.group(3);
                String upperBound = mtchTypeInfo.group(4);
                if ((lowerBound == null || lowerBound.matches("^[0-9]+$")) && upperBound.matches("^[1-9][0-9]*|\\*|-1$")) {
                    if (lowerBound == null || "".equals(lowerBound)) {
                        this.handleMultiplicity(operation, upperBound, upperBound);
                    } else {
                        this.handleMultiplicity(operation, lowerBound, upperBound);
                    }
                }
            }
        } else {
            Pattern ptnWithoutType = Pattern.compile("^([^(]*)\\(?([^)]*)\\)?");
            Matcher mtchWithoutType = ptnWithoutType.matcher(inputLabel.trim());
            if (mtchWithoutType.find()) {
                matchFound = true;
                typeWasSpecified = false;
                name = mtchWithoutType.group(1).trim();
                parametersInfo = mtchWithoutType.group(2).trim();
            }
        }
        if (matchFound) {
            operation.setName(name);
            this.handleParameters(operation, parametersInfo);
            if (typeWasSpecified) {
                this.handleReturnType(operation, returnType);
            }
        }
    }

    private void updateType(Parameter param, Type type) {
        if (type == null) {
            param.setType(null);
        } else if (!type.equals(param.getType())) {
            param.setType(type);
        }
    }
}

