/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ProfileVersionDialog;
import org.obeonetwork.dsl.uml2.design.internal.services.UMLDesignerProfileVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServices {
    public static final ProfileServices INSTANCE = new ProfileServices();
    public static final String ELEMENT = "Element";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String ENDTYPE = "endType";
    private static ResourceSet resourceSet = new ResourceSetImpl();
    private static Resource resource = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
    private static Model umlMetamodel = (Model)resource.getContents().get(0);

    private ProfileServices() {
    }

    public boolean defineAllProfiles(Profile rootProfile) {
        return this.defineProfile(rootProfile, this.getAllSubProfiles(rootProfile));
    }

    private boolean defineAndAnnotateProfile(Profile profile, UMLDesignerProfileVersion profileVersionAnnotation) {
        boolean result = true;
        if (profile.define() == null) {
            result = false;
        } else {
            EPackage rootProfileDefinition = profile.getDefinition();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            UMLDesignerProfileVersion umlDesignerProfileVersion = new UMLDesignerProfileVersion();
            umlDesignerProfileVersion.initEAnnotationVersion(eAnnotation, profileVersionAnnotation);
            rootProfileDefinition.getEAnnotations().add((Object)eAnnotation);
        }
        return result;
    }

    public boolean defineProfile(Profile rootProfile, List<Profile> allContentProfile) {
        boolean result = false;
        ProfileVersionDialog versionDialog = new ProfileVersionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), rootProfile);
        versionDialog.open();
        if (versionDialog.getReturnCode() == 0) {
            UMLDesignerProfileVersion uMLDesignerProfileVersion = versionDialog.getUMLDesignerProfileVersion();
            this.undefineProfile(rootProfile);
            result = this.defineAndAnnotateProfile(rootProfile, uMLDesignerProfileVersion);
            for (Profile profile : allContentProfile) {
                result = this.defineAndAnnotateProfile(profile, uMLDesignerProfileVersion);
            }
        }
        return result;
    }

    public List<Profile> getAllSubProfiles(Profile rootProfile) {
        ArrayList allSubProfiles = Lists.newArrayList((Iterator)Iterators.filter((Iterator)rootProfile.eAllContents(), Profile.class));
        allSubProfiles.remove(rootProfile);
        return allSubProfiles;
    }

    public List<Class> getAllSuperClasses(Class subClass) {
        ArrayList<Class> superClasses = new ArrayList<Class>();
        if (subClass.getName().equals(ELEMENT)) {
            superClasses.add(subClass);
            return superClasses;
        }
        for (Class superClass : subClass.getSuperClasses()) {
            if (this.isIn(superClass, superClasses)) continue;
            superClasses.add(superClass);
            superClasses.addAll(this.getAllSuperClasses(superClass));
        }
        return superClasses;
    }

    private Property getAttributeByName(Class drMetaclassToTest, String propertyName) {
        for (Property att : drMetaclassToTest.getAllAttributes()) {
            if (!att.getName().equals(propertyName)) continue;
            return att;
        }
        return null;
    }

    public ArrayList<Property> getRelationShipSourceTargetPeroperties(Class relationShipSubClasse) {
        Property sourceProp = null;
        Property targetProp = null;
        for (Property propertyToTest : relationShipSubClasse.getAttributes()) {
            if (this.isInSubSet(propertyToTest, SOURCE)) {
                sourceProp = propertyToTest;
            }
            if (this.isInSubSet(propertyToTest, TARGET)) {
                targetProp = propertyToTest;
            }
            if (sourceProp != null && targetProp != null) break;
        }
        if (sourceProp == null || targetProp == null) {
            block1: for (Class superClass : this.getAllSuperClasses(relationShipSubClasse)) {
                for (Property propertyToTest : superClass.getAttributes()) {
                    if (this.isInSubSet(propertyToTest, SOURCE)) {
                        sourceProp = propertyToTest;
                    }
                    if (this.isInSubSet(propertyToTest, TARGET)) {
                        targetProp = propertyToTest;
                    }
                    if (sourceProp != null && targetProp != null) continue block1;
                }
            }
        }
        if (sourceProp == null) {
            sourceProp = this.getAttributeByName(relationShipSubClasse, SOURCE);
        }
        if (targetProp == null) {
            targetProp = this.getAttributeByName(relationShipSubClasse, TARGET);
        }
        if (sourceProp == null || targetProp == null) {
            sourceProp = UMLFactory.eINSTANCE.createProperty();
            targetProp = UMLFactory.eINSTANCE.createProperty();
            if (relationShipSubClasse.getName().equals("Extension")) {
                sourceProp.setType((Type)((Class)umlMetamodel.getMember("Stereotype")));
                sourceProp.setName("stereotype");
                targetProp.setType((Type)((Class)umlMetamodel.getMember("Class")));
                targetProp.setName("metaClass");
            }
            if (relationShipSubClasse.getName().equals("CommunicationPath")) {
                sourceProp.setType((Type)((Class)umlMetamodel.getMember("DeploymentTarget")));
                sourceProp.setName(ENDTYPE);
                targetProp.setType((Type)((Class)umlMetamodel.getMember("DeploymentTarget")));
                targetProp.setName(ENDTYPE);
            }
            if (relationShipSubClasse.getName().equals("AssociationClass")) {
                sourceProp.setType((Type)((Class)umlMetamodel.getMember("Classifier")));
                sourceProp.setName(ENDTYPE);
                targetProp.setType((Type)((Class)umlMetamodel.getMember("Classifier")));
                targetProp.setName(ENDTYPE);
            }
            if (relationShipSubClasse.getName().equals("Association")) {
                sourceProp.setType((Type)((Class)umlMetamodel.getMember("Type")));
                sourceProp.setName(ENDTYPE);
                targetProp.setType((Type)((Class)umlMetamodel.getMember("Type")));
                targetProp.setName(ENDTYPE);
            }
            if (relationShipSubClasse.getName().equals("Relationship")) {
                sourceProp.setType((Type)((Class)umlMetamodel.getMember(ELEMENT)));
                sourceProp.setName("relatedElement");
                targetProp.setType((Type)((Class)umlMetamodel.getMember(ELEMENT)));
                targetProp.setName("relatedElement");
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(sourceProp);
        properties.add(targetProp);
        return properties;
    }

    public boolean isIn(Class propName, List<Class> classes) {
        for (Class class1 : classes) {
            if (!class1.getName().equals(propName.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isInSubSet(Property property, String propName) {
        boolean result = false;
        Iterator iterator = property.getSubsettedProperties().iterator();
        if (iterator.hasNext()) {
            Property overProperty = (Property)iterator.next();
            if (overProperty.getName().equals(propName)) {
                result = true;
            } else {
                return this.isInSubSet(overProperty, propName);
            }
        }
        return result;
    }

    public void undefineProfile(Profile rootProfile) {
        if (rootProfile.getDefinition() != null) {
            List<Profile> allContentProfile = this.getAllSubProfiles(rootProfile);
            rootProfile.getEAnnotations().remove((Object)rootProfile.getDefinition().eContainer());
            for (Profile profile : allContentProfile) {
                if (profile.getDefinition() == null) continue;
                profile.getEAnnotations().remove((Object)profile.getDefinition().eContainer());
            }
        }
    }
}

