/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;

public final class PropertyServices {
    public static final PropertyServices INSTANCE = new PropertyServices();

    private PropertyServices() {
    }

    private void handleMultiplicity(Property property, String lowerBound, String upperBound) {
        int lower = LabelServices.INSTANCE.convertBound(lowerBound);
        int upper = LabelServices.INSTANCE.convertBound(upperBound);
        if (lower != Integer.MAX_VALUE && upper != Integer.MAX_VALUE && (lower <= upper || upper == -1)) {
            if (lower == -1) {
                property.setLower(0);
            } else {
                property.setLower(lower);
            }
            property.setUpper(upper);
        }
    }

    private void handleTypeAndMultiplicity(Property property, String typeInfo) {
        Pattern ptnTypeInfo = Pattern.compile("^(.*)\\[\\s*((\\S+)\\s*\\.\\.)?\\s*(\\S+)\\s*\\]$");
        Matcher mtchTypeInfo = ptnTypeInfo.matcher(typeInfo);
        String typeName = "";
        if (mtchTypeInfo.find()) {
            typeName = mtchTypeInfo.group(1);
            String lowerBound = mtchTypeInfo.group(3);
            String upperBound = mtchTypeInfo.group(4);
            if ((lowerBound == null || lowerBound.matches("^[0-9]+$")) && upperBound.matches("^[1-9][0-9]*|\\*|-1$")) {
                if (lowerBound == null || "".equals(lowerBound)) {
                    this.handleMultiplicity(property, upperBound, upperBound);
                } else {
                    this.handleMultiplicity(property, lowerBound, upperBound);
                }
            }
        } else {
            typeName = typeInfo;
        }
        if (typeName != null && !"".equals(typeName)) {
            Type foundType = ElementServices.INSTANCE.findTypeByName((EObject)property, typeName);
            if (foundType == null) {
                Namespace namespace = (Namespace)property.eContainer();
                if (this.isUmlPrimitiveType(namespace, typeName)) {
                    ElementServices.INSTANCE.importUmlPrimitiveTypes((NamedElement)namespace);
                } else if (this.isEcorePrimitiveType(namespace, typeName)) {
                    ElementServices.INSTANCE.importEcorePrimitiveTypes((NamedElement)namespace);
                } else if (this.isJavaPrimitiveType(namespace, typeName)) {
                    ElementServices.INSTANCE.importJavaPrimitiveTypes((NamedElement)namespace);
                } else if (this.isXmlPrimitiveType(namespace, typeName)) {
                    ElementServices.INSTANCE.importXmlPrimitiveTypes((NamedElement)namespace);
                }
                foundType = ElementServices.INSTANCE.findTypeByName((EObject)property, typeName);
            }
            if (foundType != null) {
                property.setType(foundType);
            }
        }
    }

    public boolean isEcorePrimitiveType(Namespace namespace, String typeName) {
        return this.isPrimitiveType(namespace, typeName, "pathmap://UML_LIBRARIES/EcorePrimitiveTypes.library.uml");
    }

    public boolean isJavaPrimitiveType(Namespace namespace, String typeName) {
        return this.isPrimitiveType(namespace, typeName, "pathmap://UML_LIBRARIES/JavaPrimitiveTypes.library.uml");
    }

    private boolean isPrimitiveType(Namespace namespace, String typeName, String libraryUri) {
        Type foundType;
        ResourceSet resourceSet = namespace.eResource().getResourceSet();
        Resource resource = resourceSet.getResource(URI.createURI((String)libraryUri), true);
        Package root = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        return typeName != null && !"".equals(typeName) && (foundType = ElementServices.INSTANCE.findTypeByName((EObject)root, typeName)) != null;
    }

    public boolean isUmlPrimitiveType(Namespace namespace, String typeName) {
        return this.isPrimitiveType(namespace, typeName, "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
    }

    public boolean isXmlPrimitiveType(Namespace namespace, String typeName) {
        return this.isPrimitiveType(namespace, typeName, "pathmap://UML_LIBRARIES/XMLPrimitiveTypes.library.uml");
    }

    public String parseInputLabel(Property property, String inputLabel) {
        Pattern p = Pattern.compile("\\[?([0-9]*)[ .]*(([0-9 \\* \\-1]*)?)\\]?");
        Matcher m = p.matcher(inputLabel.trim());
        if (m.find() && m.group(1) != null && m.group(1).length() > 0 || m.group(2) != null && m.group(2).length() > 0) {
            String lower = m.group(1).trim();
            String upper = m.group(2).trim();
            if (upper != null && upper.length() > 0) {
                if ("*".equals(upper) || "-1".equals(upper)) {
                    property.setUpper(-1);
                    property.setLower(0);
                } else {
                    property.setUpper(Integer.parseInt(upper));
                }
            } else if (lower != null && lower.length() > 0) {
                property.setUpper(Integer.parseInt(lower));
            }
            if (lower != null && lower.length() > 0) {
                property.setLower(Integer.parseInt(lower));
            }
        } else {
            p = Pattern.compile("^(/?)([^:]*):?([^=]*)=?(.*)$");
            m = p.matcher(inputLabel.trim());
            if (m.find()) {
                boolean isDerived = m.group(1) != null && !"".equals(m.group(1));
                property.setIsDerived(isDerived);
                String name = m.group(2).trim();
                if (name != null && name.length() > 0) {
                    property.setName(name);
                }
                String typeInfo = m.group(3).trim();
                this.handleTypeAndMultiplicity(property, typeInfo);
                if (m.group(4) != null && !"".equals(m.group(4))) {
                    String defaultValue = m.group(4).trim();
                    property.setDefault(defaultValue);
                }
                return name;
            }
        }
        return property.getName();
    }
}

