/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.AssociationServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ReconnectPreconditionSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconnectSwitch
extends UMLSwitch<Element> {
    public static final int RECONNECT_SOURCE = 0;
    public static final int RECONNECT_TARGET = 1;
    private int reconnectKind;
    private Element oldPointedElement;
    private Element newPointedElement;

    public Element caseAssociation(Association association) {
        if (this.isReconnectable((Element)association)) {
            if (this.reconnectKind == 0) {
                Property source = AssociationServices.INSTANCE.getSource(association);
                source.setType((Type)this.newPointedElement);
            } else {
                Property target = AssociationServices.INSTANCE.getTarget(association);
                target.setType((Type)this.newPointedElement);
            }
        }
        return association;
    }

    public Element caseComponent(Component component) {
        if (1 == this.reconnectKind) {
            if (this.newPointedElement instanceof Package) {
                ((Package)this.newPointedElement).getPackagedElements().add((Object)component);
            } else if (this.newPointedElement instanceof Component) {
                ((Component)this.newPointedElement).getPackagedElements().add((Object)component);
            }
        } else if (this.newPointedElement instanceof PackageableElement) {
            EObject newParent = component.eContainer();
            if (newParent instanceof Package) {
                ((Package)newParent).getPackagedElements().add((Object)((PackageableElement)this.newPointedElement));
            } else if (newParent instanceof Component) {
                ((Component)newParent).getPackagedElements().add((Object)((PackageableElement)this.newPointedElement));
            }
            EObject root = EcoreUtil.getRootContainer((EObject)component);
            if (root instanceof Package) {
                ((Package)root).getPackagedElements().add((Object)component);
            }
        }
        return component;
    }

    public Element caseComponentRealization(ComponentRealization cRealization) {
        if (this.reconnectKind == 0) {
            if (this.newPointedElement instanceof Classifier) {
                Classifier realizingClassifier = (Classifier)this.newPointedElement;
                cRealization.getRealizingClassifiers().clear();
                cRealization.getRealizingClassifiers().add((Object)realizingClassifier);
                cRealization.setName(String.valueOf(realizingClassifier.getName()) + "To" + cRealization.getAbstraction().getName());
            }
        } else if (this.newPointedElement instanceof Component) {
            Component abstraction = (Component)this.newPointedElement;
            EList realizingClassifiers = cRealization.getRealizingClassifiers();
            String realizingClassifierName = "";
            if (!realizingClassifiers.isEmpty()) {
                realizingClassifierName = ((Classifier)realizingClassifiers.get(0)).getName();
            }
            cRealization.setAbstraction(abstraction);
            cRealization.setName(String.valueOf(realizingClassifierName) + "To" + abstraction.getName());
        }
        return cRealization;
    }

    public Element caseConnector(Connector connector) {
        if (this.reconnectKind == 0) {
            if (this.newPointedElement instanceof ConnectableElement) {
                ((ConnectorEnd)connector.getEnds().get(0)).setRole((ConnectableElement)this.newPointedElement);
            }
        } else if (this.newPointedElement instanceof ConnectableElement) {
            ((ConnectorEnd)connector.getEnds().get(1)).setRole((ConnectableElement)this.newPointedElement);
        }
        return connector;
    }

    public Element caseDependency(Dependency dependency) {
        if (this.isReconnectable((Element)dependency)) {
            if (this.reconnectKind == 0) {
                dependency.getClients().clear();
                dependency.getClients().add((Object)((NamedElement)this.newPointedElement));
            } else {
                dependency.getSuppliers().clear();
                dependency.getSuppliers().add((Object)((NamedElement)this.newPointedElement));
            }
        }
        return dependency;
    }

    public Element caseDeployment(Deployment deployment) {
        if (this.newPointedElement instanceof Classifier) {
            if (this.reconnectKind == 0) {
                deployment.getSuppliers().clear();
                deployment.getSuppliers().add((Object)((Classifier)this.newPointedElement));
                deployment.getDeployedArtifacts().clear();
                deployment.getDeployedArtifacts().add((Object)((DeployedArtifact)this.newPointedElement));
            } else {
                deployment.getClients().clear();
                ((Classifier)this.newPointedElement).getClientDependencies().add((Object)deployment);
                ((DeploymentTarget)this.newPointedElement).getDeployments().add((Object)deployment);
            }
            return deployment;
        }
        return deployment;
    }

    public Element caseExtension(Extension extension) {
        if (this.reconnectKind == 0) {
            if (this.newPointedElement instanceof Stereotype) {
                int i = 0;
                while (i < extension.getMemberEnds().size()) {
                    if (extension.getMemberEnds().get(i) instanceof ExtensionEnd) {
                        ((ExtensionEnd)extension.getMemberEnds().get(i)).setType((Type)this.newPointedElement);
                    } else {
                        ((Stereotype)this.newPointedElement).getOwnedAttributes().add(0, (Object)((Property)extension.getMemberEnds().get(i)));
                    }
                    ++i;
                }
            }
        } else if (this.newPointedElement instanceof ElementImport) {
            Property baseProperty = extension.getStereotype().getOwnedAttribute("base_" + extension.getMetaclass().getName(), (Type)extension.getMetaclass());
            Class newPointedMetaClass = (Class)((ElementImport)this.newPointedElement).getImportedElement();
            if (baseProperty != null && newPointedMetaClass != null) {
                baseProperty.setType((Type)((Class)((ElementImport)this.newPointedElement).getImportedElement()));
                baseProperty.setName("base_" + newPointedMetaClass.getName());
            }
        }
        return extension;
    }

    public Element caseGeneralization(Generalization generalization) {
        if (this.isReconnectable((Element)generalization)) {
            if (this.reconnectKind == 0) {
                generalization.setSpecific((Classifier)this.newPointedElement);
            } else {
                generalization.setGeneral((Classifier)this.newPointedElement);
            }
        }
        return generalization;
    }

    public Element caseInterfaceRealization(InterfaceRealization interfaceRealization) {
        if (this.isReconnectable((Element)interfaceRealization)) {
            if (this.reconnectKind == 0) {
                interfaceRealization.getClients().clear();
                ((Class)this.newPointedElement).getInterfaceRealizations().add((Object)interfaceRealization);
            } else {
                interfaceRealization.getSuppliers().clear();
                interfaceRealization.getSuppliers().add((Object)((Interface)this.newPointedElement));
            }
        }
        return interfaceRealization;
    }

    public Element casePackage(Package pkg) {
        if (1 == this.reconnectKind) {
            if (this.newPointedElement instanceof Package) {
                ((Package)this.newPointedElement).getPackagedElements().add((Object)pkg);
            } else if (this.newPointedElement instanceof Component) {
                ((Component)this.newPointedElement).getPackagedElements().add((Object)pkg);
            }
        } else if (this.newPointedElement instanceof PackageableElement) {
            EObject newParent = pkg.eContainer();
            if (newParent instanceof Package) {
                ((Package)newParent).getPackagedElements().add((Object)((PackageableElement)this.newPointedElement));
            } else if (newParent instanceof Component) {
                ((Component)newParent).getPackagedElements().add((Object)((PackageableElement)this.newPointedElement));
            }
            EObject root = EcoreUtil.getRootContainer((EObject)pkg);
            if (root instanceof Package) {
                ((Package)root).getPackagedElements().add((Object)pkg);
            }
        }
        return pkg;
    }

    public Element caseTemplateBinding(TemplateBinding tmplBinding) {
        if (this.isReconnectable((Element)tmplBinding)) {
            if (this.reconnectKind == 0) {
                TemplateableElement templateableElement = (TemplateableElement)this.newPointedElement;
                tmplBinding.setBoundElement(templateableElement);
            } else {
                TemplateableElement oldTmplElement = (TemplateableElement)this.oldPointedElement;
                TemplateableElement newTmplElement = (TemplateableElement)this.newPointedElement;
                TemplateSignature oldTemplate = oldTmplElement.getOwnedTemplateSignature();
                TemplateSignature newTemplate = newTmplElement.getOwnedTemplateSignature();
                if (newTemplate != null) {
                    EList newParams = newTemplate.getOwnedParameters();
                    EList oldParams = oldTemplate.getOwnedParameters();
                    tmplBinding.setSignature(newTemplate);
                    if (newParams.size() > oldParams.size()) {
                        this.handleHigherTmplParamCardinality(tmplBinding);
                    } else if (newParams.size() < oldParams.size()) {
                        this.handleLowerTmplParamCardinality(tmplBinding, oldTmplElement, newTmplElement);
                    } else {
                        this.handleSameTmplParamCardinality(tmplBinding);
                    }
                } else {
                    this.createANewTemplateSignature(tmplBinding, oldTmplElement, newTmplElement);
                }
            }
        }
        return tmplBinding;
    }

    private void createANewTemplateSignature(TemplateBinding tmplBinding, TemplateableElement oldTmplElement, TemplateableElement newTmplElement) {
        TemplateSignature templateSignature = newTmplElement.createOwnedTemplateSignature();
        tmplBinding.setSignature(templateSignature);
        EList oldParams = oldTmplElement.getOwnedTemplateSignature().getOwnedParameters();
        for (TemplateParameter templateParameter : oldParams) {
            ClassifierTemplateParameter newTemplateClassifier = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
            Class newGenericClass = UMLFactory.eINSTANCE.createClass();
            ParameterableElement ownedDefault = templateParameter.getOwnedDefault();
            if (ownedDefault instanceof NamedElement) {
                newGenericClass.setName(((NamedElement)ownedDefault).getName());
            }
            newTemplateClassifier.setOwnedDefault((ParameterableElement)newGenericClass);
            newTemplateClassifier.setParameteredElement((ParameterableElement)newGenericClass);
            templateSignature.getOwnedParameters().add((Object)newTemplateClassifier);
        }
        this.handleSameTmplParamCardinality(tmplBinding);
    }

    private void handleHigherTmplParamCardinality(TemplateBinding tmplBinding) {
        TemplateSignature newTmplSignature = tmplBinding.getSignature();
        EList paramSubs = tmplBinding.getParameterSubstitutions();
        int i = 0;
        while (i < newTmplSignature.getOwnedParameters().size()) {
            TemplateParameterSubstitution tmplParamSub = i < paramSubs.size() ? (TemplateParameterSubstitution)paramSubs.get(i) : tmplBinding.createParameterSubstitution();
            tmplParamSub.setFormal((TemplateParameter)newTmplSignature.getOwnedParameters().get(i));
            ++i;
        }
    }

    private void handleLowerTmplParamCardinality(TemplateBinding tmplBinding, TemplateableElement oldTmplElement, TemplateableElement newTmplElement) {
        TemplateSignature oldTemplate = oldTmplElement.getOwnedTemplateSignature();
        TemplateSignature newTemplate = newTmplElement.getOwnedTemplateSignature();
        EList newParams = newTemplate.getOwnedParameters();
        EList oldParams = oldTemplate.getOwnedParameters();
        int i = newParams.size();
        while (i < oldParams.size()) {
            ClassifierTemplateParameter newTemplateClassifier = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
            Class newGenericClass = UMLFactory.eINSTANCE.createClass();
            ParameterableElement ownedDefault = ((TemplateParameter)oldParams.get(i)).getOwnedDefault();
            if (ownedDefault instanceof NamedElement) {
                newGenericClass.setName(((NamedElement)ownedDefault).getName());
            }
            newTemplateClassifier.setOwnedDefault((ParameterableElement)newGenericClass);
            newTemplateClassifier.setParameteredElement((ParameterableElement)newGenericClass);
            newParams.add(newTemplateClassifier);
            ++i;
        }
        EList paramSubs = tmplBinding.getParameterSubstitutions();
        int i2 = 0;
        while (i2 < newParams.size()) {
            TemplateParameterSubstitution tmplParamSub = (TemplateParameterSubstitution)paramSubs.get(i2);
            tmplParamSub.setFormal((TemplateParameter)newParams.get(i2));
            ++i2;
        }
    }

    private void handleSameTmplParamCardinality(TemplateBinding tmplBinding) {
        TemplateSignature newTmplSignature = tmplBinding.getSignature();
        EList parameterSubstitutions = tmplBinding.getParameterSubstitutions();
        int i = 0;
        for (TemplateParameterSubstitution templateParameterSubstitution : parameterSubstitutions) {
            if (i >= newTmplSignature.getOwnedParameters().size()) {
                LogServices.INSTANCE.error("ReconnectSwitch.caseTemplateBinding(" + tmplBinding.getClass() + ") dirty TemplateBinding model.", null);
                break;
            }
            templateParameterSubstitution.setFormal((TemplateParameter)newTmplSignature.getOwnedParameters().get(i));
            ++i;
        }
    }

    private boolean isReconnectable(Element element) {
        ReconnectPreconditionSwitch reconnectPreconditionService = new ReconnectPreconditionSwitch();
        reconnectPreconditionService.setReconnectKind(this.reconnectKind);
        reconnectPreconditionService.setNewPointedElement(this.newPointedElement);
        reconnectPreconditionService.setOldPointedElement(this.oldPointedElement);
        return reconnectPreconditionService.isReconnectable(element);
    }

    public void setNewPointedElement(Element newPointedElement) {
        this.newPointedElement = newPointedElement;
    }

    public void setOldPointedElement(Element oldPointedElement) {
        this.oldPointedElement = oldPointedElement;
    }

    public void setReconnectKind(int reconnectKind) {
        this.reconnectKind = reconnectKind;
    }
}

