/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.ExecutionEnvironment;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedElementsSwitch
extends UMLSwitch<List<EObject>> {
    private Set<EObject> relateds;
    private Collection<EStructuralFeature.Setting> xRefs;
    private ECrossReferenceAdapter referencer;

    public RelatedElementsSwitch() {
    }

    public RelatedElementsSwitch(ECrossReferenceAdapter xRef) {
        this.referencer = xRef;
    }

    public List<EObject> caseArtifact(Artifact object) {
        return (List)super.caseArtifact(object);
    }

    public List<EObject> caseClassifier(Classifier object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (xRef.getEObject() instanceof Generalization) {
                this.relateds.add((EObject)((Generalization)xRef.getEObject()).getGeneral());
            }
            if (xRef.getEObject() instanceof InterfaceRealization) {
                this.relateds.add((EObject)((InterfaceRealization)xRef.getEObject()).getContract());
            }
            if (xRef.getEObject() instanceof Feature) {
                this.relateds.addAll((Collection<EObject>)((Feature)xRef.getEObject()).getFeaturingClassifiers());
            }
            if (!(xRef.getEObject() instanceof UseCase)) continue;
            this.relateds.add(xRef.getEObject());
        }
        this.relateds.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)object.getOwnedElements(), Classifier.class)));
        this.relateds.addAll((Collection<EObject>)object.getFeatures());
        return (List)super.caseClassifier(object);
    }

    public List<EObject> caseConnectableElement(ConnectableElement object) {
        for (ConnectorEnd end : object.getEnds()) {
            EObject connector = end.eContainer();
            if (connector == null || !(connector instanceof Connector) || this.relateds.contains(connector)) continue;
            this.relateds.add(connector);
            this.caseConnector((Connector)connector);
        }
        return (List)super.caseConnectableElement(object);
    }

    public List<EObject> caseConnector(Connector object) {
        EList ends = object.getEnds();
        for (ConnectorEnd end : ends) {
            ConnectableElement role = end.getRole();
            if (role == null || this.relateds.contains(role)) continue;
            this.relateds.add((EObject)role);
            if (!(role instanceof Port)) continue;
            this.casePort((Port)role);
        }
        return (List)super.caseConnector(object);
    }

    public List<EObject> caseEncapsulatedClassifier(EncapsulatedClassifier object) {
        for (Port port : object.getOwnedPorts()) {
            if (this.relateds.contains(port)) continue;
            this.relateds.add((EObject)port);
            this.casePort(port);
            this.caseConnectableElement((ConnectableElement)port);
        }
        return (List)super.caseEncapsulatedClassifier(object);
    }

    public List<EObject> caseExecutionEnvironment(ExecutionEnvironment object) {
        for (Deployment depl : object.getDeployments()) {
            this.relateds.addAll((Collection<EObject>)depl.getDeployedArtifacts());
        }
        return (List)super.caseExecutionEnvironment(object);
    }

    public List<EObject> caseFeature(Feature object) {
        this.relateds.addAll(new RelatedElementsSwitch().getRelatedElements(object.eContainer()));
        return (List)super.caseFeature(object);
    }

    public List<EObject> caseInterface(Interface object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (!(xRef.getEObject() instanceof InterfaceRealization)) continue;
            this.relateds.add((EObject)((InterfaceRealization)xRef.getEObject()).getImplementingClassifier());
        }
        return (List)super.caseInterface(object);
    }

    public List<EObject> caseNamedElement(NamedElement object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (!(xRef.getEObject() instanceof Relationship)) continue;
            this.relateds.addAll((Collection<EObject>)((Relationship)xRef.getEObject()).getRelatedElements());
        }
        this.relateds.add((EObject)object.getModel());
        return (List)super.caseNamedElement(object);
    }

    public List<EObject> caseOperation(Operation object) {
        for (Parameter param : object.getOwnedParameters()) {
            this.relateds.add((EObject)param.getType());
        }
        return (List)super.caseOperation(object);
    }

    public List<EObject> casePackage(Package object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (xRef.getEObject() instanceof PackageImport) {
                this.relateds.add((EObject)((PackageImport)xRef.getEObject()).getImportedPackage());
            }
            if (!(xRef.getEObject() instanceof PackageMerge)) continue;
            this.relateds.add((EObject)((PackageMerge)xRef.getEObject()).getMergedPackage());
        }
        this.relateds.addAll((Collection<EObject>)object.getOwnedElements());
        return (List)super.casePackage(object);
    }

    public List<EObject> casePackageableElement(PackageableElement object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (xRef.getEObject() instanceof InterfaceRealization) {
                this.relateds.add((EObject)((InterfaceRealization)xRef.getEObject()).getContract());
            }
            if (!(xRef.getEObject() instanceof Feature)) continue;
            this.relateds.addAll((Collection<EObject>)((Feature)xRef.getEObject()).getFeaturingClassifiers());
        }
        return (List)super.casePackageableElement(object);
    }

    public List<EObject> casePort(Port object) {
        this.relateds.addAll((Collection<EObject>)object.getRedefinedPorts());
        this.relateds.add(object.eContainer());
        return (List)super.casePort(object);
    }

    public List<EObject> caseType(Type object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (!(xRef.getEObject() instanceof Property) || ((Property)xRef.getEObject()).getAssociation() == null) continue;
            for (Property pro : ((Property)xRef.getEObject()).getAssociation().getMemberEnds()) {
                this.relateds.add((EObject)pro);
                this.relateds.add((EObject)pro.getType());
            }
        }
        this.relateds.add((EObject)object.getPackage());
        return (List)super.caseType(object);
    }

    public List<EObject> caseUseCase(UseCase object) {
        for (EStructuralFeature.Setting xRef : this.xRefs) {
            if (xRef.getEObject() instanceof Extend) {
                this.relateds.add((EObject)((Extend)xRef.getEObject()).getExtendedCase());
                this.relateds.add((EObject)((Extend)xRef.getEObject()).getExtension());
            }
            if (!(xRef.getEObject() instanceof Include)) continue;
            this.relateds.add((EObject)((Include)xRef.getEObject()).getAddition());
            this.relateds.add((EObject)((Include)xRef.getEObject()).getIncludingCase());
        }
        return (List)super.caseUseCase(object);
    }

    private void clearAssociationsFromResult() {
        this.relateds = Sets.newLinkedHashSet((Iterable)Iterables.filter(this.relateds, (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return !(input instanceof Association);
            }
        }));
    }

    public List<EObject> getRelatedElements(EObject ctx) {
        Session sess = SessionManager.INSTANCE.getSession(ctx);
        this.relateds = Sets.newLinkedHashSet();
        if (sess != null) {
            this.xRefs = sess.getSemanticCrossReferencer().getInverseReferences(ctx);
        } else if (this.referencer != null) {
            this.xRefs = this.referencer.getInverseReferences(ctx);
        }
        this.doSwitch(ctx);
        this.relateds.remove(ctx);
        this.relateds.remove(null);
        if (ctx instanceof Actor || ctx instanceof UseCase) {
            this.clearAssociationsFromResult();
        }
        return ImmutableList.copyOf(this.relateds);
    }
}

