/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceServices {
    public final String EXECUTION_END_SUFFIX = "_finish";
    public final String SIGNAL_SUFFIX = "_signal";
    public final String SENDER_MESSAGE_SUFFIX = "_sender";
    public final String RECEIVER_MESSAGE_SUFFIX = "_receiver";

    private boolean combinedFragmentStartPredecessorChanged(CombinedFragment combinedFragment, InteractionFragment startingEndPredecessorAfter) {
        Interaction interaction = combinedFragment.getEnclosingInteraction();
        EList fragments = interaction.getFragments();
        InteractionFragment initialPredecessor = (InteractionFragment)fragments.get(fragments.indexOf((Object)combinedFragment) - 1);
        return !initialPredecessor.equals(startingEndPredecessorAfter);
    }

    public Message createAsynchronousMessage(Interaction interaction, boolean createOperation, NamedElement sourceFragment, NamedElement targetFragment, Operation operation) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        Message message = factory.createMessage();
        Lifeline source = this.getLifeline((Element)sourceFragment);
        Lifeline target = this.getLifeline((Element)targetFragment);
        String messageName = "";
        messageName = operation == null ? "Message_" + Integer.toString(interaction.getMessages().size()) : operation.getName();
        message.setName(messageName);
        message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        MessageOccurrenceSpecification senderEventMessage = factory.createMessageOccurrenceSpecification();
        senderEventMessage.setName(String.valueOf(message.getName()) + "_sender");
        senderEventMessage.getCovereds().add((Object)source);
        senderEventMessage.setMessage(message);
        MessageOccurrenceSpecification receiverEventMessage = factory.createMessageOccurrenceSpecification();
        receiverEventMessage.setName(String.valueOf(message.getName()) + "_receiver");
        receiverEventMessage.getCovereds().add((Object)target);
        receiverEventMessage.setMessage(message);
        message.setSendEvent((MessageEnd)senderEventMessage);
        message.setReceiveEvent((MessageEnd)receiverEventMessage);
        return message;
    }

    public void createAsynchronousMessage(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, boolean createExecution, Element startingEndPredecessor, Element finishingEndPredecessor, Operation operation) {
        Lifeline target = this.getLifeline((Element)targetFragment);
        BehaviorExecutionSpecification predecessorExecution = this.getExecution((InteractionFragment)startingEndPredecessor);
        UMLFactory factory = UMLFactory.eINSTANCE;
        EList fragments = interaction.getFragments();
        Message message = this.createAsynchronousMessage(interaction, createExecution, sourceFragment, targetFragment, operation);
        if (operation != null) {
            message.setSignature((NamedElement)operation);
        }
        interaction.getMessages().add((Object)message);
        BehaviorExecutionSpecification execution = null;
        if (createExecution) {
            execution = this.createExecution(target, message);
            interaction.getOwnedBehaviors().add((Object)execution.getBehavior());
        } else {
            Signal signal = factory.createSignal();
            signal.setName(String.valueOf(message.getName()) + "_signal");
            message.getNearestPackage().getPackagedElements().add((Object)signal);
        }
        MessageOccurrenceSpecification senderEventMessage = (MessageOccurrenceSpecification)message.getSendEvent();
        MessageOccurrenceSpecification receiverEventMessage = (MessageOccurrenceSpecification)message.getReceiveEvent();
        ExecutionOccurrenceSpecification endExec = null;
        if (execution != null) {
            execution.setStart((OccurrenceSpecification)receiverEventMessage);
            endExec = factory.createExecutionOccurrenceSpecification();
            endExec.setName(String.valueOf(execution.getName()) + "_finish");
            endExec.getCovereds().add((Object)target);
            endExec.setExecution((ExecutionSpecification)execution);
            execution.setFinish((OccurrenceSpecification)endExec);
        }
        if (startingEndPredecessor != null && startingEndPredecessor instanceof OccurrenceSpecification && predecessorExecution != null && startingEndPredecessor.equals(predecessorExecution.getStart())) {
            fragments.add(fragments.indexOf((Object)predecessorExecution) + 1, (Object)senderEventMessage);
        } else {
            fragments.add(fragments.indexOf((Object)startingEndPredecessor) + 1, (Object)senderEventMessage);
        }
        fragments.add((Object)receiverEventMessage);
        fragments.move(fragments.indexOf((Object)senderEventMessage) + 1, (Object)receiverEventMessage);
        if (execution != null) {
            fragments.add((Object)execution);
            fragments.add((Object)endExec);
            fragments.move(fragments.indexOf((Object)receiverEventMessage) + 1, (Object)execution);
            fragments.move(fragments.indexOf((Object)execution) + 1, (Object)endExec);
        }
    }

    public void createExecution(Interaction interaction, NamedElement fragment, NamedElement startingEndPredecessor) {
        this.createExecution(interaction, fragment, null, startingEndPredecessor);
    }

    public void createExecution(Interaction interaction, NamedElement fragment, Operation operation, NamedElement startingEndPredecessor) {
        StringBuffer executionName;
        Lifeline lifeline = this.getLifeline((Element)fragment);
        UMLFactory factory = UMLFactory.eINSTANCE;
        if (operation == null) {
            ArrayList<BehaviorExecutionSpecification> behaviors = new ArrayList<BehaviorExecutionSpecification>();
            for (InteractionFragment behavior : interaction.getFragments()) {
                if (!(behavior instanceof BehaviorExecutionSpecification)) continue;
                behaviors.add((BehaviorExecutionSpecification)behavior);
            }
            executionName = new StringBuffer("BehaviorExecution_").append(behaviors.size());
        } else {
            executionName = new StringBuffer(operation.getName());
        }
        ExecutionOccurrenceSpecification startExec = factory.createExecutionOccurrenceSpecification();
        StringBuffer startExecName = new StringBuffer(executionName).append("_start");
        startExec.setName(startExecName.toString());
        startExec.getCovereds().add((Object)lifeline);
        OpaqueBehavior behavior = factory.createOpaqueBehavior();
        behavior.setName(executionName.toString());
        behavior.setSpecification((BehavioralFeature)operation);
        interaction.getOwnedBehaviors().add((Object)behavior);
        BehaviorExecutionSpecification execution = factory.createBehaviorExecutionSpecification();
        execution.setName(executionName.toString());
        execution.getCovereds().add((Object)lifeline);
        execution.setBehavior((Behavior)behavior);
        execution.setStart((OccurrenceSpecification)startExec);
        startExec.setExecution((ExecutionSpecification)execution);
        ExecutionOccurrenceSpecification endExec = factory.createExecutionOccurrenceSpecification();
        StringBuffer endExecName = new StringBuffer(executionName).append("_finish");
        endExec.setName(endExecName.toString());
        endExec.getCovereds().add((Object)lifeline);
        endExec.setExecution((ExecutionSpecification)execution);
        execution.setFinish((OccurrenceSpecification)endExec);
        EList fragments = interaction.getFragments();
        fragments.add((Object)startExec);
        if (startingEndPredecessor instanceof OccurrenceSpecification && this.getExecution((InteractionFragment)((OccurrenceSpecification)startingEndPredecessor)) != null && startingEndPredecessor.equals(this.getExecution((InteractionFragment)((OccurrenceSpecification)startingEndPredecessor)).getStart())) {
            fragments.move(fragments.indexOf((Object)startingEndPredecessor) + 2, (Object)startExec);
        } else {
            fragments.move(fragments.indexOf((Object)startingEndPredecessor) + 1, (Object)startExec);
        }
        fragments.add((Object)execution);
        fragments.move(fragments.indexOf((Object)startExec) + 1, (Object)execution);
        fragments.add((Object)endExec);
        fragments.move(fragments.indexOf((Object)execution) + 1, (Object)endExec);
    }

    public BehaviorExecutionSpecification createExecution(Lifeline covered, Message message) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        OpaqueBehavior behavior = factory.createOpaqueBehavior();
        behavior.setName(message.getName());
        BehaviorExecutionSpecification execution = factory.createBehaviorExecutionSpecification();
        execution.setName(message.getName());
        execution.getCovereds().add((Object)covered);
        execution.setBehavior((Behavior)behavior);
        return execution;
    }

    private Message createReplyMessage(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, Element startingEndPredecessor, Element finishingEndPredecessor, Message message) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        Lifeline source = this.getLifeline((Element)sourceFragment);
        Lifeline target = this.getLifeline((Element)targetFragment);
        Message replyMessage = factory.createMessage();
        replyMessage.setName(String.valueOf(message.getName()) + "_reply");
        replyMessage.setMessageSort(MessageSort.REPLY_LITERAL);
        interaction.getMessages().add((Object)replyMessage);
        MessageOccurrenceSpecification senderEventReplyMessage = factory.createMessageOccurrenceSpecification();
        senderEventReplyMessage.setName(String.valueOf(replyMessage.getName()) + "_sender");
        senderEventReplyMessage.getCovereds().add((Object)target);
        senderEventReplyMessage.setMessage(replyMessage);
        MessageOccurrenceSpecification receiverEventReplyMessage = factory.createMessageOccurrenceSpecification();
        receiverEventReplyMessage.setName(String.valueOf(replyMessage.getName()) + "_receiver");
        receiverEventReplyMessage.getCovereds().add((Object)source);
        receiverEventReplyMessage.setMessage(replyMessage);
        replyMessage.setSendEvent((MessageEnd)senderEventReplyMessage);
        replyMessage.setReceiveEvent((MessageEnd)receiverEventReplyMessage);
        return replyMessage;
    }

    public void createSynchronousMessage(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, boolean createExecution, Element startingEndPredecessor, Element finishingEndPredecessor, Operation operation) {
        Lifeline target = this.getLifeline((Element)targetFragment);
        BehaviorExecutionSpecification predecessorExecution = this.getExecution((InteractionFragment)startingEndPredecessor);
        UMLFactory factory = UMLFactory.eINSTANCE;
        EList fragments = interaction.getFragments();
        Message message = this.createSynchronousMessage(interaction, sourceFragment, targetFragment, startingEndPredecessor, finishingEndPredecessor, operation);
        interaction.getMessages().add((Object)message);
        if (operation != null) {
            message.setSignature((NamedElement)operation);
        }
        BehaviorExecutionSpecification execution = null;
        if (createExecution) {
            execution = this.createExecution(target, message);
            interaction.getOwnedBehaviors().add((Object)execution.getBehavior());
        } else {
            Signal signal = factory.createSignal();
            signal.setName(String.valueOf(message.getName()) + "_signal");
            message.getNearestPackage().getPackagedElements().add((Object)signal);
        }
        if (execution != null) {
            execution.setStart((OccurrenceSpecification)((MessageOccurrenceSpecification)message.getReceiveEvent()));
        }
        Message replyMessage = this.createReplyMessage(interaction, sourceFragment, targetFragment, startingEndPredecessor, finishingEndPredecessor, message);
        interaction.getMessages().add((Object)replyMessage);
        if (execution != null) {
            execution.setFinish((OccurrenceSpecification)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
        }
        if (startingEndPredecessor != null && startingEndPredecessor instanceof OccurrenceSpecification && predecessorExecution != null && startingEndPredecessor.equals(predecessorExecution.getStart())) {
            fragments.add(fragments.indexOf((Object)predecessorExecution) + 1, (Object)((MessageOccurrenceSpecification)message.getSendEvent()));
        } else {
            fragments.add(fragments.indexOf((Object)startingEndPredecessor) + 1, (Object)((MessageOccurrenceSpecification)message.getSendEvent()));
        }
        fragments.add(fragments.indexOf((Object)message.getSendEvent()) + 1, (Object)((MessageOccurrenceSpecification)message.getReceiveEvent()));
        fragments.add((Object)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
        if (execution != null) {
            fragments.add(fragments.indexOf((Object)message.getReceiveEvent()) + 1, (Object)execution);
            fragments.move(fragments.indexOf((Object)execution) + 1, (Object)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
        } else {
            fragments.move(fragments.indexOf((Object)message.getReceiveEvent()) + 1, (Object)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
        }
        fragments.add(fragments.indexOf((Object)replyMessage.getSendEvent()) + 1, (Object)((MessageOccurrenceSpecification)replyMessage.getReceiveEvent()));
    }

    private Message createSynchronousMessage(Interaction interaction, NamedElement sourceFragment, NamedElement targetFragment, Element startingEndPredecessor, Element finishingEndPredecessor, Operation operation) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        Lifeline source = this.getLifeline((Element)sourceFragment);
        Lifeline target = this.getLifeline((Element)targetFragment);
        String messageName = "";
        messageName = operation == null ? "Message_" + interaction.getMessages().size() : operation.getName();
        Message message = factory.createMessage();
        message.setName(messageName);
        message.setMessageSort(MessageSort.SYNCH_CALL_LITERAL);
        MessageOccurrenceSpecification senderEventMessage = factory.createMessageOccurrenceSpecification();
        senderEventMessage.setName(String.valueOf(message.getName()) + "_sender");
        senderEventMessage.getCovereds().add((Object)source);
        senderEventMessage.setMessage(message);
        MessageOccurrenceSpecification receiverEventMessage = factory.createMessageOccurrenceSpecification();
        receiverEventMessage.setName(String.valueOf(message.getName()) + "_receiver");
        receiverEventMessage.getCovereds().add((Object)target);
        receiverEventMessage.setMessage(message);
        message.setSendEvent((MessageEnd)senderEventMessage);
        message.setReceiveEvent((MessageEnd)receiverEventMessage);
        return message;
    }

    private boolean executionFinishPredecessorChanged(ExecutionSpecification execution, InteractionFragment finishingEndPredecessorAfter) {
        Interaction interaction = execution.getEnclosingInteraction();
        EList fragments = interaction.getFragments();
        InteractionFragment initialPredecessor = (InteractionFragment)fragments.get(fragments.indexOf((Object)execution.getFinish()) - 1);
        return !initialPredecessor.equals(finishingEndPredecessorAfter);
    }

    private boolean executionStartPredecessorChanged(ExecutionSpecification execution, InteractionFragment startingEndPredecessorAfter) {
        Interaction interaction = execution.getEnclosingInteraction();
        EList fragments = interaction.getFragments();
        InteractionFragment initialPredecessor = (InteractionFragment)fragments.get(fragments.indexOf((Object)execution.getStart()) - 1);
        return !initialPredecessor.equals(startingEndPredecessorAfter);
    }

    public NamedElement findOccurrenceSpecificationContext(OccurrenceSpecification occurrenceSpecification) {
        Lifeline lifeline = (Lifeline)occurrenceSpecification.getCovereds().get(0);
        Stack<Object> context = new Stack<Object>();
        context.add(lifeline);
        Interaction enclosingInteraction = this.getEnclosingInteraction((Element)occurrenceSpecification);
        EList allFragments = enclosingInteraction.getFragments();
        ArrayList<InteractionFragment> fragments = new ArrayList<InteractionFragment>();
        for (InteractionFragment fragment : allFragments) {
            if (fragment.getCovered(lifeline.getName()) == null) continue;
            fragments.add(fragment);
        }
        int i = 0;
        while (i < fragments.size()) {
            InteractionFragment e = (InteractionFragment)fragments.get(i);
            InteractionFragment en = i + 1 < fragments.size() ? (InteractionFragment)fragments.get(i + 1) : null;
            if (e instanceof MessageOccurrenceSpecification && en != null && en instanceof ExecutionSpecification) {
                context.add(en);
            }
            if (e instanceof ExecutionOccurrenceSpecification && (en == null || !(en instanceof ExecutionSpecification))) {
                context.pop();
            }
            if (e == occurrenceSpecification) {
                return (NamedElement)context.peek();
            }
            if (e instanceof ExecutionOccurrenceSpecification && en != null && en instanceof ExecutionSpecification) {
                context.add((NamedElement)fragments.get(i + 1));
            }
            if (e instanceof MessageOccurrenceSpecification && this.isEnd(e, fragments)) {
                context.pop();
            }
            ++i;
        }
        return lifeline;
    }

    public Interaction getEnclosingInteraction(Element occurrenceSpecification) {
        Interaction result = null;
        EObject container = occurrenceSpecification.eContainer();
        while (!(container instanceof Interaction)) {
            container = container.eContainer();
        }
        if (container instanceof Interaction) {
            result = (Interaction)container;
            return result;
        }
        return result;
    }

    public BehaviorExecutionSpecification getExecution(InteractionFragment occurence) {
        if (occurence == null) {
            return null;
        }
        HashMap<OccurrenceSpecification, BehaviorExecutionSpecification> behaviors = new HashMap<OccurrenceSpecification, BehaviorExecutionSpecification>();
        Interaction interaction = this.getEnclosingInteraction((Element)occurence);
        for (InteractionFragment fragment : interaction.getFragments()) {
            if (!(fragment instanceof BehaviorExecutionSpecification)) continue;
            BehaviorExecutionSpecification behavior = (BehaviorExecutionSpecification)fragment;
            behaviors.put(behavior.getStart(), behavior);
            behaviors.put(behavior.getFinish(), behavior);
        }
        return (BehaviorExecutionSpecification)behaviors.get(occurence);
    }

    private BehaviorExecutionSpecification getExecution(Message message) {
        if (message == null) {
            return null;
        }
        HashMap<Message, BehaviorExecutionSpecification> behaviors = new HashMap<Message, BehaviorExecutionSpecification>();
        for (InteractionFragment fragment : message.getInteraction().getFragments()) {
            BehaviorExecutionSpecification behavior;
            OccurrenceSpecification behaviorStart;
            if (!(fragment instanceof BehaviorExecutionSpecification) || !((behaviorStart = (behavior = (BehaviorExecutionSpecification)fragment).getStart()) instanceof MessageOccurrenceSpecification) || !message.equals(((MessageOccurrenceSpecification)behaviorStart).getMessage())) continue;
            behaviors.put(message, behavior);
        }
        return (BehaviorExecutionSpecification)behaviors.get(message);
    }

    private int getFragmentIndex(InteractionFragment fragment, EList<InteractionFragment> fragments) {
        if (fragment != null) {
            return fragments.indexOf((Object)fragment);
        }
        return 0;
    }

    public Lifeline getLifeline(Element fragment) {
        EList lifelines;
        if (fragment instanceof Lifeline) {
            return (Lifeline)fragment;
        }
        if (fragment instanceof ExecutionSpecification && (lifelines = ((ExecutionSpecification)fragment).getCovereds()) != null && !lifelines.isEmpty()) {
            return (Lifeline)lifelines.get(0);
        }
        return null;
    }

    public Message getReplyMessage(Message message) {
        OccurrenceSpecification end;
        BehaviorExecutionSpecification execution = this.getExecution(message);
        if (execution != null && (end = execution.getFinish()) instanceof MessageOccurrenceSpecification) {
            return ((MessageOccurrenceSpecification)end).getMessage();
        }
        for (Message messageReply : message.getInteraction().getMessages()) {
            if (!MessageSort.REPLY_LITERAL.equals((Object)messageReply.getMessageSort()) || !messageReply.getName().startsWith(message.getName())) continue;
            return messageReply;
        }
        return null;
    }

    public boolean isCoveredTypeSet(ExecutionSpecification element) {
        if (element == null) {
            return false;
        }
        for (Lifeline covered : element.getCovereds()) {
            ConnectableElement connectedElement = covered.getRepresents();
            if (connectedElement.getTemplateParameter() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isEnd(InteractionFragment endCandidate, List<InteractionFragment> fragments) {
        ArrayList<OccurrenceSpecification> executionFinishes = new ArrayList<OccurrenceSpecification>();
        for (InteractionFragment fragment : fragments) {
            if (!(fragment instanceof BehaviorExecutionSpecification)) continue;
            BehaviorExecutionSpecification behavior = (BehaviorExecutionSpecification)fragment;
            executionFinishes.add(behavior.getFinish());
        }
        return executionFinishes.contains(endCandidate);
    }

    private boolean isMoveAuthorized(Message message) {
        return !message.getMessageSort().equals((Object)MessageSort.REPLY_LITERAL);
    }

    private boolean isStartOfExecution(InteractionFragment startingEndPredecessorAfter, EList<InteractionFragment> fragments) {
        BehaviorExecutionSpecification behaviorExecution;
        InteractionFragment candidate;
        ExecutionOccurrenceSpecification executionStart;
        if (startingEndPredecessorAfter instanceof ExecutionOccurrenceSpecification && (executionStart = (ExecutionOccurrenceSpecification)startingEndPredecessorAfter).getExecution().getStart().equals(executionStart)) {
            return true;
        }
        return startingEndPredecessorAfter instanceof MessageOccurrenceSpecification && fragments.indexOf((Object)startingEndPredecessorAfter) + 1 < fragments.size() && (candidate = (InteractionFragment)fragments.get(fragments.indexOf((Object)startingEndPredecessorAfter) + 1)) instanceof BehaviorExecutionSpecification && (behaviorExecution = (BehaviorExecutionSpecification)candidate).getStart().equals(startingEndPredecessorAfter);
    }

    private boolean messageStartPredecessorChanged(Message message, InteractionFragment startingEndPredecessorAfter) {
        Interaction interaction = message.getInteraction();
        EList fragments = interaction.getFragments();
        InteractionFragment initialPredecessor = (InteractionFragment)fragments.get(fragments.indexOf((Object)message.getSendEvent()) - 1);
        return !initialPredecessor.equals(startingEndPredecessorAfter);
    }

    public void reorder(CombinedFragment combinedFragment, InteractionFragment startingEndPredecessorAfter, InteractionFragment finishingEndPredecessorAfter) {
        Interaction interaction = combinedFragment.getEnclosingInteraction();
        EList fragments = interaction.getFragments();
        boolean combinedFragmentStartPredecessorChanged = this.combinedFragmentStartPredecessorChanged(combinedFragment, startingEndPredecessorAfter);
        if (combinedFragmentStartPredecessorChanged) {
            fragments.remove((Object)combinedFragment);
            if (this.isStartOfExecution(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments)) {
                fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 2, (Object)combinedFragment);
            } else {
                fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 1, (Object)combinedFragment);
            }
        }
    }

    public void reorder(ExecutionSpecification execution, InteractionFragment startingEndPredecessorAfter, InteractionFragment finishingEndPredecessorAfter) {
        Interaction interaction = execution.getEnclosingInteraction();
        EList fragments = interaction.getFragments();
        boolean executionFinishPredecessorChanged = this.executionFinishPredecessorChanged(execution, finishingEndPredecessorAfter);
        boolean executionStartPredecessorChanged = this.executionStartPredecessorChanged(execution, startingEndPredecessorAfter);
        if (executionStartPredecessorChanged) {
            fragments.remove((Object)execution.getStart());
            fragments.remove((Object)execution);
            if (this.isStartOfExecution(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments)) {
                fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 2, (Object)execution.getStart());
            } else {
                fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 1, (Object)execution.getStart());
            }
            fragments.add(this.getFragmentIndex((InteractionFragment)execution.getStart(), (EList<InteractionFragment>)fragments) + 1, (Object)execution);
        }
        if (executionFinishPredecessorChanged) {
            fragments.remove((Object)execution.getFinish());
            if (this.isStartOfExecution(finishingEndPredecessorAfter, (EList<InteractionFragment>)fragments)) {
                fragments.add(this.getFragmentIndex(finishingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 2, (Object)execution.getFinish());
            } else {
                fragments.add(this.getFragmentIndex(finishingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 1, (Object)execution.getFinish());
            }
        }
    }

    public void reorder(Message message, InteractionFragment startingEndPredecessorAfter, InteractionFragment finishingEndPredecessorAfter) {
        if (this.isMoveAuthorized(message)) {
            Interaction interaction = message.getInteraction();
            EList fragments = interaction.getFragments();
            boolean messageStartPredecessorChanged = this.messageStartPredecessorChanged(message, startingEndPredecessorAfter);
            if (messageStartPredecessorChanged) {
                fragments.remove((Object)message.getSendEvent());
                fragments.remove((Object)message.getReceiveEvent());
                if (this.isStartOfExecution(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments)) {
                    fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 2, (Object)((MessageOccurrenceSpecification)message.getSendEvent()));
                } else {
                    fragments.add(this.getFragmentIndex(startingEndPredecessorAfter, (EList<InteractionFragment>)fragments) + 1, (Object)((MessageOccurrenceSpecification)message.getSendEvent()));
                }
                fragments.add(this.getFragmentIndex((InteractionFragment)((MessageOccurrenceSpecification)message.getSendEvent()), (EList<InteractionFragment>)fragments) + 1, (Object)((MessageOccurrenceSpecification)message.getReceiveEvent()));
            }
            if (message.getMessageSort().equals((Object)MessageSort.SYNCH_CALL_LITERAL)) {
                Message replyMessage = this.getReplyMessage(message);
                fragments.remove((Object)replyMessage.getSendEvent());
                fragments.remove((Object)replyMessage.getReceiveEvent());
                if (this.isStartOfExecution((InteractionFragment)((MessageOccurrenceSpecification)message.getReceiveEvent()), (EList<InteractionFragment>)fragments)) {
                    fragments.add(this.getFragmentIndex((InteractionFragment)((MessageOccurrenceSpecification)message.getReceiveEvent()), (EList<InteractionFragment>)fragments) + 2, (Object)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
                } else {
                    fragments.add(this.getFragmentIndex((InteractionFragment)((MessageOccurrenceSpecification)message.getReceiveEvent()), (EList<InteractionFragment>)fragments) + 1, (Object)((MessageOccurrenceSpecification)replyMessage.getSendEvent()));
                }
                fragments.add(this.getFragmentIndex((InteractionFragment)((MessageOccurrenceSpecification)replyMessage.getSendEvent()), (EList<InteractionFragment>)fragments) + 1, (Object)((MessageOccurrenceSpecification)replyMessage.getReceiveEvent()));
            }
        }
    }
}

