/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeServices {
    public static final StereotypeServices INSTANCE = new StereotypeServices();

    public Element applyAllStereotypes(Element element, List<Stereotype> stereotypesToApply) {
        Session session = SessionManager.INSTANCE.getSession((EObject)element);
        EList alreadyAppliedStereotypes = element.getAppliedStereotypes();
        for (Stereotype alreadyAppliedStereotype : alreadyAppliedStereotypes) {
            if (stereotypesToApply != null && stereotypesToApply.contains(alreadyAppliedStereotype)) continue;
            element.unapplyStereotype(alreadyAppliedStereotype);
            this.unapplyProfile(element, alreadyAppliedStereotype);
        }
        if (stereotypesToApply == null) {
            return element;
        }
        for (Stereotype stereotypeToApply : stereotypesToApply) {
            Profile profile = stereotypeToApply.getProfile();
            Package pkg = element.getNearestPackage();
            if (!pkg.isProfileApplied(profile)) {
                pkg.applyProfile(profile);
                for (ProfileApplication profileApplication : profile.getAllProfileApplications()) {
                    LinkedHashSet descriptorsForInterpreter = Sets.newLinkedHashSet();
                    descriptorsForInterpreter.add(new EcoreMetamodelDescriptor(profileApplication.getAppliedDefinition()));
                    session.getInterpreter().activateMetamodels((Collection)descriptorsForInterpreter);
                }
            }
            if (element.isStereotypeApplied(stereotypeToApply)) continue;
            element.applyStereotype(stereotypeToApply);
        }
        return element;
    }

    public Element getBaseClass(EObject stereotypeApplication) {
        return (Element)stereotypeApplication.eGet(stereotypeApplication.eClass().getEStructuralFeature("base_Class"));
    }

    public void unapplyProfile(Element element, Stereotype alreadyAppliedStereotype) {
        Profile profile = alreadyAppliedStereotype.getProfile();
        Package pkg = element.getNearestPackage();
        ArrayList stereotypeApplications = Lists.newArrayList();
        UnmodifiableIterator it = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((EObject)pkg, (boolean)true), Element.class);
        while (it.hasNext()) {
            Element cur = (Element)it.next();
            stereotypeApplications.addAll(cur.getStereotypeApplications());
        }
        for (EObject stereotypeApplication : stereotypeApplications) {
            Element baseClass = this.getBaseClass(stereotypeApplication);
            for (Stereotype stereotype : baseClass.getAppliedStereotypes()) {
                if (!stereotype.getProfile().equals(profile)) continue;
                return;
            }
        }
        pkg.unapplyProfile(profile);
    }
}

