/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.uml2.uml.Profile;
import org.obeonetwork.dsl.uml2.design.internal.services.Version;

public class UMLDesignerProfileVersion {
    private final String UML_DESIGNER_PROFILE_VERSION_KEY = "Version";
    private final String UML_DESIGNER_PROFILE_DATE_KEY = "Date";
    private final String UML_DESIGNER_PROFILE_AUTHOR_KEY = "Author";
    private final String UML_DESIGNER_PROFILE_COPYRIGHT_KEY = "Copyright";
    private final String UML_DESIGNER_PROFILE_COMMENT_KEY = "Comment";
    private final String UML_DESIGNER_PROFILE_EANNOTATION_SOURCE = "UMLDesignerProfileVersion";
    private Version version;
    private String date;
    private String author;
    private String copyright;
    private String comment;

    public UMLDesignerProfileVersion() {
        this.version = new Version();
        this.date = "";
        this.author = "";
        this.copyright = "";
        this.comment = "";
    }

    public UMLDesignerProfileVersion(Version version, String date, String author, String copyRight, String comment) {
        this.version = version;
        this.date = date;
        this.author = author;
        this.copyright = copyRight;
        this.comment = comment;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDate() {
        return this.date;
    }

    public UMLDesignerProfileVersion getProfileVersion(Profile profile) {
        UMLDesignerProfileVersion uMLDesignerProfileVersion = null;
        EPackage profileDefinition = profile.getDefinition();
        if (profileDefinition != null && profileDefinition.getEAnnotation("UMLDesignerProfileVersion") != null) {
            EAnnotation profileEAnnotation = profileDefinition.getEAnnotation("UMLDesignerProfileVersion");
            uMLDesignerProfileVersion = this.parseEAnnotationVersion(profileEAnnotation);
        } else {
            uMLDesignerProfileVersion = new UMLDesignerProfileVersion();
        }
        return uMLDesignerProfileVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public EAnnotation initEAnnotationVersion(EAnnotation eAnnotation, UMLDesignerProfileVersion uMLDesignerProfileVersion) {
        eAnnotation.setSource("UMLDesignerProfileVersion");
        eAnnotation.getDetails().put((Object)"Version", (Object)uMLDesignerProfileVersion.getVersion().toString());
        eAnnotation.getDetails().put((Object)"Date", (Object)uMLDesignerProfileVersion.getDate());
        eAnnotation.getDetails().put((Object)"Author", (Object)uMLDesignerProfileVersion.getAuthor());
        eAnnotation.getDetails().put((Object)"Copyright", (Object)uMLDesignerProfileVersion.getCopyright());
        eAnnotation.getDetails().put((Object)"Comment", (Object)uMLDesignerProfileVersion.getComment());
        return eAnnotation;
    }

    private UMLDesignerProfileVersion parseEAnnotationVersion(EAnnotation profileEAnnotation) {
        Version versionFromAnnotation;
        String versionValue = (String)profileEAnnotation.getDetails().get((Object)"Version");
        try {
            versionFromAnnotation = Version.parseVersion(versionValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            versionFromAnnotation = Version.EMPTY_VERSION;
        }
        String dateFromAnnotation = (String)profileEAnnotation.getDetails().get((Object)"Date");
        String authorFromAnnotation = (String)profileEAnnotation.getDetails().get((Object)"Author");
        String copyRightFromAnnotation = (String)profileEAnnotation.getDetails().get((Object)"Copyright");
        String commentFromAnnotation = (String)profileEAnnotation.getDetails().get((Object)"Comment");
        UMLDesignerProfileVersion uMLDesignerProfileVersion = new UMLDesignerProfileVersion(versionFromAnnotation, dateFromAnnotation, authorFromAnnotation != null ? authorFromAnnotation : "", copyRightFromAnnotation != null ? copyRightFromAnnotation : "", commentFromAnnotation != null ? commentFromAnnotation : "");
        return uMLDesignerProfileVersion;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

