/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.editor.actions.DiagnosticAction;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmlToEcore
extends DiagnosticAction {
    protected static final String ECORE_FILE_EXTENSION = "ecore";

    protected Map<String, String> initAllOptionsToProcess() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("REDEFINING_OPERATIONS", "PROCESS");
        options.put("REDEFINING_PROPERTIES", "PROCESS");
        options.put("SUBSETTING_PROPERTIES", "PROCESS");
        options.put("UNION_PROPERTIES", "PROCESS");
        options.put("DERIVED_FEATURES", "PROCESS");
        options.put("DUPLICATE_OPERATIONS", "PROCESS");
        options.put("DUPLICATE_OPERATION_INHERITANCE", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        options.put("SUPER_CLASS_ORDER", "PROCESS");
        options.put("ANNOTATION_DETAILS", "PROCESS");
        options.put("INVARIANT_CONSTRAINTS", "PROCESS");
        options.put("OPERATION_BODIES", "PROCESS");
        options.put("COMMENTS", "PROCESS");
        options.put("CAMEL_CASE_NAMES", "IGNORE");
        return options;
    }

    public Resource umlToEcore(Package profile) {
        Map<String, String> options = this.initAllOptionsToProcess();
        Collection ecorePackages = UMLUtil.convertToEcore((Package)profile, options, null, null);
        Resource umlProfileResource = profile.eResource();
        ResourceSet resourceSet = umlProfileResource.getResourceSet();
        URI uri = resourceSet.getURIConverter().normalize(umlProfileResource.getURI()).trimFileExtension().trimSegments(1);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = null;
        for (EPackage ePackage : ecorePackages) {
            resource = resourceSet.createResource(uri.appendSegment(ePackage.getName()).appendFileExtension(ECORE_FILE_EXTENSION));
            resources.add(resource);
            resource.getContents().add((Object)ePackage);
        }
        for (Resource r : resources) {
            try {
                r.save(null);
            }
            catch (Exception e) {
                LogServices.INSTANCE.error("umlToEcore(" + profile.getClass() + ") not handled", e);
                e.printStackTrace();
            }
        }
        return (Resource)resources.get(0);
    }
}

