/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.services;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version {
    public static final Version EMPTY_VERSION = new Version(0, 0, 0);
    private static final String SEPARATOR = ".";
    private int micro;
    private int minor;
    private int major;

    public static Version parseVersion(String version) throws IllegalArgumentException {
        if (version == null) {
            return EMPTY_VERSION;
        }
        String trimmedVersion = version.trim();
        if (trimmedVersion.length() == 0) {
            return EMPTY_VERSION;
        }
        return new Version(trimmedVersion);
    }

    public Version() {
        new Version(0, 0, 0);
    }

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public Version(String value) throws IllegalArgumentException {
        try {
            StringTokenizer st = new StringTokenizer(value, SEPARATOR, true);
            this.major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                this.minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("invalid version format");
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("invalid version format");
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return String.valueOf(this.major) + SEPARATOR + this.minor + SEPARATOR + this.micro;
    }

    public void updateVersion(int majorPara, int minorPara, int microPara) {
        this.major = majorPara;
        this.minor = minorPara;
        this.micro = microPara;
    }
}

