/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.triggers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.uml2.uml.Element;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.CancelOperationException;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ConfirmDeletionDialog;
import org.obeonetwork.dsl.uml2.design.preferences.UmlDesignerPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmDeletionTrigger
extends DanglingRefRemovalTrigger {
    public static final int DELETION_CONFIRMATION_PRIORITY = 1;
    public static final NotificationFilter IS_IMPACTING = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return !notification.isTouch();
        }
    };
    private final UmlDesignerPreferences preferences = new UmlDesignerPreferences();

    public ConfirmDeletionTrigger(TransactionalEditingDomain domain, ModelAccessor accessor, ECrossReferenceAdapter xRef) {
        super(domain, accessor, xRef);
    }

    protected Map<EObject, Object> getDetachedEObjectsAndChildren(Iterable<Notification> notifications) {
        HashMap detachedEObjects = Maps.newHashMap();
        for (Notification notification : notifications) {
            if (!(notification.getNotifier() instanceof EObject)) continue;
            for (EObject root : this.getNotificationValues(notification)) {
                if (detachedEObjects.containsKey(root) || !(root instanceof Element)) continue;
                detachedEObjects.put(root, notification);
                TreeIterator iter = root.eAllContents();
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    detachedEObjects.put(eObject, eObject);
                }
            }
        }
        return detachedEObjects;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        ConfirmDeletionDialog dialog;
        if (!this.preferences.isDeletionConfirmationEnabled()) {
            return Options.newNone();
        }
        Map<EObject, Object> allDetachedObjects = this.getDetachedEObjectsAndChildren(Iterables.filter(notifications, (Predicate)IS_DETACHMENT));
        if (allDetachedObjects.size() > 0 && !(dialog = new ConfirmDeletionDialog(allDetachedObjects)).openConfirm()) {
            throw new CancelOperationException("Deletion operation canceled");
        }
        return Options.newNone();
    }

    public int priority() {
        return 1;
    }
}

