/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.wizards;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmlProjectUtils {
    public static final String DOT = ".";
    public static final String MODEL_FILE_EXTENSION = "uml";
    public static final String MODEL_OBJECT = "Model";
    public static final String PACKAGE_OBJECT = "Package";
    public static final String PROFILE_OBJECT = "Profile";

    private static EObject createInitialModel(String rootObjectName) {
        Model root = null;
        if (MODEL_OBJECT.equals(rootObjectName)) {
            root = UMLFactory.eINSTANCE.createModel();
            root.setName(Messages.UmlModelWizard_DefaultModelName);
        } else if (PACKAGE_OBJECT.equals(rootObjectName)) {
            root = UMLFactory.eINSTANCE.createPackage();
            root.setName(Messages.UmlModelWizard_DefaultPackageName);
        } else if (PROFILE_OBJECT.equals(rootObjectName)) {
            root = UMLFactory.eINSTANCE.createProfile();
            root.setName(Messages.UmlModelWizard_DefaultPackageName);
        }
        return root;
    }

    public static Option<IFile> createSemanticResource(IProject project, final String rootObjectName, String newUmlFileName) {
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        final Session session = ((ModelingProject)modelingProject.get()).getSession();
        final String platformPath = UmlProjectUtils.getNewUmlModelFilePath(project, newUmlFileName);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                URI semanticModelURI = URI.createPlatformResourceURI((String)platformPath, (boolean)true);
                Resource res = new ResourceSetImpl().createResource(semanticModelURI);
                EObject rootObject = UmlProjectUtils.createInitialModel(rootObjectName);
                if (rootObject != null) {
                    res.getContents().add((Object)rootObject);
                }
                try {
                    res.save((Map)Maps.newHashMap());
                }
                catch (IOException e) {
                    UMLDesignerPlugin.log(4, Messages.UmlModelWizard_UI_Error_CreatingUmlModel, e);
                }
                session.addSemanticResource(semanticModelURI, (IProgressMonitor)new NullProgressMonitor());
                session.save((IProgressMonitor)new NullProgressMonitor());
            }
        });
        return Options.newSome((Object)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformPath)));
    }

    private static String getNewUmlModelFilePath(IProject project, String umlFileName) {
        return String.valueOf('/') + project.getName() + '/' + umlFileName.toLowerCase();
    }
}

