/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.wizards.Messages;
import org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel.InitUmlModel;

public abstract class AbstractNewUmlModelWizard
extends BasicNewProjectResourceWizard {
    protected IProject project;
    protected String rootObjectName;
    protected String newUmlModelFileName;

    private void openDashboard(IProject curProject, IProgressMonitor monitor) {
        Session session;
        Option opionalModelingProject = ModelingProject.asModelingProject((IProject)curProject);
        if (opionalModelingProject.some() && (session = ((ModelingProject)opionalModelingProject.get()).getSession()) != null && !session.getSelectedViews().isEmpty()) {
            for (DView view : session.getSelectedViews()) {
                if (view.getOwnedRepresentations().isEmpty()) continue;
                for (DRepresentation representation : view.getOwnedRepresentations()) {
                    RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
                    if (!"Dashboard".equals(description.getName())) continue;
                    DialectUIManager.INSTANCE.openEditor(session, representation, monitor);
                    return;
                }
            }
        }
    }

    public boolean performFinish() {
        if (this.project == null || this.rootObjectName == null || this.newUmlModelFileName == null) {
            throw new IllegalArgumentException();
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                InitUmlModel init = new InitUmlModel(AbstractNewUmlModelWizard.this.project, AbstractNewUmlModelWizard.this.rootObjectName, AbstractNewUmlModelWizard.this.newUmlModelFileName);
                try {
                    AbstractNewUmlModelWizard.this.getContainer().run(false, true, (IRunnableWithProgress)init);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    UMLDesignerPlugin.log(4, Messages.UmlModelWizard_UI_Error_CreatingUmlModel, e);
                }
                IResource newUmlModelFile = AbstractNewUmlModelWizard.this.project.findMember(AbstractNewUmlModelWizard.this.newUmlModelFileName);
                AbstractNewUmlModelWizard.this.updatePerspective();
                AbstractNewUmlModelWizard.selectAndReveal((IResource)newUmlModelFile, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                AbstractNewUmlModelWizard.this.openDashboard(AbstractNewUmlModelWizard.this.project, monitor);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "org.obeonetwork.dsl.uml2.design.doc.Dashboard");
                PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.UmlModelWizard_UI_Error_CreatingUmlModel, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                UMLDesignerPlugin.log(4, Messages.UmlModelWizard_UI_Error_CreatingUmlModel, e);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

