/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.IWorkbench;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.internal.wizards.Messages;
import org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel.AbstractNewUmlModelWizard;
import org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel.UmlModelWizardInitModelPage;
import org.obeonetwork.dsl.uml2.design.internal.wizards.newmodel.UmlModelWizardNewModelFilePage;

public class UmlModelWizard
extends AbstractNewUmlModelWizard {
    private UmlModelWizardNewModelFilePage newModelFilePage;
    private UmlModelWizardInitModelPage initModelPage;

    public void addPages() {
        Object selectedElement;
        this.newModelFilePage = new UmlModelWizardNewModelFilePage(Messages.UmlModelWizard_UI_NewModelFilePageId, this.selection);
        this.newModelFilePage.setTitle(Messages.UmlModelWizard_UI_NewModelFilePageTitle);
        this.newModelFilePage.setDescription(Messages.UmlModelWizard_UI_NewModelFilePageDescription);
        this.newModelFilePage.setFileName(String.valueOf(Messages.UmlModelWizard_UI_ModelFileDefaultName) + "." + "uml");
        this.addPage((IWizardPage)this.newModelFilePage);
        this.initModelPage = new UmlModelWizardInitModelPage(Messages.UmlModelWizard_UI_InitModelPageId);
        this.initModelPage.setTitle(Messages.UmlModelWizard_UI_InitModelPageTitle);
        this.initModelPage.setDescription(Messages.UmlModelWizard_UI_InitModelPageDescription);
        this.addPage((IWizardPage)this.initModelPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newModelFilePage.setContainerFullPath(selectedResource.getFullPath());
                String modelFilename = this.getNewModelName(selectedResource);
                this.newModelFilePage.setFileName(modelFilename);
            }
        }
    }

    private String getNewModelName(IResource selectedResource) {
        String defaultModelBaseFilename = Messages.UmlModelWizard_UI_ModelFileDefaultName;
        String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + "uml";
        int i = 1;
        while (((IContainer)selectedResource).findMember(modelFilename) != null) {
            modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + "uml";
            ++i;
        }
        return modelFilename;
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        this.selection = structuredSelection;
        this.setWindowTitle(Messages.UmlModelWizard_UI_WizardTitle);
    }

    public boolean performFinish() {
        Option<IFile> option = this.newModelFilePage.getModelFile();
        if (option.some()) {
            IFile modelFile = (IFile)option.get();
            this.project = modelFile.getProject();
            try {
                ModelingProjectManager.INSTANCE.convertToModelingProject(this.project, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                UMLDesignerPlugin.log(4, Messages.UmlModelWizard_UI_Error_CreatingUmlModel, e);
                return false;
            }
            this.rootObjectName = this.initModelPage.getInitialObjectName();
            this.newUmlModelFileName = this.newModelFilePage.getFileName();
            super.performFinish();
            return true;
        }
        return false;
    }
}

