/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AbstractConformanceVisitor;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.common.types.util.TypeConformanceStrategySelector;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TypeConformanceComputer {
    protected AbstractConformanceVisitor<JvmTypeReference> leftDispatcher = this.createStrategySelector();
    @Inject
    protected SuperTypeCollector superTypeCollector;
    @Inject
    protected TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    protected TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    protected Primitives primitives;
    @Inject
    protected TypeReferences typeReferences;

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    protected TypeConformanceStrategySelector createStrategySelector() {
        return new TypeConformanceStrategySelector(this);
    }

    public void setPrimitives(Primitives primitives) {
        this.primitives = primitives;
    }

    public void setFactory(TypesFactory factory) {
        this.factory = factory;
    }

    public void setTypeArgumentContextProvider(TypeArgumentContextProvider typeArgumentContextProvider) {
        this.typeArgumentContextProvider = typeArgumentContextProvider;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right) {
        return this.isConformant(left, right, false);
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        if (left == right && left != null) {
            return true;
        }
        TypeConformanceResult result = this.isConformant(left, right, new TypeConformanceComputationArgument(ignoreGenerics, false, true));
        return result.isConformant();
    }

    public TypeConformanceResult isConformant(JvmTypeReference left, JvmTypeReference right, TypeConformanceComputationArgument flags) {
        if (left == right && left != null) {
            return TypeConformanceResult.SUCCESS;
        }
        return (TypeConformanceResult)this.leftDispatcher.visit(left, TypeConformanceComputationArgument.Internal.create(right, flags.rawType, flags.asTypeArgument, flags.allowPrimitiveConversion));
    }

    protected boolean isPrimitiveVoid(JvmTypeReference reference) {
        return reference.getType() instanceof JvmVoid;
    }

    public JvmTypeReference getCommonSuperType(List<JvmTypeReference> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("Types can't be null or empty " + types);
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        for (JvmTypeReference type : types) {
            if (this.conformsToAll(type, types)) {
                return type;
            }
            if (!this.isPrimitiveVoid(type)) continue;
            return null;
        }
        if (this.containsPrimitiveOrAnyReferences(types)) {
            List<JvmTypeReference> withoutPrimitives = this.replacePrimitivesAndRemoveAnyReferences(types);
            if (withoutPrimitives.equals(types)) {
                return null;
            }
            return this.getCommonSuperType(withoutPrimitives);
        }
        JvmTypeReference firstType = types.get(0);
        List<JvmTypeReference> tail = types.subList(1, types.size());
        LinkedHashMultimap all = LinkedHashMultimap.create();
        LinkedHashMultiset cumulatedDistance = LinkedHashMultiset.create();
        this.initializeDistance(firstType, (Multimap<JvmType, JvmTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        this.cumulateDistance(tail, (Multimap<JvmType, JvmTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        ArrayList candidates = Lists.newArrayList((Iterable)cumulatedDistance.entrySet());
        if (candidates.size() == 1) {
            JvmType firstRawType = (JvmType)((Multiset.Entry)candidates.get(0)).getElement();
            return this.getFirstForRawType((Multimap<JvmType, JvmTypeReference>)all, firstRawType);
        }
        this.inplaceSortByDistanceAndName(candidates);
        ArrayList referencesWithSameDistance = Lists.newArrayListWithExpectedSize((int)2);
        int wasDistance = -1;
        boolean classSeen = false;
        block1: for (Multiset.Entry rawTypeCandidate : candidates) {
            JvmType rawType = (JvmType)rawTypeCandidate.getElement();
            JvmTypeReference result = null;
            if (wasDistance == -1) {
                wasDistance = rawTypeCandidate.getCount();
            } else if (wasDistance != rawTypeCandidate.getCount()) {
                if (classSeen) break;
                result = this.getTypeParametersForSupertype((Multimap<JvmType, JvmTypeReference>)all, rawType, types);
                for (JvmTypeReference alreadyCollected : referencesWithSameDistance) {
                    if (!this.isConformant(result, alreadyCollected, true)) continue;
                    classSeen = classSeen || this.isClass(rawType);
                    continue block1;
                }
                wasDistance = rawTypeCandidate.getCount();
            }
            if (result == null) {
                result = this.getTypeParametersForSupertype((Multimap<JvmType, JvmTypeReference>)all, rawType, types);
            }
            if (result == null) continue;
            boolean isClass = this.isClass(rawType);
            boolean bl = classSeen = classSeen || isClass;
            if (isClass) {
                referencesWithSameDistance.add(0, result);
                continue;
            }
            referencesWithSameDistance.add(result);
        }
        if (referencesWithSameDistance.size() == 1) {
            return (JvmTypeReference)referencesWithSameDistance.get(0);
        }
        if (referencesWithSameDistance.size() > 1) {
            JvmMultiTypeReference result = this.typeReferences.createMultiTypeReference((Notifier)((JvmTypeReference)referencesWithSameDistance.get(0)).getType(), new JvmTypeReference[0]);
            if (result == null) {
                return result;
            }
            for (JvmTypeReference reference : referencesWithSameDistance) {
                result.getReferences().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)reference)));
            }
            return result;
        }
        return null;
    }

    protected boolean isClass(JvmType type) {
        if (type instanceof JvmArrayType) {
            return this.isClass(((JvmArrayType)type).getComponentType());
        }
        return type instanceof JvmGenericType && !((JvmGenericType)type).isInterface();
    }

    protected JvmType findContext(JvmTypeReference firstType) {
        if (firstType instanceof JvmGenericArrayTypeReference) {
            return this.findContext(((JvmGenericArrayTypeReference)firstType).getComponentType());
        }
        return firstType.getType();
    }

    protected List<JvmTypeReference> replacePrimitivesAndRemoveAnyReferences(List<JvmTypeReference> types) {
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference type : types) {
            if (type instanceof JvmAnyTypeReference) continue;
            result.add(this.primitives.asWrapperTypeIfPrimitive(type));
        }
        return result;
    }

    protected boolean containsPrimitiveOrAnyReferences(List<JvmTypeReference> types) {
        for (JvmTypeReference type : types) {
            if (this.isPrimitiveType(type)) {
                return true;
            }
            if (!(type instanceof JvmAnyTypeReference)) continue;
            return true;
        }
        return false;
    }

    protected List<JvmTypeReference> getComponentTypes(List<JvmTypeReference> types) {
        AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference> componentTypeComputer = new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

            @Override
            public JvmTypeReference doVisitTypeReference(JvmTypeReference reference) {
                return null;
            }

            @Override
            protected JvmTypeReference handleNullReference() {
                return null;
            }

            @Override
            public JvmTypeReference doVisitMultiTypeReference(JvmMultiTypeReference multi) {
                JvmMultiTypeReference result = TypeConformanceComputer.this.factory.createJvmMultiTypeReference();
                for (JvmTypeReference reference : multi.getReferences()) {
                    JvmTypeReference component = (JvmTypeReference)this.visit(reference);
                    if (component == null) continue;
                    if (component.eContainer() == null) {
                        result.getReferences().add((Object)component);
                        continue;
                    }
                    JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                    delegate.setDelegate(component);
                    result.getReferences().add((Object)delegate);
                }
                return result;
            }

            @Override
            public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                return reference.getComponentType();
            }

            @Override
            public JvmTypeReference doVisitSynonymTypeReference(JvmSynonymTypeReference synonym) {
                JvmTypeReference result = null;
                for (JvmTypeReference reference : synonym.getReferences()) {
                    JvmTypeReference component = (JvmTypeReference)this.visit(reference);
                    if (component == null) continue;
                    if (result == null) {
                        result = component;
                        continue;
                    }
                    if (!(result instanceof JvmSynonymTypeReference)) {
                        JvmSynonymTypeReference newResult = TypeConformanceComputer.this.factory.createJvmSynonymTypeReference();
                        if (result.eContainer() == null) {
                            newResult.getReferences().add((Object)result);
                        } else {
                            JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                            delegate.setDelegate(component);
                            newResult.getReferences().add((Object)delegate);
                        }
                        result = newResult;
                    }
                    if (component.eContainer() == null) {
                        ((JvmSynonymTypeReference)result).getReferences().add((Object)result);
                        continue;
                    }
                    JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                    delegate.setDelegate(component);
                    ((JvmSynonymTypeReference)result).getReferences().add((Object)delegate);
                }
                return result;
            }
        };
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference reference : types) {
            JvmTypeReference componentType = (JvmTypeReference)componentTypeComputer.visit(reference);
            result.add(componentType);
        }
        return result;
    }

    protected boolean allTypesAreArrays(List<JvmTypeReference> types) {
        AbstractTypeReferenceVisitor.InheritanceAware<Boolean> isArrayVisitor = new AbstractTypeReferenceVisitor.InheritanceAware<Boolean>(){

            @Override
            protected Boolean handleNullReference() {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitTypeReference(JvmTypeReference reference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitMultiTypeReference(JvmMultiTypeReference multi) {
                for (JvmTypeReference reference : multi.getReferences()) {
                    if (((Boolean)this.visit(reference)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return !multi.getReferences().isEmpty();
            }

            @Override
            public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                if (reference.getComponentType() != null) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean doVisitSynonymTypeReference(JvmSynonymTypeReference synonym) {
                for (JvmTypeReference reference : synonym.getReferences()) {
                    if (!((Boolean)this.visit(reference)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        for (JvmTypeReference reference : types) {
            if (((Boolean)isArrayVisitor.visit(reference)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrimitiveType(JvmTypeReference reference) {
        return reference.getType() instanceof JvmPrimitiveType;
    }

    protected JvmTypeReference getTypeParametersForSupertype(final Multimap<JvmType, JvmTypeReference> all, JvmType rawType, List<JvmTypeReference> initiallyRequested) {
        Function<JvmTypeReference, JvmTypeReference> getComponentType;
        JvmComponentType componentType;
        ForwardingMultimap<JvmType, JvmTypeReference> decorated;
        JvmTypeReference componentTypeReference;
        if (rawType instanceof JvmTypeParameterDeclarator) {
            EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)rawType)).getTypeParameters();
            if (typeParameters.isEmpty()) {
                return this.getFirstForRawType(all, rawType);
            }
            ArrayList parameterSuperTypes = Lists.newArrayList();
            int i = 0;
            while (i < typeParameters.size()) {
                ArrayList parameterReferences = Lists.newArrayList();
                for (JvmTypeReference reference : all.get((Object)rawType)) {
                    if (reference instanceof JvmParameterizedTypeReference) {
                        JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)reference;
                        if (parameterized.getArguments().isEmpty()) {
                            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
                            result.setType(rawType);
                            return result;
                        }
                        JvmTypeReference parameterReference = (JvmTypeReference)parameterized.getArguments().get(i);
                        parameterReferences.add(parameterReference);
                        continue;
                    }
                    return null;
                }
                JvmTypeReference parameterSuperType = this.getCommonParameterSuperType(parameterReferences, initiallyRequested);
                if (parameterSuperType == null) {
                    return null;
                }
                parameterSuperTypes.add(parameterSuperType);
                ++i;
            }
            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
            result.setType(rawType);
            for (JvmTypeReference parameterSuperType : parameterSuperTypes) {
                result.getArguments().add((Object)((JvmTypeReference)EcoreUtil2.clone((EObject)parameterSuperType)));
            }
            return result;
        }
        if (rawType instanceof JvmArrayType && (componentTypeReference = this.getTypeParametersForSupertype((Multimap<JvmType, JvmTypeReference>)(decorated = new ForwardingMultimap<JvmType, JvmTypeReference>(componentType = ((JvmArrayType)rawType).getComponentType(), rawType, (Function)(getComponentType = new Function<JvmTypeReference, JvmTypeReference>(){

            public JvmTypeReference apply(JvmTypeReference from) {
                if (from instanceof JvmGenericArrayTypeReference) {
                    return ((JvmGenericArrayTypeReference)from).getComponentType();
                }
                return from;
            }
        })){
            private final /* synthetic */ JvmComponentType val$componentType;
            private final /* synthetic */ JvmType val$rawType;
            private final /* synthetic */ Function val$getComponentType;
            {
                this.val$componentType = jvmComponentType;
                this.val$rawType = jvmType;
                this.val$getComponentType = function;
            }

            protected Multimap<JvmType, JvmTypeReference> delegate() {
                return all;
            }

            public Collection<JvmTypeReference> get(JvmType key) {
                if (key == this.val$componentType) {
                    Collection result = all.get((Object)this.val$rawType);
                    return Collections2.transform((Collection)result, (Function)this.val$getComponentType);
                }
                return super.get((Object)key);
            }
        }), componentType, Lists.transform(initiallyRequested, (Function)getComponentType))) != null) {
            if (componentTypeReference.eContainer() instanceof JvmGenericArrayTypeReference) {
                return (JvmTypeReference)componentTypeReference.eContainer();
            }
            JvmGenericArrayTypeReference result = this.factory.createJvmGenericArrayTypeReference();
            result.setComponentType(componentTypeReference);
            return result;
        }
        return null;
    }

    protected JvmTypeReference getFirstForRawType(Multimap<JvmType, JvmTypeReference> all, JvmType rawType) {
        for (JvmTypeReference result : all.get((Object)rawType)) {
            if (!(result instanceof JvmParameterizedTypeReference) && !(result instanceof JvmGenericArrayTypeReference)) continue;
            return result;
        }
        throw new IllegalStateException(String.valueOf(all.toString()) + " does not contain a useful type reference for rawtype " + rawType.getQualifiedName());
    }

    protected void initializeDistance(JvmTypeReference firstType, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        ITypeArgumentContext firstContext = this.typeArgumentContextProvider.getTypeArgumentContext(new TypeArgumentContextProvider.ReceiverRequest(firstType));
        MaxDistanceRawTypeAcceptor acceptor = new MaxDistanceRawTypeAcceptor(cumulatedDistance, all, new ArgumentResolver(firstContext));
        acceptor.accept(firstType, 0);
        this.superTypeCollector.collectSuperTypes(firstType, acceptor);
    }

    protected void cumulateDistance(List<JvmTypeReference> references, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        for (JvmTypeReference other : references) {
            LinkedHashMultiset otherDistance = LinkedHashMultiset.create();
            this.initializeDistance(other, all, (Multiset<JvmType>)otherDistance);
            cumulatedDistance.retainAll((Collection)otherDistance);
            for (Multiset.Entry typeToDistance : otherDistance.entrySet()) {
                if (!cumulatedDistance.contains(typeToDistance.getElement())) continue;
                cumulatedDistance.add((Object)((JvmType)typeToDistance.getElement()), typeToDistance.getCount());
            }
        }
    }

    protected void inplaceSortByDistanceAndName(List<Multiset.Entry<JvmType>> candidates) {
        Collections.sort(candidates, new Comparator<Multiset.Entry<JvmType>>(){

            @Override
            public int compare(Multiset.Entry<JvmType> o1, Multiset.Entry<JvmType> o2) {
                if (o1.getCount() == o2.getCount()) {
                    JvmType element1 = (JvmType)o1.getElement();
                    JvmType element2 = (JvmType)o2.getElement();
                    return this.compare(element1, element2);
                }
                if (o1.getCount() < o2.getCount()) {
                    return -1;
                }
                return 1;
            }

            @Override
            protected int compare(JvmType element1, JvmType element2) {
                int result;
                if (element1 instanceof JvmArrayType && element2 instanceof JvmArrayType) {
                    return this.compare(((JvmArrayType)element1).getComponentType(), ((JvmArrayType)element2).getComponentType());
                }
                if (element1 instanceof JvmGenericType && element2 instanceof JvmGenericType && (result = Booleans.compare((boolean)((JvmGenericType)element1).isInterface(), (boolean)((JvmGenericType)element2).isInterface())) != 0) {
                    return result;
                }
                return element1.getIdentifier().compareTo(element2.getIdentifier());
            }
        });
    }

    public JvmTypeReference getCommonParameterSuperType(List<JvmTypeReference> types, List<JvmTypeReference> initiallyRequested) {
        HashSet initiallyRequestedNames;
        Function<JvmTypeReference, String> getCanonicalName = new Function<JvmTypeReference, String>(){

            public String apply(JvmTypeReference from) {
                return from.getIdentifier();
            }
        };
        HashSet allNames = Sets.newHashSet((Iterable)Iterables.transform(types, (Function)getCanonicalName));
        if (allNames.size() == 1) {
            return types.get(0);
        }
        if (types.size() == initiallyRequested.size() && (initiallyRequestedNames = Sets.newHashSet((Iterable)Iterables.transform(initiallyRequested, (Function)getCanonicalName))).equals(allNames)) {
            JvmTypeReference objectTypeReference = this.typeReferences.getTypeForName(Object.class, (Notifier)types.get(0).getType(), new JvmTypeReference[0]);
            return this.typeReferences.wildCardExtends(objectTypeReference);
        }
        JvmTypeReference superType = this.getCommonSuperType(types);
        if (superType instanceof JvmWildcardTypeReference) {
            return superType;
        }
        JvmWildcardTypeReference wildcardTypeReference = this.factory.createJvmWildcardTypeReference();
        if (superType != null) {
            JvmUpperBound upperBound = this.factory.createJvmUpperBound();
            upperBound.setTypeReference((JvmTypeReference)EcoreUtil2.clone((EObject)superType));
            wildcardTypeReference.getConstraints().add((Object)upperBound);
        }
        return wildcardTypeReference;
    }

    protected boolean conformsToAll(JvmTypeReference type, List<JvmTypeReference> types) {
        boolean conform = true;
        int i = 0;
        while (conform && i < types.size()) {
            conform = this.isConformant(type, types.get(i));
            ++i;
        }
        return conform;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    protected SuperTypeCollector getSuperTypeCollector() {
        return this.superTypeCollector;
    }

    protected Primitives getPrimitives() {
        return this.primitives;
    }

    protected TypeArgumentContextProvider getTypeArgumentContextProvider() {
        return this.typeArgumentContextProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentResolver
    implements Function<JvmTypeReference, JvmTypeReference> {
        private final ITypeArgumentContext context;

        protected ArgumentResolver(ITypeArgumentContext context) {
            this.context = context;
        }

        public JvmTypeReference apply(JvmTypeReference from) {
            JvmTypeReference result = this.context.resolve(from);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MaxDistanceRawTypeAcceptor
    implements SuperTypeCollector.SuperTypeAcceptor {
        private final Multiset<JvmType> distances;
        private final Multimap<JvmType, JvmTypeReference> rawTypeToReference;
        private final Function<JvmTypeReference, JvmTypeReference> resolver;

        protected MaxDistanceRawTypeAcceptor(Multiset<JvmType> result, Multimap<JvmType, JvmTypeReference> all, Function<JvmTypeReference, JvmTypeReference> resolver) {
            this.distances = result;
            this.rawTypeToReference = all;
            this.resolver = resolver;
        }

        @Override
        public boolean accept(JvmTypeReference superType, int distance) {
            if (superType == null) {
                return false;
            }
            JvmType type = superType.getType();
            this.rawTypeToReference.put((Object)type, (Object)((JvmTypeReference)this.resolver.apply((Object)superType)));
            if (this.distances.contains((Object)type)) {
                int currentCount = this.distances.count((Object)type);
                if (currentCount < distance + 1) {
                    this.distances.setCount((Object)type, distance + 1);
                }
            } else {
                this.distances.add((Object)type, distance + 1);
            }
            return true;
        }
    }
}

