/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;

public class ShiftDirectSubExecutionsOperation
extends AbstractModelChangeOperation<Void> {
    private final int deltaY;
    private final ISequenceEvent parent;

    public ShiftDirectSubExecutionsOperation(ISequenceEvent parent, int deltaY) {
        super("Shift sub-executions' positions by " + deltaY);
        this.parent = (ISequenceEvent)Preconditions.checkNotNull((Object)parent);
        this.deltaY = deltaY;
    }

    public Void execute() {
        for (View view : Iterables.filter((Iterable)Iterables.filter((Iterable)this.parent.getNotationView().getChildren(), View.class), AbstractNodeEvent.notationPredicate())) {
            Option<AbstractNodeEvent> execution = ISequenceElementAccessor.getAbstractNodeEvent(view);
            if (!execution.some()) continue;
            AbstractNodeEvent ise = (AbstractNodeEvent)execution.get();
            Range rg = ise.getVerticalRange();
            Range nrg = new Range(rg.getLowerBound() + this.deltaY, rg.getUpperBound() + this.deltaY);
            ise.setVerticalRange(nrg);
        }
        return null;
    }
}

