/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.editor.SpecificEditorInputTranformer;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IMemento;

public class SessionSpecificEditorInput
extends SessionEditorInput {
    private static final String VIEWPOINT_URI = "VIEWPOINT_URI";
    private static final String REPRESENTATION_DESCRIPTION_NAME = "REPRESENTATION_DESCRIPTION_NAME";
    private static final String SEMANTIC_MODEL_PATH = "SEMANTIC_MODEL_PATH";
    private IPath mySemanticModelPath;
    private URI mySiriusURI;
    private String myRepresentationDescriptionName;

    public SessionSpecificEditorInput(IMemento memento) {
        super(memento);
    }

    public SessionSpecificEditorInput(URI uri, String name, Session session) {
        super(uri, name, session);
    }

    public void init(IPath semanticModelPath, URI viewpointURI, String representationDescriptionName) {
        this.mySemanticModelPath = semanticModelPath;
        this.mySiriusURI = viewpointURI;
        this.myRepresentationDescriptionName = representationDescriptionName;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.mySiriusURI != null) {
            memento.putString(VIEWPOINT_URI, this.mySiriusURI.toString());
        }
        if (this.myRepresentationDescriptionName != null) {
            memento.putString(REPRESENTATION_DESCRIPTION_NAME, this.myRepresentationDescriptionName);
        }
        if (this.mySemanticModelPath != null) {
            memento.putString(SEMANTIC_MODEL_PATH, this.mySemanticModelPath.toString());
        }
    }

    @Override
    protected void loadState(IMemento memento) {
        super.loadState(memento);
        this.restoreValuesFromMemento(memento);
    }

    @Override
    protected Session getSession(URI sessionModelURI) {
        URI uriWithoutFragment = sessionModelURI.trimFragment();
        return this.createSessionFromURIAndMemento(uriWithoutFragment);
    }

    private Session createSessionFromURIAndMemento(URI uri) {
        SpecificEditorInputTranformer tranformer = new SpecificEditorInputTranformer();
        tranformer.init(this.mySiriusURI, this.myRepresentationDescriptionName);
        try {
            DRepresentation representation = tranformer.createSessionAndRepresentation(this.mySemanticModelPath, uri.toString());
            return SessionManager.INSTANCE.getSession(((DSemanticDecorator)representation).getTarget());
        }
        catch (IOException exception) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", "Failing of EditorInput transformation.", (Throwable)exception));
        }
        catch (CoreException exception) {
            SiriusEditPlugin.getPlugin().getLog().log(exception.getStatus());
        }
        return null;
    }

    private void restoreValuesFromMemento(IMemento memento) {
        this.mySemanticModelPath = new Path(memento.getString(SEMANTIC_MODEL_PATH));
        this.mySiriusURI = URI.createURI((String)memento.getString(VIEWPOINT_URI));
        this.myRepresentationDescriptionName = memento.getString(REPRESENTATION_DESCRIPTION_NAME);
    }
}

