/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.EditingDomainUndoContext;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class RestoreToLastSavePointListener
implements ResourceSyncClient,
IOperationHistoryListener {
    private IUndoableOperation marker;
    private Session session;

    public RestoreToLastSavePointListener(Session session) {
        this.session = session;
    }

    public void register() {
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain()).registerClient((ResourceSyncClient)this);
    }

    public void unregister() {
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
        Option resourceSetSync = ResourceSetSync.getResourceSetSync((TransactionalEditingDomain)this.session.getTransactionalEditingDomain());
        if (resourceSetSync.some()) {
            ((ResourceSetSync)resourceSetSync.get()).unregisterClient((ResourceSyncClient)this);
        }
    }

    public void returnToSyncState() {
        if (RestoreToLastSavePointListener.isAllowedToReturnToSyncState()) {
            NullProgressMonitor pm = new NullProgressMonitor();
            try {
                IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                Object undoCtx = this.session.getTransactionalEditingDomain() != null ? (this.session.getTransactionalEditingDomain().getCommandStack() instanceof IWorkspaceCommandStack ? ((IWorkspaceCommandStack)this.session.getTransactionalEditingDomain().getCommandStack()).getDefaultUndoContext() : new EditingDomainUndoContext((EditingDomain)this.session.getTransactionalEditingDomain())) : new ObjectUndoContext((Object)this);
                while (operationHistory != null && operationHistory.canUndo((IUndoContext)undoCtx) && this.session.getStatus() != SessionStatus.SYNC) {
                    IUndoableOperation toUndo = operationHistory.getUndoOperation((IUndoContext)undoCtx);
                    operationHistory.undoOperation(toUndo, (IProgressMonitor)new NullProgressMonitor(), null);
                    if (this.marker == toUndo) break;
                }
                this.session.save((IProgressMonitor)pm);
            }
            catch (ExecutionException e) {
                this.session.close((IProgressMonitor)pm);
                String sessionLabel = SiriusEditPlugin.getPlugin().getUiCallback().getSessionNameToDisplayWhileSaving(this.session);
                SiriusPlugin.getDefault().warning(String.valueOf(sessionLabel) + " were closed. An error occurs while attempting to cancel all modifications. No modification were saved.", (Exception)((Object)e));
            }
        }
    }

    public static boolean isAllowedToReturnToSyncState() {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        return preferenceStore != null && preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_RELOAD_ON_LAST_EDITOR_CLOSE.name());
    }

    public void dispose() {
        this.session = null;
        this.marker = null;
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.session != null && SessionStatus.SYNC.equals((Object)this.session.getStatus())) {
            this.marker = null;
        }
    }

    public void historyNotification(OperationHistoryEvent event) {
        if (this.session != null && SessionStatus.DIRTY.equals((Object)this.session.getStatus()) && this.marker == null) {
            this.marker = event.getOperation();
        }
    }
}

