/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.internal.actions.export.AbstractExportRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportRepresentationsAction
extends AbstractExportRepresentationsAction {
    private static Predicate<DRepresentation> exportableRepresentation = new Predicate<DRepresentation>(){

        public boolean apply(DRepresentation input) {
            return DialectUIManager.INSTANCE.canExport(input, new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, null));
        }
    };
    private final Session session;
    private Collection<DRepresentation> selectedRepresentations;

    public ExportRepresentationsAction(Session session, Collection<DRepresentation> selectedRepresentations) {
        super(SiriusEditPlugin.INSTANCE.getString("exportRepresentationsAsImagesActionLabel"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/image.gif"));
        this.session = session;
        this.selectedRepresentations = selectedRepresentations;
    }

    @Override
    protected Collection<DRepresentation> getDRepresentationToExport() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.selectedRepresentations, exportableRepresentation));
    }

    public boolean isEnabled() {
        return super.isEnabled() && !Iterables.isEmpty((Iterable)Iterables.filter(this.selectedRepresentations, exportableRepresentation));
    }

    @Override
    protected Session getSession(DRepresentation representation) {
        return this.session;
    }
}

