/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.common.ui.tools.api.wizard.SelectFilesWizardPage;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.session.SessionHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SessionFileCreationWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SessionKindSelectionWizardPage;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewSessionWizard
extends Wizard
implements INewWizard {
    public static final String ID = "org.eclipse.sirius.ui.session.creation";
    private static final String SESSION_CREATION_ERROR_MSG = "Error creating Representations File";
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected SessionKindSelectionWizardPage sessionKindWizardPage;
    protected SessionFileCreationWizardPage sessionFileCreationPage;
    protected SelectFilesWizardPage modelSelectionPage;

    public NewSessionWizard() {
    }

    public NewSessionWizard(TreeSelection initialSelection) {
        this.selection = initialSelection;
    }

    public IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = new StructuredSelection();
        }
        return this.selection;
    }

    public void init(IWorkbench w, IStructuredSelection s) {
        this.selection = s;
        this.workbench = w;
        this.setWindowTitle("New Representations File");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/wizban/banner_aird.gif"));
    }

    public boolean canFinish() {
        if (this.sessionKindWizardPage.emptySession()) {
            return this.sessionKindWizardPage.isPageComplete() && this.sessionFileCreationPage.isPageComplete();
        }
        return super.canFinish();
    }

    public void addPages() {
        boolean singleSemanticResourceSelected = this.selection.size() == 1 && this.selection.getFirstElement() instanceof IFile;
        boolean defaultToEmptyModel = !singleSemanticResourceSelected;
        this.sessionKindWizardPage = new SessionKindSelectionWizardPage("SessionKind", defaultToEmptyModel);
        this.addPage((IWizardPage)this.sessionKindWizardPage);
        this.modelSelectionPage = new SelectFilesWizardPage("Select model to analyse", 1, 1, new String[]{"*"});
        if (this.selection != null) {
            this.modelSelectionPage.setInitialSelection(this.selection);
        }
        this.addPage((IWizardPage)this.modelSelectionPage);
        this.sessionFileCreationPage = new SessionFileCreationWizardPage("DiagramModelFile", this.getSelection(), "aird");
        this.addPage((IWizardPage)this.sessionFileCreationPage);
    }

    public boolean performFinish() {
        boolean finished = true;
        URI sessionModelURI = this.sessionFileCreationPage.getURI();
        final Collection<URI> semanticResourceURIs = this.getSemanticResourceURIs();
        SessionCreationOperation sessionCreationOperation = new SessionCreationOperation(sessionModelURI, semanticResourceURIs);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)sessionCreationOperation);
            final Session session = sessionCreationOperation.getSession();
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IFile newReprepresentationsFile;
                    if (session != null && !semanticResourceURIs.isEmpty()) {
                        ViewpointSelection.openViewpointsSelectionDialog(session);
                        SessionHelper.openStartupRepresentations(session, monitor);
                    }
                    if ((newReprepresentationsFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(NewSessionWizard.this.sessionFileCreationPage.getURI().toPlatformString(true)))) != null && newReprepresentationsFile.exists()) {
                        BasicNewResourceWizard.selectAndReveal((IResource)newReprepresentationsFile, (IWorkbenchWindow)NewSessionWizard.this.workbench.getActiveWorkbenchWindow());
                        EclipseUIUtil.expand((IResource)newReprepresentationsFile, (IWorkbenchWindow)NewSessionWizard.this.workbench.getActiveWorkbenchWindow());
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", SESSION_CREATION_ERROR_MSG, (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
            finished = false;
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", SESSION_CREATION_ERROR_MSG, e.getTargetException());
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
            finished = false;
        }
        return finished;
    }

    private Collection<URI> getSemanticResourceURIs() {
        Collection<IFile> files;
        IPath[] selectedSemanticFilePaths;
        ArrayList<URI> semanticResources = new ArrayList<URI>();
        if (!this.sessionKindWizardPage.emptySession() && (selectedSemanticFilePaths = this.modelSelectionPage.getSelection()).length != 0 && !(files = this.getSemanticFiles(selectedSemanticFilePaths)).isEmpty()) {
            for (IFile semanticModelFile : files) {
                semanticResources.add(URI.createPlatformResourceURI((String)semanticModelFile.getFullPath().toOSString(), (boolean)true));
            }
        }
        return semanticResources;
    }

    private Collection<IFile> getSemanticFiles(IPath[] selectedSemanticFilePaths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        HashSet<IFile> files = new HashSet<IFile>();
        IPath[] iPathArray = selectedSemanticFilePaths;
        int n = selectedSemanticFilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IFile file = workspace.getRoot().getFile(path);
            files.add(file);
            ++n2;
        }
        return files;
    }

    private static final class SessionCreationOperation
    extends WorkspaceModifyOperation {
        private URI sessionModelURI;
        private Collection<URI> semanticResourceURIs;
        private Session session;

        public SessionCreationOperation(URI sessionModelURI, Collection<URI> semanticResourceURIs) {
            this.sessionModelURI = sessionModelURI;
            this.semanticResourceURIs = semanticResourceURIs;
        }

        public Session getSession() {
            return this.session;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
            try {
                monitor.beginTask("Representations file creation", 1);
                DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(this.sessionModelURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                sessionCreationOperation.execute();
                this.session = sessionCreationOperation.getCreatedSession();
                for (URI semanticResourceURI : this.semanticResourceURIs) {
                    AddSemanticResourceCommand addSemanticResourceCmd = new AddSemanticResourceCommand(this.session, semanticResourceURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)addSemanticResourceCmd);
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

