/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class TaskExecutor {
    private static final int KIND_EXECUTE = 0;
    private static final int KIND_UNDO = 1;
    private static final int KIND_REDO = 2;

    private TaskExecutor() {
    }

    public static boolean canExecute(List<ICommandTask> tasks) {
        boolean result = true;
        Iterator<ICommandTask> it = tasks.iterator();
        while (it.hasNext() && result) {
            ICommandTask task = it.next();
            boolean bl = result = result && TaskExecutor.canExecute(task);
        }
        return result;
    }

    public static void execute(List<ICommandTask> tasks) {
        TaskExecutor.operation(tasks, 0);
    }

    public static void undo(List<ICommandTask> tasks) {
        TaskExecutor.operation(tasks, 1);
    }

    public static void redo(List<ICommandTask> tasks) {
        TaskExecutor.operation(tasks, 2);
    }

    private static void operation(List<ICommandTask> tasks, int kind) {
        for (ICommandTask task : tasks) {
            switch (kind) {
                case 0: {
                    try {
                        task.execute();
                    }
                    catch (MetaClassNotFoundException e) {
                        SiriusPlugin.getDefault().error("Error while modifying model", e);
                    }
                    catch (FeatureNotFoundException e) {
                        SiriusPlugin.getDefault().error("Error while modifying model", e);
                    }
                    if (task.executeMyselfChildrenTasks()) break;
                    TaskExecutor.operation(task.getChildrenTasks(), kind);
                    break;
                }
                case 1: {
                    task.undo();
                    TaskExecutor.operation(task.getChildrenTasks(), kind);
                    break;
                }
                case 2: {
                    task.redo();
                    TaskExecutor.operation(task.getChildrenTasks(), kind);
                    break;
                }
            }
        }
    }

    private static boolean canExecute(ICommandTask task) {
        if (!task.canExecute()) {
            return false;
        }
        boolean result = true;
        Iterator<ICommandTask> it = task.getChildrenTasks().iterator();
        while (it.hasNext() && result) {
            ICommandTask childTask = it.next();
            boolean bl = result = result && TaskExecutor.canExecute(childTask);
        }
        return result;
    }
}

