/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.DeleteEObjectTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.helper.task.AbstractCompoundTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteWithoutToolTask
extends AbstractCompoundTask {
    private DRepresentationElement element;
    private Set<EObject> allSemanticElements;
    private ModelAccessor modelAccessor;
    private TaskHelper taskHelper;

    public DeleteWithoutToolTask(DRepresentationElement element, Set<EObject> allSemanticElements, ModelAccessor modelAccessor, TaskHelper taskHelper) {
        this.element = element;
        this.allSemanticElements = allSemanticElements;
        this.modelAccessor = modelAccessor;
        this.taskHelper = taskHelper;
    }

    public DeleteWithoutToolTask(DRepresentationElement element, ModelAccessor modelAccessor, TaskHelper taskHelper) {
        this.element = element;
        this.modelAccessor = modelAccessor;
        this.taskHelper = taskHelper;
    }

    @Override
    public String getLabel() {
        return "Delete without tool";
    }

    @Override
    protected List<ICommandTask> prepareSubTasks() {
        ArrayList subTasks = Lists.newArrayList();
        Option<DRepresentation> parentRepresentation = new EObjectQuery(this.element).getRepresentation();
        if (parentRepresentation.some()) {
            if (this.allSemanticElements == null) {
                this.allSemanticElements = Sets.newLinkedHashSet();
                this.addSemanticElementsToDestroy(this.element, this.allSemanticElements);
            }
            Set<DSemanticDecorator> diagramElements = this.taskHelper.getDElementToClearFromSemanticElements((EObject)parentRepresentation.get(), this.allSemanticElements);
            for (DSemanticDecorator decorator : diagramElements) {
                subTasks.add(new DeleteEObjectTask(decorator, this.modelAccessor));
                this.addDialectSpecificAdditionalDeleteSubTasks(decorator, subTasks);
            }
        }
        for (EObject semantic : this.allSemanticElements) {
            DeleteEObjectTask deleteSemanticElementTask = new DeleteEObjectTask(semantic, this.modelAccessor);
            subTasks.add(deleteSemanticElementTask);
        }
        return subTasks;
    }

    private Set<EObject> addSemanticElementsToDestroy(DSemanticDecorator repElt, Set<EObject> elementsToDestroy) {
        EObject semantic = repElt.getTarget();
        if (semantic != null && !elementsToDestroy.contains(semantic)) {
            Iterables.addAll(elementsToDestroy, (Iterable)AllContents.of((EObject)semantic, (boolean)true));
        }
        return elementsToDestroy;
    }

    protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator decorator, List<ICommandTask> subTasks) {
    }
}

