/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class ExternalJavaActionTask
extends AbstractOperationTask {
    private final ExternalJavaAction externalJavaAction;
    private final IExternalJavaAction javaAction;
    private final Collection<EObject> selections = new ArrayList<EObject>();
    private final ModelAccessor accessor;
    private final TaskHelper taskHelper;

    public ExternalJavaActionTask(CommandContext context, ModelAccessor extPackage, ExternalJavaAction op, IInterpreter interpreter, UICallBack uiCallback) {
        super(context, extPackage, interpreter);
        this.externalJavaAction = op;
        this.accessor = extPackage;
        if (context.getCurrentTarget() != null) {
            this.selections.add(context.getCurrentTarget());
        }
        this.javaAction = ExternalJavaActionProvider.INSTANCE.getJavaActionById(this.externalJavaAction.getId());
        this.taskHelper = new TaskHelper(this.accessor, uiCallback);
    }

    @Override
    public void execute() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter);
        if (this.taskHelper.checkPrecondition(this.context.getCurrentTarget(), this.externalJavaAction)) {
            for (ExternalJavaActionParameter parameter : this.externalJavaAction.getParameters()) {
                Object value = safeInterpreter.evaluate(this.context.getCurrentTarget(), parameter, (EStructuralFeature)ToolPackage.eINSTANCE.getExternalJavaActionParameter_Value());
                parameters.put(parameter.getName(), value);
            }
            this.javaAction.execute(this.selections, parameters);
        }
    }

    @Override
    public String getLabel() {
        return "Execute external java action \"" + this.externalJavaAction.getName() + "\"";
    }

    @Override
    public boolean canExecute() {
        return this.javaAction != null && this.javaAction.canExecute(this.selections);
    }
}

