/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.Unset;

public class UnsetTask
extends AbstractOperationTask {
    private final Unset unsetOp;

    public UnsetTask(CommandContext context, ModelAccessor extPackage, Unset unsetOp, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        if (unsetOp == null) {
            throw new IllegalArgumentException("unsetOp is null");
        }
        this.unsetOp = unsetOp;
    }

    @Override
    public String getLabel() {
        return "unset the value";
    }

    @Override
    public void execute() {
        String element = this.unsetOp.getElementExpression();
        String featureName = this.unsetOp.getFeatureName();
        EObject context = this.context.getCurrentTarget();
        try {
            featureName = this.interpreter.evaluateString(context, featureName);
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)this.unsetOp, (EStructuralFeature)ToolPackage.eINSTANCE.getUnset_FeatureName(), e);
        }
        if (element != null && !StringUtil.isEmpty((String)element)) {
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter);
            Collection<EObject> elements = safeInterpreter.evaluateCollection(context, this.unsetOp, (EStructuralFeature)ToolPackage.eINSTANCE.getUnset_ElementExpression());
            ArrayList<EObject> elementsToUnset = new ArrayList<EObject>(elements);
            for (Object e : elementsToUnset) {
                this.extPackage.eRemove(context, featureName, e);
            }
        } else {
            try {
                this.extPackage.eSet(context, featureName, null);
            }
            catch (FeatureNotFoundException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.unsetOp, (EStructuralFeature)ToolPackage.eINSTANCE.getUnset_FeatureName(), e);
            }
        }
    }
}

