/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.AbstractViewpointResourceMonitor;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceListener;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.ViewpointResourceMonitor;

public class CompositeResourceMonitor
extends AbstractViewpointResourceMonitor
implements ViewpointResourceListener,
Comparator<URI> {
    private final List<ViewpointResourceMonitor> monitors = Lists.newArrayList();
    private final List<String> names = Lists.newArrayList();
    private final Map<URI, ViewpointResourceMonitor> origins = Maps.newHashMap();

    public synchronized void addMonitor(String name, ViewpointResourceMonitor monitor) throws IllegalStateException {
        Preconditions.checkState((!this.isRunning() && !monitor.isRunning() ? 1 : 0) != 0, (Object)"New monitors can not be added while running.");
        Preconditions.checkState((!this.monitors.contains(monitor) ? 1 : 0) != 0, (Object)"The monitor is already registered in the composite.");
        Preconditions.checkState((!this.names.contains(name) ? 1 : 0) != 0, (Object)("A monitor is already registered under the name " + name));
        this.monitors.add(monitor);
        this.names.add(name);
        monitor.setListener(this);
    }

    @Override
    public synchronized void start() {
        this.running = true;
        for (ViewpointResourceMonitor monitor : this.monitors) {
            monitor.start();
        }
    }

    @Override
    public synchronized void stop() {
        for (ViewpointResourceMonitor monitor : this.monitors) {
            monitor.stop();
        }
        this.origins.clear();
        this.running = false;
    }

    public boolean canMask(URI override, URI shadowed) {
        return this.compare(override, shadowed) > 0;
    }

    @Override
    public synchronized void resourceEvent(ViewpointResourceMonitor origin, Set<URI> removed, Set<URI> added, Set<URI> changed) {
        if (this.listener != null) {
            for (URI a : Iterables.concat(added, changed)) {
                this.origins.put(a, origin);
            }
            this.listener.resourceEvent(origin, removed, added, changed);
            for (URI r : removed) {
                this.origins.remove(r);
            }
        }
    }

    @Override
    public synchronized int compare(URI uri1, URI uri2) {
        ViewpointResourceMonitor src1 = this.origins.get(uri1);
        ViewpointResourceMonitor src2 = this.origins.get(uri2);
        if (src1 != null && src2 != null) {
            int index1 = this.monitors.indexOf(src1);
            int index2 = this.monitors.indexOf(src2);
            if (index1 != -1 && index2 != -1) {
                return index1 - index2;
            }
        }
        throw new IllegalArgumentException("Can only compare URIs from detected resources.");
    }
}

