/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.parser;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.sirius.business.api.query.AirDResouceQuery;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.api.session.resource.DResource;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.resource.AirDCrossReferenceAdapter;
import org.eclipse.sirius.business.internal.resource.parser.RepresentationsFileXMIHelper;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ext.base.Option;

public class AirDResourceImpl
extends GMFResource
implements DResource,
AirdResource {
    private static ThreadLocal<Integer> nbLoadInProgress = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            return 0;
        }
    };

    public AirDResourceImpl(URI uri) {
        super(uri);
    }

    protected static void incrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() + 1);
    }

    protected static void decrementLoadInProgress() {
        nbLoadInProgress.set(nbLoadInProgress.get() - 1);
    }

    protected static boolean hasLoadInProgress() {
        return nbLoadInProgress.get() != 0;
    }

    public void setTrackingModification(boolean isTrackingModification) {
    }

    public void load(Map<?, ?> options) throws IOException {
        DslCommonPlugin.PROFILER.startWork("Load aird file");
        AirDResourceImpl.incrementLoadInProgress();
        try {
            super.load(options);
        }
        finally {
            AirDResourceImpl.decrementLoadInProgress();
        }
        DslCommonPlugin.PROFILER.stopWork("Load aird file");
    }

    protected void doUnload() {
        Option<AirDCrossReferenceAdapter> result = new AirDResouceQuery(this).getAirDCrossReferenceAdapter();
        if (result.some()) {
            this.eAdapters().remove(result.get());
        }
        super.doUnload();
    }

    protected XMLHelper createXMLHelper() {
        return new RepresentationsFileXMIHelper((XMLResource)this);
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = RepresentationsFileMigrationService.getInstance().getNewFragment(uriFragment);
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        return super.getEObject(uriFragment);
    }
}

