/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;

public class ControlledResourcesDetector
extends ResourceSetListenerImpl {
    private DAnalysisSessionImpl session;

    public ControlledResourcesDetector(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public void init() {
        this.detectControlledResources();
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public void dispose() {
        if (this.session != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this);
        }
        this.session = null;
    }

    public void detectControlledResources() {
        Collection<Resource> semantics = this.session.getSemanticResources();
        ArrayList resourcesToCheck = new ArrayList(this.session.getTransactionalEditingDomain().getResourceSet().getResources());
        LinkedHashSet<Resource> newControlledResources = new LinkedHashSet<Resource>();
        ArrayList<Resource> controlledResources = new ArrayList<Resource>((Collection<Resource>)this.session.getControlledResources());
        for (Resource resource : Iterables.filter(resourcesToCheck, (Predicate)Predicates.not((Predicate)Predicates.in(controlledResources)))) {
            if (!this.hasControlledRootInSemantics(resource, semantics) || controlledResources.contains(resource)) continue;
            newControlledResources.add(resource);
        }
        if (!newControlledResources.isEmpty()) {
            this.session.getControlledResources().addAll(newControlledResources);
            this.session.transfertNotification(11);
        }
    }

    private boolean hasControlledRootInSemantics(Resource resource, Collection<Resource> semantics) {
        Predicate<EObject> isControlled = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return AdapterFactoryEditingDomain.isControlled((Object)input);
            }
        };
        for (EObject root : Iterables.filter((Iterable)resource.getContents(), (Predicate)isControlled)) {
            Resource rootResource;
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)root);
            if (rootContainer == null || rootContainer == root || !semantics.contains(rootResource = rootContainer.eResource())) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            boolean resourcesWereAdded;
            int change = notif.getEventType();
            boolean bl = resourcesWereAdded = change == 3 || change == 1 || change == 5;
            if (!resourcesWereAdded) continue;
            return new ControlledResourcesDetectionCommand(this.session.getTransactionalEditingDomain());
        }
        return null;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0).and(NotificationFilter.NOT_TOUCH);
    }

    private class ControlledResourcesDetectionCommand
    extends RecordingCommand {
        public ControlledResourcesDetectionCommand(TransactionalEditingDomain domain) {
            super(domain, "Controled resource detection");
        }

        protected void doExecute() {
            ControlledResourcesDetector.this.detectControlledResources();
        }
    }
}

