/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.api.helper.SiriusUtil;

public class ResourceSaveDiagnose {
    private final Resource resourcetoSave;

    public ResourceSaveDiagnose(Resource res) {
        this.resourcetoSave = res;
    }

    public boolean isSaveable() {
        return this.resourcetoSave.getURI().isFile() || this.resourcetoSave.getURI().isPlatformResource() && !SiriusUtil.isModelerDescriptionFile(this.resourcetoSave);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDifferentSerialization(Map<?, ?> options) throws IOException {
        boolean equal;
        block18: {
            this.resourcetoSave.eSetDeliver(false);
            File temporaryFile = File.createTempFile("ResourceSaveHelper", null);
            equal = true;
            try {
                URI temporaryFileURI = URI.createFileURI((String)temporaryFile.getPath());
                URIConverter uriConverter = this.resourcetoSave.getResourceSet() == null ? new ResourceSetImpl().getURIConverter() : this.resourcetoSave.getResourceSet().getURIConverter();
                OutputStream temporaryFileOutputStream = uriConverter.createOutputStream(temporaryFileURI);
                long preSaveTimestamp = this.resourcetoSave.getTimeStamp();
                boolean preSaveIsModified = this.resourcetoSave.isModified();
                try {
                    this.resourcetoSave.save(temporaryFileOutputStream, options);
                }
                finally {
                    temporaryFileOutputStream.close();
                    this.resourcetoSave.setModified(preSaveIsModified);
                    this.resourcetoSave.setTimeStamp(preSaveTimestamp);
                }
                InputStream oldContents = null;
                try {
                    oldContents = uriConverter.createInputStream(this.resourcetoSave.getURI());
                }
                catch (IOException iOException) {
                    equal = false;
                }
                byte[] newContentBuffer = new byte[4000];
                if (oldContents == null) break block18;
                try {
                    InputStream newContents = uriConverter.createInputStream(temporaryFileURI);
                    try {
                        byte[] oldContentBuffer = new byte[4000];
                        int oldLength = oldContents.read(oldContentBuffer);
                        int newLength = newContents.read(newContentBuffer);
                        while ((equal = oldLength == newLength) && oldLength > 0) {
                            int i = 0;
                            while (i < oldLength) {
                                if (oldContentBuffer[i] != newContentBuffer[i]) {
                                    equal = false;
                                    break block18;
                                }
                                ++i;
                            }
                            oldLength = oldContents.read(oldContentBuffer);
                            newLength = newContents.read(newContentBuffer);
                        }
                    }
                    finally {
                        newContents.close();
                    }
                }
                finally {
                    oldContents.close();
                }
            }
            finally {
                temporaryFile.delete();
                this.resourcetoSave.eSetDeliver(true);
            }
        }
        if (!equal) return true;
        return false;
    }
}

